/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.BugreportManager;
import android.os.BugreportParams;
import android.os.ParcelFileDescriptor;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=BugreportManager.class, minSdk=29, isInAndroidSdk=false)
public class ShadowBugreportManager {
    private ParcelFileDescriptor bugreportFd;
    private ParcelFileDescriptor screenshotFd;
    private Executor executor;
    private BugreportManager.BugreportCallback callback;

    @Implementation
    protected void startBugreport(ParcelFileDescriptor bugreportFd, ParcelFileDescriptor screenshotFd, BugreportParams params, Executor executor, BugreportManager.BugreportCallback callback) {
        if (this.isBugreportInProgress()) {
            executor.execute(() -> callback.onError(5));
        } else {
            this.bugreportFd = bugreportFd;
            this.screenshotFd = screenshotFd;
            this.executor = executor;
            this.callback = callback;
        }
    }

    @Implementation
    protected void cancelBugreport() {
        this.executeOnError(2);
    }

    public void executeOnError(int errorCode) {
        if (this.isBugreportInProgress()) {
            BugreportManager.BugreportCallback callback = this.callback;
            this.executor.execute(() -> callback.onError(errorCode));
        }
        this.resetParams();
    }

    public void executeOnFinished() {
        if (this.isBugreportInProgress()) {
            BugreportManager.BugreportCallback callback = this.callback;
            this.executor.execute(() -> ((BugreportManager.BugreportCallback)callback).onFinished());
        }
        this.resetParams();
    }

    public boolean isBugreportInProgress() {
        return this.executor != null && this.callback != null;
    }

    private void resetParams() {
        try {
            this.bugreportFd.close();
            if (this.screenshotFd != null) {
                this.screenshotFd.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bugreportFd = null;
        this.screenshotFd = null;
        this.executor = null;
        this.callback = null;
    }
}

