/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android;

import android.content.res.Configuration;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.robolectric.RuntimeEnvironment;

public class ConfigurationV25 {
    private static String localesToResourceQualifier(List<Locale> locs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < locs.size(); ++i) {
            Locale loc = locs.get(i);
            int l = loc.getLanguage().length();
            if (l == 0) continue;
            int s = loc.getScript().length();
            int c = loc.getCountry().length();
            int v = loc.getVariant().length();
            if (sb.length() != 0) {
                sb.append(",");
            }
            if (l == 2 && s == 0 && (c == 0 || c == 2) && v == 0) {
                sb.append(loc.getLanguage());
                if (c != 2) continue;
                sb.append("-r").append(loc.getCountry());
                continue;
            }
            sb.append("b+");
            sb.append(loc.getLanguage());
            if (s != 0) {
                sb.append("+");
                sb.append(loc.getScript());
            }
            if (c != 0) {
                sb.append("+");
                sb.append(loc.getCountry());
            }
            if (v == 0) continue;
            sb.append("+");
            sb.append(loc.getVariant());
        }
        return sb.toString();
    }

    public static String resourceQualifierString(Configuration config, DisplayMetrics displayMetrics) {
        return ConfigurationV25.resourceQualifierString(config, displayMetrics, true);
    }

    public static String resourceQualifierString(Configuration config, DisplayMetrics displayMetrics, boolean includeSdk) {
        String resourceQualifier2;
        List<Locale> locales;
        ArrayList<String> parts = new ArrayList<String>();
        if (config.mcc != 0) {
            int n = config.mcc;
            parts.add(new StringBuilder(14).append("mcc").append(n).toString());
            if (config.mnc != 0) {
                n = config.mnc;
                parts.add(new StringBuilder(14).append("mnc").append(n).toString());
            }
        }
        if (!(locales = ConfigurationV25.getLocales(config)).isEmpty() && !(resourceQualifier2 = ConfigurationV25.localesToResourceQualifier(locales)).isEmpty()) {
            parts.add(resourceQualifier2);
        }
        switch (config.screenLayout & 0xC0) {
            case 64: {
                parts.add("ldltr");
                break;
            }
            case 128: {
                parts.add("ldrtl");
                break;
            }
        }
        if (config.smallestScreenWidthDp != 0) {
            int resourceQualifier2 = config.smallestScreenWidthDp;
            parts.add(new StringBuilder(15).append("sw").append(resourceQualifier2).append("dp").toString());
        }
        if (config.screenWidthDp != 0) {
            int resourceQualifier2 = config.screenWidthDp;
            parts.add(new StringBuilder(14).append("w").append(resourceQualifier2).append("dp").toString());
        }
        if (config.screenHeightDp != 0) {
            int resourceQualifier2 = config.screenHeightDp;
            parts.add(new StringBuilder(14).append("h").append(resourceQualifier2).append("dp").toString());
        }
        switch (config.screenLayout & 0xF) {
            case 1: {
                parts.add("small");
                break;
            }
            case 2: {
                parts.add("normal");
                break;
            }
            case 3: {
                parts.add("large");
                break;
            }
            case 4: {
                parts.add("xlarge");
                break;
            }
        }
        switch (config.screenLayout & 0x30) {
            case 32: {
                parts.add("long");
                break;
            }
            case 16: {
                parts.add("notlong");
                break;
            }
        }
        switch (config.screenLayout & 0x300) {
            case 512: {
                parts.add("round");
                break;
            }
            case 256: {
                parts.add("notround");
                break;
            }
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            switch (config.colorMode & 3) {
                case 2: {
                    parts.add("widecg");
                    break;
                }
                case 1: {
                    parts.add("nowidecg");
                    break;
                }
            }
            switch (config.colorMode & 0xC) {
                case 8: {
                    parts.add("highdr");
                    break;
                }
                case 4: {
                    parts.add("lowdr");
                    break;
                }
            }
        }
        switch (config.orientation) {
            case 2: {
                parts.add("land");
                break;
            }
            case 1: {
                parts.add("port");
                break;
            }
        }
        switch (config.uiMode & 0xF) {
            case 5: {
                parts.add("appliance");
                break;
            }
            case 2: {
                parts.add("desk");
                break;
            }
            case 4: {
                parts.add("television");
                break;
            }
            case 3: {
                parts.add("car");
                break;
            }
            case 6: {
                parts.add("watch");
                break;
            }
            case 7: {
                parts.add("vrheadset");
                break;
            }
        }
        switch (config.uiMode & 0x30) {
            case 32: {
                parts.add("night");
                break;
            }
            case 16: {
                parts.add("notnight");
                break;
            }
        }
        int densityDpi = RuntimeEnvironment.getApiLevel() > 16 ? config.densityDpi : displayMetrics.densityDpi;
        switch (densityDpi) {
            case 0: {
                break;
            }
            case 120: {
                parts.add("ldpi");
                break;
            }
            case 160: {
                parts.add("mdpi");
                break;
            }
            case 213: {
                parts.add("tvdpi");
                break;
            }
            case 240: {
                parts.add("hdpi");
                break;
            }
            case 320: {
                parts.add("xhdpi");
                break;
            }
            case 480: {
                parts.add("xxhdpi");
                break;
            }
            case 640: {
                parts.add("xxxhdpi");
                break;
            }
            case 65534: {
                parts.add("anydpi");
                break;
            }
            case 65535: {
                parts.add("nodpi");
                break;
            }
            default: {
                parts.add(new StringBuilder(14).append(densityDpi).append("dpi").toString());
            }
        }
        switch (config.touchscreen) {
            case 1: {
                parts.add("notouch");
                break;
            }
            case 3: {
                parts.add("finger");
                break;
            }
        }
        switch (config.keyboardHidden) {
            case 1: {
                parts.add("keysexposed");
                break;
            }
            case 2: {
                parts.add("keyshidden");
                break;
            }
            case 3: {
                parts.add("keyssoft");
                break;
            }
        }
        switch (config.keyboard) {
            case 1: {
                parts.add("nokeys");
                break;
            }
            case 2: {
                parts.add("qwerty");
                break;
            }
            case 3: {
                parts.add("12key");
                break;
            }
        }
        switch (config.navigationHidden) {
            case 1: {
                parts.add("navexposed");
                break;
            }
            case 2: {
                parts.add("navhidden");
                break;
            }
        }
        switch (config.navigation) {
            case 1: {
                parts.add("nonav");
                break;
            }
            case 2: {
                parts.add("dpad");
                break;
            }
            case 3: {
                parts.add("trackball");
                break;
            }
            case 4: {
                parts.add("wheel");
                break;
            }
        }
        if (includeSdk) {
            int n = Build.VERSION.RESOURCES_SDK_INT;
            parts.add(new StringBuilder(12).append("v").append(n).toString());
        }
        return TextUtils.join((CharSequence)"-", parts);
    }

    private static List<Locale> getLocales(Configuration config) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (RuntimeEnvironment.getApiLevel() > 23) {
            LocaleList localeList = config.getLocales();
            for (int i = 0; i < localeList.size(); ++i) {
                locales.add(localeList.get(i));
            }
        } else if (config.locale != null) {
            locales.add(config.locale);
        }
        return locales;
    }
}

