/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.PersistableBundle;
import android.os.SystemProperties;
import android.telecom.PhoneAccountHandle;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=TelephonyManager.class, looseSignatures=true)
public class ShadowTelephonyManager {
    @RealObject
    protected TelephonyManager realTelephonyManager;
    private final Map<PhoneStateListener, Integer> phoneStateRegistrations = new HashMap<PhoneStateListener, Integer>();
    private final Map<Integer, String> slotIndexToDeviceId = new HashMap<Integer, String>();
    private final Map<Integer, String> slotIndexToImei = new HashMap<Integer, String>();
    private final Map<Integer, String> slotIndexToMeid = new HashMap<Integer, String>();
    private final Map<PhoneAccountHandle, Boolean> voicemailVibrationEnabledMap = new HashMap<PhoneAccountHandle, Boolean>();
    private final Map<PhoneAccountHandle, Uri> voicemailRingtoneUriMap = new HashMap<PhoneAccountHandle, Uri>();
    private final Map<PhoneAccountHandle, TelephonyManager> phoneAccountToTelephonyManagers = new HashMap<PhoneAccountHandle, TelephonyManager>();
    private PhoneStateListener lastListener;
    private int lastEventFlags;
    private String deviceId;
    private String imei;
    private String meid;
    private String groupIdLevel1;
    private String networkOperatorName = "";
    private String networkCountryIso;
    private String networkOperator = "";
    private String simOperator;
    private String simOperatorName;
    private String simSerialNumber;
    private boolean readPhoneStatePermission = true;
    private int phoneType = 1;
    private String line1Number;
    private int networkType;
    private int voiceNetworkType = 0;
    private List<CellInfo> allCellInfo = Collections.emptyList();
    private CellLocation cellLocation = null;
    private int callState = 0;
    private String incomingPhoneNumber = null;
    private boolean isSmsCapable = true;
    private String voiceMailNumber;
    private String voiceMailAlphaTag;
    private int phoneCount = 1;
    private Map<Integer, TelephonyManager> subscriptionIdsToTelephonyManagers = new HashMap<Integer, TelephonyManager>();
    private PersistableBundle carrierConfig;
    private ServiceState serviceState;
    private boolean isNetworkRoaming;
    private final SparseIntArray simStates = new SparseIntArray();
    private final SparseIntArray currentPhoneTypes = new SparseIntArray();
    private final SparseArray<List<String>> carrierPackageNames = new SparseArray();
    private final Map<Integer, String> simCountryIsoMap = new HashMap<Integer, String>();
    private int simCarrierId;
    private String subscriberId;
    private Object uiccSlotInfos;
    private String visualVoicemailPackageName = null;
    private SignalStrength signalStrength;
    private boolean dataEnabled = false;

    public ShadowTelephonyManager() {
        this.resetSimStates();
        this.resetSimCountryIsos();
    }

    @Implementation
    protected void listen(PhoneStateListener listener, int flags) {
        this.lastListener = listener;
        this.lastEventFlags = flags;
        if (flags == 0) {
            this.phoneStateRegistrations.remove(listener);
        } else {
            this.initListener(listener, flags);
            this.phoneStateRegistrations.put(listener, flags);
        }
    }

    @Deprecated
    public PhoneStateListener getListener() {
        return this.lastListener;
    }

    @Deprecated
    public int getEventFlags() {
        return this.lastEventFlags;
    }

    @Implementation
    protected int getCallState() {
        return this.callState;
    }

    public void setCallState(int callState) {
        this.setCallState(callState, null);
    }

    public void setCallState(int callState, String incomingPhoneNumber) {
        if (callState != 1) {
            incomingPhoneNumber = null;
        }
        this.callState = callState;
        this.incomingPhoneNumber = incomingPhoneNumber;
        for (PhoneStateListener listener : this.getListenersForFlags(32)) {
            listener.onCallStateChanged(callState, incomingPhoneNumber);
        }
    }

    @Implementation
    protected String getDeviceId() {
        this.checkReadPhoneStatePermission();
        return this.deviceId;
    }

    public void setDeviceId(String newDeviceId) {
        this.deviceId = newDeviceId;
    }

    public void setNetworkOperatorName(String networkOperatorName) {
        this.networkOperatorName = networkOperatorName;
    }

    @Implementation(minSdk=21)
    protected String getImei() {
        this.checkReadPhoneStatePermission();
        return this.imei;
    }

    @Implementation(minSdk=26)
    protected String getImei(int slotIndex) {
        this.checkReadPhoneStatePermission();
        return this.slotIndexToImei.get(slotIndex);
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public void setImei(int slotIndex, String imei) {
        this.slotIndexToImei.put(slotIndex, imei);
    }

    @Implementation(minSdk=26)
    protected String getMeid() {
        this.checkReadPhoneStatePermission();
        return this.meid;
    }

    @Implementation(minSdk=26)
    protected String getMeid(int slotIndex) {
        this.checkReadPhoneStatePermission();
        return this.slotIndexToMeid.get(slotIndex);
    }

    public void setMeid(String meid) {
        this.meid = meid;
    }

    public void setMeid(int slotIndex, String meid) {
        this.slotIndexToMeid.put(slotIndex, meid);
    }

    @Implementation
    protected String getNetworkOperatorName() {
        return this.networkOperatorName;
    }

    public void setNetworkCountryIso(String networkCountryIso) {
        this.networkCountryIso = networkCountryIso;
    }

    @Implementation
    protected String getNetworkCountryIso() {
        return this.networkCountryIso;
    }

    public void setNetworkOperator(String networkOperator) {
        this.networkOperator = networkOperator;
    }

    @Implementation
    protected String getNetworkOperator() {
        return this.networkOperator;
    }

    @Implementation
    protected String getSimOperator() {
        return this.simOperator;
    }

    public void setSimOperator(String simOperator) {
        this.simOperator = simOperator;
    }

    @Implementation
    protected String getSimOperatorName() {
        return this.simOperatorName;
    }

    public void setSimOperatorName(String simOperatorName) {
        this.simOperatorName = simOperatorName;
    }

    @Implementation
    protected String getSimSerialNumber() {
        this.checkReadPhoneStatePermission();
        return this.simSerialNumber;
    }

    public void setSimSerialNumber(String simSerialNumber) {
        this.simSerialNumber = simSerialNumber;
    }

    @Implementation
    protected String getSimCountryIso() {
        return this.simCountryIsoMap.get(0);
    }

    @Implementation(minSdk=24)
    @HiddenApi
    protected String getSimCountryIso(int subId) {
        return this.simCountryIsoMap.get(subId);
    }

    public void setSimCountryIso(String simCountryIso) {
        this.setSimCountryIso(0, simCountryIso);
    }

    public void setSimCountryIso(int subId, String simCountryIso) {
        this.simCountryIsoMap.put(subId, simCountryIso);
    }

    public void resetSimCountryIsos() {
        this.simCountryIsoMap.clear();
        this.simCountryIsoMap.put(0, "");
    }

    @Implementation
    protected int getSimState() {
        return this.getSimState(0);
    }

    public void setSimState(int simState) {
        this.setSimState(0, simState);
    }

    public void setSimState(int slotIndex, int state) {
        this.simStates.put(slotIndex, state);
    }

    @Implementation(minSdk=26)
    protected int getSimState(int slotIndex) {
        return this.simStates.get(slotIndex, 0);
    }

    public void setUiccSlotsInfo(Object uiccSlotsInfos) {
        this.uiccSlotInfos = uiccSlotsInfos;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected Object getUiccSlotsInfo() {
        return this.uiccSlotInfos;
    }

    public void resetSimStates() {
        this.simStates.clear();
        this.simStates.put(0, 5);
    }

    public void setReadPhoneStatePermission(boolean readPhoneStatePermission) {
        this.readPhoneStatePermission = readPhoneStatePermission;
    }

    private void checkReadPhoneStatePermission() {
        if (!this.readPhoneStatePermission) {
            throw new SecurityException();
        }
    }

    @Implementation
    protected int getPhoneType() {
        return this.phoneType;
    }

    public void setPhoneType(int phoneType) {
        this.phoneType = phoneType;
    }

    @Implementation
    protected String getLine1Number() {
        return this.line1Number;
    }

    public void setLine1Number(String line1Number) {
        this.line1Number = line1Number;
    }

    @Implementation
    protected int getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(int networkType) {
        this.networkType = networkType;
    }

    @Implementation(minSdk=24)
    protected int getVoiceNetworkType() {
        return this.voiceNetworkType;
    }

    public void setVoiceNetworkType(int voiceNetworkType) {
        this.voiceNetworkType = voiceNetworkType;
    }

    @Implementation(minSdk=17)
    protected List<CellInfo> getAllCellInfo() {
        return this.allCellInfo;
    }

    public void setAllCellInfo(List<CellInfo> allCellInfo) {
        this.allCellInfo = allCellInfo;
        if (Build.VERSION.SDK_INT >= 17) {
            for (PhoneStateListener listener : this.getListenersForFlags(1024)) {
                listener.onCellInfoChanged(allCellInfo);
            }
        }
    }

    @Implementation
    protected CellLocation getCellLocation() {
        return this.cellLocation;
    }

    public void setCellLocation(CellLocation cellLocation) {
        this.cellLocation = cellLocation;
        for (PhoneStateListener listener : this.getListenersForFlags(16)) {
            listener.onCellLocationChanged(cellLocation);
        }
    }

    @Implementation(minSdk=18)
    protected String getGroupIdLevel1() {
        return this.groupIdLevel1;
    }

    public void setGroupIdLevel1(String groupIdLevel1) {
        this.groupIdLevel1 = groupIdLevel1;
    }

    private void initListener(PhoneStateListener listener, int flags) {
        if ((flags & 0x20) != 0) {
            listener.onCallStateChanged(this.callState, this.incomingPhoneNumber);
        }
        if ((flags & 0x400) != 0 && Build.VERSION.SDK_INT >= 17) {
            listener.onCellInfoChanged(this.allCellInfo);
        }
        if ((flags & 0x10) != 0) {
            listener.onCellLocationChanged(this.cellLocation);
        }
    }

    private Iterable<PhoneStateListener> getListenersForFlags(final int flags) {
        return Iterables.filter(this.phoneStateRegistrations.keySet(), (Predicate)new Predicate<PhoneStateListener>(){

            public boolean apply(PhoneStateListener input) {
                return ((Integer)ShadowTelephonyManager.this.phoneStateRegistrations.get(input) & flags) != 0;
            }
        });
    }

    @Implementation
    protected boolean isSmsCapable() {
        return this.isSmsCapable;
    }

    public void setIsSmsCapable(boolean isSmsCapable) {
        this.isSmsCapable = isSmsCapable;
    }

    @Implementation(minSdk=26)
    protected PersistableBundle getCarrierConfig() {
        return this.carrierConfig != null ? this.carrierConfig : new PersistableBundle();
    }

    public void setCarrierConfig(PersistableBundle carrierConfig) {
        this.carrierConfig = carrierConfig;
    }

    @Implementation
    protected String getVoiceMailNumber() {
        return this.voiceMailNumber;
    }

    public void setVoiceMailNumber(String voiceMailNumber) {
        this.voiceMailNumber = voiceMailNumber;
    }

    @Implementation
    protected String getVoiceMailAlphaTag() {
        return this.voiceMailAlphaTag;
    }

    public void setVoiceMailAlphaTag(String voiceMailAlphaTag) {
        this.voiceMailAlphaTag = voiceMailAlphaTag;
    }

    @Implementation(minSdk=23)
    protected int getPhoneCount() {
        return this.phoneCount;
    }

    public void setPhoneCount(int phoneCount) {
        this.phoneCount = phoneCount;
    }

    @Implementation(minSdk=23)
    protected String getDeviceId(int slot) {
        return this.slotIndexToDeviceId.get(slot);
    }

    public void setDeviceId(int slot, String deviceId) {
        this.slotIndexToDeviceId.put(slot, deviceId);
    }

    @Implementation(minSdk=24)
    protected boolean isVoicemailVibrationEnabled(PhoneAccountHandle handle) {
        Boolean result = this.voicemailVibrationEnabledMap.get(handle);
        return result != null ? result : false;
    }

    @Implementation(minSdk=26)
    protected void setVoicemailVibrationEnabled(PhoneAccountHandle handle, boolean isEnabled) {
        this.voicemailVibrationEnabledMap.put(handle, isEnabled);
    }

    @Implementation(minSdk=24)
    protected Uri getVoicemailRingtoneUri(PhoneAccountHandle handle) {
        return this.voicemailRingtoneUriMap.get(handle);
    }

    @Implementation(minSdk=26)
    protected void setVoicemailRingtoneUri(PhoneAccountHandle handle, Uri uri) {
        this.voicemailRingtoneUriMap.put(handle, uri);
    }

    @Implementation(minSdk=26)
    protected TelephonyManager createForPhoneAccountHandle(PhoneAccountHandle handle) {
        return this.phoneAccountToTelephonyManagers.get(handle);
    }

    public void setTelephonyManagerForHandle(PhoneAccountHandle handle, TelephonyManager telephonyManager) {
        this.phoneAccountToTelephonyManagers.put(handle, telephonyManager);
    }

    @Implementation(minSdk=24)
    protected TelephonyManager createForSubscriptionId(int subId) {
        return this.subscriptionIdsToTelephonyManagers.get(subId);
    }

    public void setTelephonyManagerForSubscriptionId(int subscriptionId, TelephonyManager telephonyManager) {
        this.subscriptionIdsToTelephonyManagers.put(subscriptionId, telephonyManager);
    }

    @Implementation(minSdk=26)
    protected ServiceState getServiceState() {
        return this.serviceState;
    }

    public void setServiceState(ServiceState serviceState) {
        this.serviceState = serviceState;
    }

    @Implementation
    protected boolean isNetworkRoaming() {
        return this.isNetworkRoaming;
    }

    public void setIsNetworkRoaming(boolean isNetworkRoaming) {
        this.isNetworkRoaming = isNetworkRoaming;
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected int getCurrentPhoneType(int subId) {
        return this.currentPhoneTypes.get(subId, 0);
    }

    public void setCurrentPhoneType(int subId, int phoneType) {
        this.currentPhoneTypes.put(subId, phoneType);
    }

    public void clearPhoneTypes() {
        this.currentPhoneTypes.clear();
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected List<String> getCarrierPackageNamesForIntentAndPhone(Intent intent, int phoneId) {
        return (List)this.carrierPackageNames.get(phoneId);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected List<String> getCarrierPackageNamesForIntent(Intent intent) {
        return (List)this.carrierPackageNames.get(Integer.MAX_VALUE);
    }

    public void setCarrierPackageNamesForPhone(int phoneId, List<String> packages) {
        this.carrierPackageNames.put(phoneId, packages);
    }

    @Implementation(minSdk=28)
    protected int getSimCarrierId() {
        return this.simCarrierId;
    }

    public void setSimCarrierId(int simCarrierId) {
        this.simCarrierId = simCarrierId;
    }

    @Implementation
    protected String getSubscriberId() {
        return this.subscriberId;
    }

    public void setSubscriberId(String subscriberId) {
        this.subscriberId = subscriberId;
    }

    @Implementation(minSdk=26)
    protected String getVisualVoicemailPackageName() {
        return this.visualVoicemailPackageName;
    }

    public void setVisualVoicemailPackageName(String visualVoicemailPackageName) {
        this.visualVoicemailPackageName = visualVoicemailPackageName;
    }

    @Implementation(minSdk=28)
    protected SignalStrength getSignalStrength() {
        return this.signalStrength;
    }

    public void setSignalStrength(SignalStrength signalStrength) {
        this.signalStrength = signalStrength;
        for (PhoneStateListener listener : this.getListenersForFlags(256)) {
            listener.onSignalStrengthsChanged(signalStrength);
        }
    }

    @Implementation(minSdk=10000)
    protected boolean isCurrentEmergencyNumber(String number) {
        if (number == null) {
            return false;
        }
        Context context = (Context)ReflectionHelpers.getField((Object)this.realTelephonyManager, (String)"mContext");
        Locale locale = context == null ? null : context.getResources().getConfiguration().locale;
        String defaultCountryIso = locale == null ? null : locale.getCountry();
        int slotId = -1;
        boolean useExactMatch = true;
        String ecclist = slotId <= 0 ? "ril.ecclist" : "ril.ecclist" + slotId;
        String emergencyNumbers = SystemProperties.get((String)ecclist, (String)"");
        if (TextUtils.isEmpty((CharSequence)emergencyNumbers)) {
            emergencyNumbers = SystemProperties.get((String)"ro.ril.ecclist");
        }
        if (!TextUtils.isEmpty((CharSequence)emergencyNumbers)) {
            for (String emergencyNum : emergencyNumbers.split(",")) {
                if (!(useExactMatch || "BR".equalsIgnoreCase(defaultCountryIso) ? number.equals(emergencyNum) : number.startsWith(emergencyNum))) continue;
                return true;
            }
            return false;
        }
        emergencyNumbers = slotId < 0 ? "112,911,000,08,110,118,119,999" : "112,911";
        for (String emergencyNum : emergencyNumbers.split(",")) {
            if (!(useExactMatch ? number.equals(emergencyNum) : number.startsWith(emergencyNum))) continue;
            return true;
        }
        return false;
    }

    @Implementation(minSdk=10000)
    protected boolean isCurrentPotentialEmergencyNumber(String number) {
        return this.isCurrentEmergencyNumber(number);
    }

    @Implementation(minSdk=26)
    protected boolean isDataEnabled() {
        return this.dataEnabled;
    }

    @Implementation(minSdk=26)
    protected void setDataEnabled(boolean enabled) {
        this.dataEnabled = enabled;
    }
}

