/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SystemClock;
import java.time.Duration;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.shadows.LooperShadowPicker;
import org.robolectric.shadows.ShadowLegacySystemClock;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowPausedSystemClock;
import org.robolectric.shadows.ShadowSystem;

@Implements(value=SystemClock.class, shadowPicker=Picker.class)
public abstract class ShadowSystemClock {
    protected static boolean networkTimeAvailable = true;

    public static long currentTimeMillis() {
        return ShadowLegacySystemClock.currentTimeMillis();
    }

    @Deprecated
    public static long nanoTime() {
        return ShadowSystem.nanoTime();
    }

    public static void setNanoTime(long nanoTime) {
        ShadowLooper.assertLooperMode(LooperMode.Mode.LEGACY);
        ShadowLegacySystemClock.setNanoTime(nanoTime);
    }

    public static void setNetworkTimeAvailable(boolean available) {
        networkTimeAvailable = available;
    }

    public static void advanceBy(Duration duration) {
        SystemClock.setCurrentTimeMillis((long)(SystemClock.uptimeMillis() + duration.toMillis()));
    }

    public static void reset() {
        networkTimeAvailable = true;
    }

    public static class Picker
    extends LooperShadowPicker<ShadowSystemClock> {
        public Picker() {
            super(ShadowLegacySystemClock.class, ShadowPausedSystemClock.class);
        }
    }
}

