/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Process;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=Process.class)
public class ShadowProcess {
    private static int pid;
    private static int uid;
    private static int tid;
    private static final Object threadPrioritiesLock;
    @GuardedBy(value="threadPrioritiesLock")
    private static final Map<Integer, Integer> threadPriorities;

    @Implementation
    protected static final int myPid() {
        return pid;
    }

    @Implementation
    protected static final int myUid() {
        return uid;
    }

    @Implementation
    protected static final int myTid() {
        return (int)Thread.currentThread().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static final void setThreadPriority(int priority) {
        Object object = threadPrioritiesLock;
        synchronized (object) {
            threadPriorities.put(ShadowProcess.myTid(), priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static final void setThreadPriority(int tid, int priority) {
        Preconditions.checkArgument((priority >= -19 && priority <= 19 ? 1 : 0) != 0, (String)"priority %s out of range. Use a Process.THREAD_PRIORITY_* constant.", (int)priority);
        if (tid == 0) {
            tid = ShadowProcess.myTid();
        }
        Object object = threadPrioritiesLock;
        synchronized (object) {
            threadPriorities.put(tid, priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static final int getThreadPriority(int tid) {
        if (tid == 0) {
            tid = ShadowProcess.myTid();
        }
        Object object = threadPrioritiesLock;
        synchronized (object) {
            return threadPriorities.getOrDefault(tid, 0);
        }
    }

    public static void setUid(int uid) {
        ShadowProcess.uid = uid;
    }

    public static void setPid(int pid) {
        ShadowProcess.pid = pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        pid = 0;
        Object object = threadPrioritiesLock;
        synchronized (object) {
            threadPriorities.clear();
        }
    }

    static int getRandomApplicationUid() {
        return ThreadLocalRandom.current().nextInt(10000, 20000);
    }

    static {
        uid = ShadowProcess.getRandomApplicationUid();
        tid = ShadowProcess.getRandomApplicationUid();
        threadPrioritiesLock = new Object();
        threadPriorities = new HashMap<Integer, Integer>();
    }
}

