/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ColorSpace;
import android.graphics.ImageDecoder;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.Size;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ImageUtil;
import org.robolectric.shadows.ShadowAssetInputStream;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ImageDecoder.class, isInAndroidSdk=false, minSdk=28)
public class ShadowImageDecoder {
    private static final NativeObjRegistry<CppImageDecoder> NATIVE_IMAGE_DECODER_REGISTRY = new NativeObjRegistry(CppImageDecoder.class);
    @RealObject
    private ImageDecoder realObject;

    private static ImageDecoder jniCreateDecoder(ImgStream imgStream) {
        CppImageDecoder cppImageDecoder = new CppImageDecoder(imgStream);
        long cppImageDecoderPtr = NATIVE_IMAGE_DECODER_REGISTRY.register((Object)cppImageDecoder);
        return (ImageDecoder)ReflectionHelpers.callConstructor(ImageDecoder.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)cppImageDecoderPtr), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)imgStream.getWidth()), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)imgStream.getHeight()), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)imgStream.isAnimated()), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)imgStream.isNinePatch())});
    }

    static ImageDecoder ImageDecoder_nCreateFd(FileDescriptor fileDescriptor, ImageDecoder.Source source) {
        throw new UnsupportedOperationException();
    }

    static ImageDecoder ImageDecoder_nCreateInputStream(final InputStream is, byte[] storage, ImageDecoder.Source source) {
        return ShadowImageDecoder.jniCreateDecoder(new ImgStream(){

            @Override
            protected InputStream getInputStream() {
                return is;
            }
        });
    }

    static ImageDecoder ImageDecoder_nCreateAsset(long asset_ptr, ImageDecoder.Source source) throws ImageDecoder.DecodeException {
        Resources resources = (Resources)ReflectionHelpers.getField((Object)source, (String)"mResources");
        final AssetManager.AssetInputStream assetInputStream = ShadowAssetInputStream.createAssetInputStream(null, asset_ptr, resources.getAssets());
        return ShadowImageDecoder.jniCreateDecoder(new ImgStream(){

            @Override
            protected InputStream getInputStream() {
                return assetInputStream;
            }
        });
    }

    static ImageDecoder ImageDecoder_nCreateByteBuffer(final ByteBuffer jbyteBuffer, int initialPosition, int limit, ImageDecoder.Source source) throws ImageDecoder.DecodeException {
        return ShadowImageDecoder.jniCreateDecoder(new ImgStream(){

            @Override
            protected InputStream getInputStream() {
                return new ByteArrayInputStream(jbyteBuffer.array());
            }
        });
    }

    static ImageDecoder ImageDecoder_nCreateByteArray(final byte[] byteArray, int offset, int length, ImageDecoder.Source source) {
        return ShadowImageDecoder.jniCreateDecoder(new ImgStream(){

            @Override
            protected InputStream getInputStream() {
                return new ByteArrayInputStream(byteArray);
            }
        });
    }

    protected static Bitmap ImageDecoder_nDecodeBitmap(long nativePtr, ImageDecoder decoder, boolean doPostProcess, int width, int height, Rect cropRect, boolean mutable, int allocator, boolean unpremulRequired, boolean conserveMemory, boolean decodeAsAlphaMask, ColorSpace desiredColorSpace) throws IOException {
        CppImageDecoder cppImageDecoder = (CppImageDecoder)NATIVE_IMAGE_DECODER_REGISTRY.getNativeObject(nativePtr);
        ImgStream imgStream = cppImageDecoder.imgStream;
        InputStream stream = imgStream.getInputStream();
        if (stream == null) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
        if (imgStream.isNinePatch() && ReflectionHelpers.getField((Object)bitmap, (String)"mNinePatchChunk") == null) {
            ReflectionHelpers.setField(Bitmap.class, (Object)bitmap, (String)"mNinePatchChunk", (Object)new byte[0]);
        }
        return bitmap;
    }

    static Size ImageDecoder_nGetSampledSize(long nativePtr, int sampleSize) {
        CppImageDecoder decoder = (CppImageDecoder)NATIVE_IMAGE_DECODER_REGISTRY.getNativeObject(nativePtr);
        throw new UnsupportedOperationException();
    }

    static void ImageDecoder_nGetPadding(long nativePtr, Rect outPadding) {
        CppImageDecoder decoder = (CppImageDecoder)NATIVE_IMAGE_DECODER_REGISTRY.getNativeObject(nativePtr);
        if (decoder.imgStream.isNinePatch()) {
            outPadding.set(0, 0, 0, 0);
        } else {
            outPadding.set(-1, -1, -1, -1);
        }
    }

    static void ImageDecoder_nClose(long nativePtr) {
        NATIVE_IMAGE_DECODER_REGISTRY.unregister(nativePtr);
    }

    static String ImageDecoder_nGetMimeType(long nativePtr) {
        CppImageDecoder decoder = (CppImageDecoder)NATIVE_IMAGE_DECODER_REGISTRY.getNativeObject(nativePtr);
        throw new UnsupportedOperationException();
    }

    static ColorSpace ImageDecoder_nGetColorSpace(long nativePtr) {
        CppImageDecoder decoder = (CppImageDecoder)NATIVE_IMAGE_DECODER_REGISTRY.getNativeObject(nativePtr);
        throw new UnsupportedOperationException();
    }

    @Implementation
    protected static ImageDecoder nCreate(long asset, ImageDecoder.Source source) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nCreateAsset(asset, source);
    }

    @Implementation
    protected static ImageDecoder nCreate(ByteBuffer buffer, int position, int limit, ImageDecoder.Source src) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nCreateByteBuffer(buffer, position, limit, src);
    }

    @Implementation
    protected static ImageDecoder nCreate(byte[] data, int offset, int length, ImageDecoder.Source src) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nCreateByteArray(data, offset, length, src);
    }

    @Implementation
    protected static ImageDecoder nCreate(InputStream is, byte[] storage, ImageDecoder.Source source) {
        return ShadowImageDecoder.ImageDecoder_nCreateInputStream(is, storage, source);
    }

    @Implementation
    protected static ImageDecoder nCreate(FileDescriptor fd, ImageDecoder.Source src) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nCreateFd(fd, src);
    }

    @Implementation(maxSdk=28)
    protected static Bitmap nDecodeBitmap(long nativePtr, ImageDecoder decoder, boolean doPostProcess, int width, int height, Rect cropRect, boolean mutable, int allocator, boolean unpremulRequired, boolean conserveMemory, boolean decodeAsAlphaMask, ColorSpace desiredColorSpace) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nDecodeBitmap(nativePtr, decoder, doPostProcess, width, height, cropRect, mutable, allocator, unpremulRequired, conserveMemory, decodeAsAlphaMask, desiredColorSpace);
    }

    @Implementation(minSdk=10000)
    protected static Bitmap nDecodeBitmap(long nativePtr, ImageDecoder decoder, boolean doPostProcess, int width, int height, Rect cropRect, boolean mutable, int allocator, boolean unpremulRequired, boolean conserveMemory, boolean decodeAsAlphaMask, long desiredColorSpace, boolean extended) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nDecodeBitmap(nativePtr, decoder, doPostProcess, width, height, cropRect, mutable, allocator, unpremulRequired, conserveMemory, decodeAsAlphaMask, null);
    }

    @Implementation
    protected static Size nGetSampledSize(long nativePtr, int sampleSize) {
        return ShadowImageDecoder.ImageDecoder_nGetSampledSize(nativePtr, sampleSize);
    }

    @Implementation
    protected static void nGetPadding(long nativePtr, Rect outRect) {
        ShadowImageDecoder.ImageDecoder_nGetPadding(nativePtr, outRect);
    }

    @Implementation
    protected static void nClose(long nativePtr) {
        ShadowImageDecoder.ImageDecoder_nClose(nativePtr);
    }

    @Implementation
    protected static String nGetMimeType(long nativePtr) {
        return ShadowImageDecoder.ImageDecoder_nGetMimeType(nativePtr);
    }

    @Implementation
    protected static ColorSpace nGetColorSpace(long nativePtr) {
        return ShadowImageDecoder.ImageDecoder_nGetColorSpace(nativePtr);
    }

    private static final class CppImageDecoder {
        private final ImgStream imgStream;

        CppImageDecoder(ImgStream imgStream) {
            this.imgStream = imgStream;
        }
    }

    private static abstract class ImgStream {
        private final int width;
        private final int height;
        private final boolean animated = false;
        private final boolean ninePatch;

        ImgStream() {
            InputStream inputStream = this.getInputStream();
            Point size = ImageUtil.getImageSizeFromStream(inputStream);
            this.width = size == null ? 10 : size.x;
            int n = this.height = size == null ? 10 : size.y;
            if (inputStream instanceof AssetManager.AssetInputStream) {
                ShadowAssetInputStream sis = (ShadowAssetInputStream)Shadow.extract((Object)inputStream);
                this.ninePatch = sis.isNinePatch();
            } else {
                this.ninePatch = false;
            }
        }

        protected abstract InputStream getInputStream();

        int getWidth() {
            return this.width;
        }

        int getHeight() {
            return this.height;
        }

        boolean isAnimated() {
            return false;
        }

        boolean isNinePatch() {
            return this.ninePatch;
        }
    }
}

