/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.util.TypedValue;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.shadows.ShadowBitmapDrawable;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Drawable.class)
public class ShadowDrawable {
    private static int defaultIntrinsicWidth = -1;
    private static int defaultIntrinsicHeight = -1;
    static final List<String> corruptStreamSources = new ArrayList<String>();
    @RealObject
    Drawable realDrawable;
    int createdFromResId = -1;
    InputStream createdFromInputStream;
    private int intrinsicWidth = defaultIntrinsicWidth;
    private int intrinsicHeight = defaultIntrinsicHeight;
    private int alpha;
    private boolean wasInvalidated;

    @Implementation
    protected static Drawable createFromStream(InputStream is, String srcName) {
        if (corruptStreamSources.contains(srcName)) {
            return null;
        }
        BitmapDrawable drawable2 = new BitmapDrawable((Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
        ShadowBitmapDrawable shadowBitmapDrawable = (ShadowBitmapDrawable)Shadow.extract((Object)drawable2);
        shadowBitmapDrawable.createdFromInputStream = is;
        shadowBitmapDrawable.drawableCreateFromStreamSource = srcName;
        shadowBitmapDrawable.validate();
        return drawable2;
    }

    @Implementation
    protected static Drawable createFromResourceStream(Resources res, TypedValue value, InputStream is, String srcName, BitmapFactory.Options opts) {
        if (is == null) {
            return null;
        }
        Rect pad = new Rect();
        if (opts == null) {
            opts = new BitmapFactory.Options();
        }
        opts.inScreenDensity = 160;
        Bitmap bm = BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)opts);
        if (bm != null) {
            byte[] np;
            boolean isNinePatch;
            boolean bl = isNinePatch = srcName != null && srcName.contains(".9.");
            if (isNinePatch) {
                ReflectionHelpers.callInstanceMethod((Object)bm, (String)"setNinePatchChunk", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(byte[].class, (Object)new byte[0])});
            }
            if ((np = bm.getNinePatchChunk()) == null || !NinePatch.isNinePatchChunk((byte[])np)) {
                np = null;
                pad = null;
            }
            if (np != null) {
                return new NinePatchDrawable(res, bm, np, pad, srcName);
            }
            return new BitmapDrawable(res, bm);
        }
        return null;
    }

    @Implementation
    protected static Drawable createFromPath(String pathName) {
        BitmapDrawable drawable2 = new BitmapDrawable((Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
        ShadowBitmapDrawable shadowBitmapDrawable = (ShadowBitmapDrawable)Shadow.extract((Object)drawable2);
        shadowBitmapDrawable.drawableCreateFromPath = pathName;
        shadowBitmapDrawable.validate();
        return drawable2;
    }

    public static Drawable createFromResourceId(int resourceId) {
        Bitmap bitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromResId = resourceId;
        BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
        ShadowBitmapDrawable shadowBitmapDrawable = (ShadowBitmapDrawable)Shadow.extract((Object)drawable2);
        shadowBitmapDrawable.validate();
        shadowBitmapDrawable.createdFromResId = resourceId;
        return drawable2;
    }

    @Implementation
    protected int getIntrinsicWidth() {
        return this.intrinsicWidth;
    }

    @Implementation
    protected int getIntrinsicHeight() {
        return this.intrinsicHeight;
    }

    public static void addCorruptStreamSource(String src) {
        corruptStreamSources.add(src);
    }

    @Resetter
    public static void clearCorruptStreamSources() {
        corruptStreamSources.clear();
    }

    public static void setDefaultIntrinsicWidth(int defaultIntrinsicWidth) {
        ShadowDrawable.defaultIntrinsicWidth = defaultIntrinsicWidth;
    }

    public static void setDefaultIntrinsicHeight(int defaultIntrinsicHeight) {
        ShadowDrawable.defaultIntrinsicHeight = defaultIntrinsicHeight;
    }

    public void setIntrinsicWidth(int intrinsicWidth) {
        this.intrinsicWidth = intrinsicWidth;
    }

    public void setIntrinsicHeight(int intrinsicHeight) {
        this.intrinsicHeight = intrinsicHeight;
    }

    public InputStream getInputStream() {
        return this.createdFromInputStream;
    }

    @Implementation
    protected void setAlpha(int alpha) {
        this.alpha = alpha;
        ((Drawable)Shadow.directlyOn((Object)this.realDrawable, Drawable.class)).setAlpha(alpha);
    }

    @Implementation
    protected void invalidateSelf() {
        this.wasInvalidated = true;
        Shadow.directlyOn((Object)this.realDrawable, Drawable.class, (String)"invalidateSelf", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation(minSdk=19)
    protected int getAlpha() {
        return this.alpha;
    }

    public int getCreatedFromResId() {
        return this.createdFromResId;
    }

    public boolean wasInvalidated() {
        return this.wasInvalidated;
    }

    public void validate() {
        this.wasInvalidated = false;
    }
}

