/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Looper;
import android.os.RemoteException;
import android.util.MergedConfiguration;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.HandlerActionQueue;
import android.view.IWindowSession;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import java.util.ArrayList;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.annotation.TextLayoutMode;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;
import org.robolectric.util.reflector.WithType;

@Implements(value=ViewRootImpl.class, isInAndroidSdk=false)
public class ShadowViewRootImpl {
    @RealObject
    private ViewRootImpl realObject;

    @Implementation(maxSdk=16)
    public static IWindowSession getWindowSession(Looper mainLooper) {
        return null;
    }

    @Implementation
    public void playSoundEffect(int effectId) {
    }

    @Implementation
    protected int relayoutWindow(WindowManager.LayoutParams params, int viewVisibility, boolean insetsPending) throws RemoteException {
        return 0;
    }

    public void callDispatchResized() {
        Display display = this.getDisplay();
        Rect frame = new Rect();
        display.getRectSize(frame);
        ((_ViewRootImpl_)Reflector.reflector(_ViewRootImpl_.class, (Object)this.realObject)).dispatchResized(frame);
    }

    private Display getDisplay() {
        if (RuntimeEnvironment.getApiLevel() > 17) {
            return ((_ViewRootImpl_)Reflector.reflector(_ViewRootImpl_.class, (Object)this.realObject)).getDisplay();
        }
        WindowManager windowManager = (WindowManager)this.realObject.getView().getContext().getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    @Implementation
    protected void setView(View view, WindowManager.LayoutParams attrs, View panelParentView) {
        Shadow.directlyOn((Object)this.realObject, ViewRootImpl.class, (String)"setView", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(View.class, (Object)view), ReflectionHelpers.ClassParameter.from(WindowManager.LayoutParams.class, (Object)attrs), ReflectionHelpers.ClassParameter.from(View.class, (Object)panelParentView)});
        if (ConfigurationRegistry.get(TextLayoutMode.Mode.class) == TextLayoutMode.Mode.REALISTIC) {
            Rect winFrame = new Rect();
            this.getDisplay().getRectSize(winFrame);
            ((_ViewRootImpl_)Reflector.reflector(_ViewRootImpl_.class, (Object)this.realObject)).setWinFrame(winFrame);
        }
    }

    @Resetter
    public static void reset() {
        _ViewRootImpl_ _viewRootImplStatic_ = (_ViewRootImpl_)Reflector.reflector(_ViewRootImpl_.class);
        _viewRootImplStatic_.setRunQueues(new ThreadLocal<HandlerActionQueue>());
        _viewRootImplStatic_.setFirstDrawHandlers(new ArrayList<Runnable>());
        _viewRootImplStatic_.setFirstDrawComplete(false);
        _viewRootImplStatic_.setConfigCallbacks(new ArrayList<ViewRootImpl.ConfigChangedCallback>());
    }

    @ForType(value=ViewRootImpl.class)
    static interface _ViewRootImpl_ {
        @Static
        @Accessor(value="sRunQueues")
        public void setRunQueues(ThreadLocal<HandlerActionQueue> var1);

        @Static
        @Accessor(value="sFirstDrawHandlers")
        public void setFirstDrawHandlers(ArrayList<Runnable> var1);

        @Static
        @Accessor(value="sFirstDrawComplete")
        public void setFirstDrawComplete(boolean var1);

        @Static
        @Accessor(value="sConfigCallbacks")
        public void setConfigCallbacks(ArrayList<ViewRootImpl.ConfigChangedCallback> var1);

        @Accessor(value="mWinFrame")
        public void setWinFrame(Rect var1);

        @Accessor(value="mDisplay")
        public Display getDisplay();

        public void dispatchResized(int var1, int var2, Rect var3, Rect var4, boolean var5, Configuration var6);

        public void dispatchResized(Rect var1, Rect var2, Rect var3, boolean var4, Configuration var5);

        public void dispatchResized(Rect var1, Rect var2, Rect var3, Rect var4, boolean var5, Configuration var6);

        public void dispatchResized(Rect var1, Rect var2, Rect var3, Rect var4, Rect var5, boolean var6, Configuration var7);

        public void dispatchResized(Rect var1, Rect var2, Rect var3, Rect var4, Rect var5, Rect var6, boolean var7, Configuration var8);

        public void dispatchResized(Rect var1, Rect var2, Rect var3, Rect var4, Rect var5, Rect var6, boolean var7, Configuration var8, Rect var9, boolean var10, boolean var11);

        public void dispatchResized(Rect var1, Rect var2, Rect var3, Rect var4, Rect var5, Rect var6, boolean var7, @WithType(value="android.util.MergedConfiguration") Object var8, Rect var9, boolean var10, boolean var11, int var12);

        public void dispatchResized(Rect var1, Rect var2, Rect var3, Rect var4, Rect var5, Rect var6, boolean var7, @WithType(value="android.util.MergedConfiguration") Object var8, Rect var9, boolean var10, boolean var11, int var12, @WithType(value="android.view.DisplayCutout$ParcelableWrapper") Object var13);

        default public void dispatchResized(Rect frame) {
            Rect emptyRect = new Rect(0, 0, 0, 0);
            int apiLevel = RuntimeEnvironment.getApiLevel();
            if (apiLevel <= 16) {
                this.dispatchResized(frame.width(), frame.height(), emptyRect, emptyRect, true, null);
            } else if (apiLevel <= 17) {
                this.dispatchResized(frame, emptyRect, emptyRect, true, null);
            } else if (apiLevel <= 19) {
                this.dispatchResized(frame, emptyRect, emptyRect, emptyRect, true, null);
            } else if (apiLevel <= 22) {
                this.dispatchResized(frame, emptyRect, emptyRect, emptyRect, emptyRect, true, null);
            } else if (apiLevel <= 23) {
                this.dispatchResized(frame, emptyRect, emptyRect, emptyRect, emptyRect, emptyRect, true, null);
            } else if (apiLevel <= 25) {
                this.dispatchResized(frame, emptyRect, emptyRect, emptyRect, emptyRect, emptyRect, true, null, frame, false, false);
            } else if (apiLevel <= 27) {
                this.dispatchResized(frame, emptyRect, emptyRect, emptyRect, emptyRect, emptyRect, true, new MergedConfiguration(), frame, false, false, 0);
            } else {
                this.dispatchResized(frame, emptyRect, emptyRect, emptyRect, emptyRect, emptyRect, true, new MergedConfiguration(), frame, false, false, 0, new DisplayCutout.ParcelableWrapper());
            }
        }
    }
}

