/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=SigningInfo.class, minSdk=28)
public class ShadowSigningInfo {
    private Signature[] signatures;
    private Signature[] pastSigningCertificates;

    public void setSignatures(Signature[] signatures) {
        this.signatures = signatures;
    }

    public void setPastSigningCertificates(Signature[] pastSigningCertificates) {
        this.pastSigningCertificates = pastSigningCertificates;
    }

    @Implementation
    protected boolean hasMultipleSigners() {
        return this.signatures != null && this.signatures.length > 1;
    }

    @Implementation
    protected boolean hasPastSigningCertificates() {
        return this.signatures != null && this.pastSigningCertificates != null;
    }

    @Implementation
    protected Signature[] getSigningCertificateHistory() {
        if (this.hasMultipleSigners()) {
            return null;
        }
        if (!this.hasPastSigningCertificates()) {
            return this.signatures;
        }
        return this.pastSigningCertificates;
    }

    @Implementation
    protected Signature[] getApkContentsSigners() {
        return this.signatures;
    }
}

