/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Build;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import java.time.Duration;
import java.util.ArrayList;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowMessageQueue;
import org.robolectric.shadows.ShadowPausedMessage;
import org.robolectric.shadows.ShadowPausedSystemClock;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Scheduler;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=MessageQueue.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowPausedMessageQueue
extends ShadowMessageQueue {
    @RealObject
    private MessageQueue realQueue;
    private static NativeObjRegistry<ShadowPausedMessageQueue> nativeQueueRegistry = new NativeObjRegistry(ShadowPausedMessageQueue.class);
    private boolean isPolling = false;
    private ShadowPausedSystemClock.Listener clockListener;

    @Implementation
    protected void __constructor__(boolean quitAllowed) {
        Shadow.invokeConstructor(MessageQueue.class, (Object)this.realQueue, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)quitAllowed)});
        int ptr = (int)nativeQueueRegistry.register((Object)this);
        ((ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue)).setPtr(ptr);
        this.clockListener = newCurrentTimeMillis -> this.nativeWake(ptr);
        ShadowPausedSystemClock.addListener(this.clockListener);
    }

    @Implementation(maxSdk=17)
    protected void nativeDestroy() {
        ShadowPausedMessageQueue.nativeDestroy(((ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue)).getPtr());
    }

    @Implementation(minSdk=18, maxSdk=19)
    protected static void nativeDestroy(int ptr) {
        ShadowPausedMessageQueue.nativeDestroy((long)ptr);
    }

    @Implementation(minSdk=20)
    protected static void nativeDestroy(long ptr) {
        ShadowPausedMessageQueue q = (ShadowPausedMessageQueue)nativeQueueRegistry.unregister(ptr);
        ShadowPausedSystemClock.removeListener(q.clockListener);
    }

    @Implementation(maxSdk=17)
    protected void nativePollOnce(int ptr, int timeoutMillis) {
        this.nativePollOnce((long)ptr, timeoutMillis);
    }

    @Implementation(minSdk=18, maxSdk=22)
    protected static void nativePollOnce(Object ptr, Object timeoutMillis) {
        long ptrLong = ShadowPausedMessageQueue.getLong(ptr);
        ((ShadowPausedMessageQueue)nativeQueueRegistry.getNativeObject(ptrLong)).nativePollOnce(ptrLong, (int)((Integer)timeoutMillis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=23)
    protected void nativePollOnce(long ptr, int timeoutMillis) {
        if (timeoutMillis == 0) {
            return;
        }
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            while (this.isIdle() && !this.isQuitting()) {
                this.isPolling = true;
                try {
                    this.realQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.isPolling = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(maxSdk=17)
    protected void nativeWake(int ptr) {
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            this.realQueue.notifyAll();
        }
    }

    @Implementation(minSdk=18, maxSdk=19)
    protected static void nativeWake(Object ptr) {
        ShadowPausedMessageQueue q = (ShadowPausedMessageQueue)nativeQueueRegistry.peekNativeObject(ShadowPausedMessageQueue.getLong(ptr));
        if (q != null) {
            q.nativeWake(ShadowPausedMessageQueue.getInt(ptr));
        }
    }

    @Implementation(minSdk=20)
    protected static void nativeWake(long ptr) {
        ((ShadowPausedMessageQueue)nativeQueueRegistry.getNativeObject(ptr)).nativeWake((int)ptr);
    }

    @Implementation(minSdk=23)
    protected static boolean nativeIsPolling(long ptr) {
        return ((ShadowPausedMessageQueue)ShadowPausedMessageQueue.nativeQueueRegistry.getNativeObject((long)ptr)).isPolling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=23)
    public boolean isIdle() {
        if (Build.VERSION.SDK_INT >= 23) {
            return ((MessageQueue)Shadow.directlyOn((Object)this.realQueue, MessageQueue.class)).isIdle();
        }
        ReflectorMessageQueue internalQueue = (ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue);
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            long now = SystemClock.uptimeMillis();
            Message headMsg = internalQueue.getMessages();
            if (headMsg == null) {
                return true;
            }
            long when = ShadowPausedMessageQueue.shadowOfMsg(headMsg).getWhen();
            boolean bl = now < when;
            return bl;
        }
    }

    Message getNext() {
        return ((ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue)).next();
    }

    boolean isQuitAllowed() {
        return ((ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue)).getQuitAllowed();
    }

    void doEnqueueMessage(Message msg, long when) {
        ((ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue)).enqueueMessage(msg, when);
    }

    Message getMessages() {
        return ((ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue)).getMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPolling() {
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            return this.isPolling;
        }
    }

    void quit() {
        if (RuntimeEnvironment.getApiLevel() >= 18) {
            ((ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue)).quit(false);
        } else {
            ((ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue)).quit();
        }
    }

    private boolean isQuitting() {
        if (RuntimeEnvironment.getApiLevel() >= 19) {
            return ((ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue)).getQuitting();
        }
        return ((ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue)).getQuiting();
    }

    private static long getLong(Object intOrLongObj) {
        if (intOrLongObj instanceof Long) {
            return (Long)intOrLongObj;
        }
        Integer intObj = (Integer)intOrLongObj;
        return intObj.longValue();
    }

    private static int getInt(Object intOrLongObj) {
        if (intOrLongObj instanceof Integer) {
            return (Integer)intOrLongObj;
        }
        Long longObj = (Long)intOrLongObj;
        return longObj.intValue();
    }

    Duration getNextScheduledTaskTime() {
        Message head = this.getMessages();
        if (head == null) {
            return Duration.ZERO;
        }
        return Duration.ofMillis(ShadowPausedMessageQueue.shadowOfMsg(head).getWhen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Duration getLastScheduledTaskTime() {
        long when = 0L;
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            Message next = this.getMessages();
            while (next != null) {
                when = ShadowPausedMessageQueue.shadowOfMsg(next).getWhen();
                next = ShadowPausedMessageQueue.shadowOfMsg(next).internalGetNext();
            }
        }
        return Duration.ofMillis(when);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internalGetSize() {
        int count = 0;
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            Message next = this.getMessages();
            while (next != null) {
                ++count;
                next = ShadowPausedMessageQueue.shadowOfMsg(next).internalGetNext();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message poll() {
        MessageQueue messageQueue = this.realQueue;
        synchronized (messageQueue) {
            Message head = this.getMessages();
            if (head != null) {
                Message next = ShadowPausedMessageQueue.shadowOfMsg(head).internalGetNext();
                ((ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue)).setMessages(next);
            }
            return head;
        }
    }

    @Override
    public void reset() {
        ReflectorMessageQueue msgQueue = (ReflectorMessageQueue)Reflector.reflector(ReflectorMessageQueue.class, (Object)this.realQueue);
        msgQueue.setMessages(null);
        msgQueue.setIdleHandlers(new ArrayList<MessageQueue.IdleHandler>());
        msgQueue.setNextBarrierToken(0);
    }

    private static ShadowPausedMessage shadowOfMsg(Message head) {
        return (ShadowPausedMessage)Shadow.extract((Object)head);
    }

    @Override
    public Scheduler getScheduler() {
        throw new UnsupportedOperationException("Not supported in PAUSED LooperMode.");
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        throw new UnsupportedOperationException("Not supported in PAUSED LooperMode.");
    }

    @Override
    public Message getHead() {
        throw new UnsupportedOperationException("Not supported in PAUSED LooperMode.");
    }

    @Override
    public void setHead(Message msg) {
        throw new UnsupportedOperationException("Not supported in PAUSED LooperMode.");
    }

    @ForType(value=MessageQueue.class)
    private static interface ReflectorMessageQueue {
        public void enqueueMessage(Message var1, long var2);

        public Message next();

        @Accessor(value="mMessages")
        public void setMessages(Message var1);

        @Accessor(value="mMessages")
        public Message getMessages();

        @Accessor(value="mIdleHandlers")
        public void setIdleHandlers(ArrayList<MessageQueue.IdleHandler> var1);

        @Accessor(value="mNextBarrierToken")
        public void setNextBarrierToken(int var1);

        @Accessor(value="mQuitAllowed")
        public boolean getQuitAllowed();

        @Accessor(value="mPtr")
        public void setPtr(int var1);

        @Accessor(value="mPtr")
        public int getPtr();

        public void quit();

        public void quit(boolean var1);

        @Accessor(value="mQuiting")
        public boolean getQuiting();

        @Accessor(value="mQuitting")
        public boolean getQuitting();
    }
}

