/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Rect;
import android.hardware.display.DisplayManagerGlobal;
import android.view.DisplayInfo;
import android.view.InsetsState;
import android.view.WindowInsets;
import android.view.WindowManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowDisplayManagerGlobal;
import org.robolectric.shadows.ShadowInsetsSource;
import org.robolectric.shadows.ShadowInsetsState;
import org.robolectric.shadows.ShadowWindowManagerGlobal;

final class SystemUi {
    public static final StatusBarBehavior NO_STATUS_BAR = new NoStatusBarBehavior();
    public static final StatusBarBehavior STANDARD_STATUS_BAR = new StandardStatusBarBehavior();
    public static final NavigationBarBehavior NO_NAVIGATION_BAR = new NoNavigationBarBehavior();
    public static final NavigationBarBehavior GESTURAL_NAVIGATION = new GesturalNavigationBarBehavior();
    public static final NavigationBarBehavior THREE_BUTTON_NAVIGATION = new ButtonNavigationBarBehavior();
    private final int displayId;
    private final StatusBar statusBar;
    private final NavigationBar navigationBar;
    private final ImmutableList<SystemBar> systemsBars;
    private final List<OnChangeListener> listeners = new ArrayList<OnChangeListener>();

    public static SystemUi systemUiForDefaultDisplay() {
        return SystemUi.systemUiForDisplay(0);
    }

    public static SystemUi systemUiForDisplay(int displayId) {
        return ((ShadowDisplayManagerGlobal)Shadow.extract((Object)DisplayManagerGlobal.getInstance())).getSystemUi(displayId);
    }

    SystemUi(int displayId) {
        this.displayId = displayId;
        this.statusBar = new StatusBar(displayId);
        this.navigationBar = new NavigationBar(displayId);
        this.systemsBars = ImmutableList.of((Object)this.statusBar, (Object)this.navigationBar);
    }

    int getDisplayId() {
        return this.displayId;
    }

    void addListener(OnChangeListener listener) {
        this.listeners.add(listener);
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public StatusBarBehavior getStatusBarBehavior() {
        return this.statusBar.getBehavior();
    }

    public void setStatusBarBehavior(StatusBarBehavior statusBarBehavior) {
        this.statusBar.setBehavior(statusBarBehavior);
    }

    public NavigationBar getNavigationBar() {
        return this.navigationBar;
    }

    public NavigationBarBehavior getNavigationBarBehavior() {
        return this.navigationBar.getBehavior();
    }

    public void setNavigationBarBehavior(NavigationBarBehavior statusBarBehavior) {
        this.navigationBar.setBehavior(statusBarBehavior);
    }

    public void setBehavior(StatusBarBehavior statusBarBehavior, NavigationBarBehavior navigationBarBehavior) {
        this.setStatusBarBehavior(statusBarBehavior);
        this.setNavigationBarBehavior(navigationBarBehavior);
    }

    void adjustFrameForInsets(WindowManager.LayoutParams attrs, Rect outFrame) {
        boolean hideNavigationBar;
        boolean hideStatusBar;
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            hideStatusBar = (attrs.getFitInsetsTypes() & WindowInsets.Type.statusBars()) != 0;
            hideNavigationBar = (attrs.getFitInsetsTypes() & WindowInsets.Type.navigationBars()) != 0;
        } else {
            int systemUiVisibility = attrs.systemUiVisibility | attrs.subtreeSystemUiVisibility;
            hideStatusBar = (systemUiVisibility & 0x400) == 0 && (attrs.flags & 0x100) == 0 && (attrs.flags & 0x4000000) == 0;
            boolean bl = hideNavigationBar = (systemUiVisibility & 0x200) == 0 && (attrs.flags & 0x8000000) == 0;
        }
        if (hideStatusBar) {
            this.statusBar.insetFrame(outFrame);
        }
        if (hideNavigationBar) {
            this.navigationBar.insetFrame(outFrame);
        }
    }

    void putInsets(ShadowWindowManagerGlobal.WindowInfo windowInfo) {
        this.putInsets(windowInfo, windowInfo.contentInsets, false);
        this.putInsets(windowInfo, windowInfo.visibleInsets, false);
        this.putInsets(windowInfo, windowInfo.stableInsets, true);
        if (windowInfo.insetsState != null) {
            this.putInsetsState(windowInfo, windowInfo.insetsState);
        }
    }

    private void putInsets(ShadowWindowManagerGlobal.WindowInfo info, Rect outInsets, boolean includeNotVisible) {
        outInsets.set(0, 0, 0, 0);
        for (SystemBar bar : this.systemsBars) {
            if (!includeNotVisible && !bar.isVisible()) continue;
            bar.putInsets(info.displayFrame, info.frame, outInsets);
        }
    }

    private void putInsetsState(ShadowWindowManagerGlobal.WindowInfo info, InsetsState outInsetsState) {
        outInsetsState.setDisplayFrame(info.frame);
        ShadowInsetsState outShadowInsetsState = (ShadowInsetsState)Shadow.extract((Object)outInsetsState);
        for (SystemBar bar : this.systemsBars) {
            ((ShadowInsetsSource)Shadow.extract((Object)outShadowInsetsState.getOrCreateSource(bar.getId()))).setFrame(bar.inFrame(info.displayFrame, info.frame)).setVisible(bar.isVisible());
        }
    }

    private static int dpToPx(int px, int displayId) {
        return SystemUi.dpToPx(px, DisplayManagerGlobal.getInstance().getDisplayInfo(displayId));
    }

    private static int dpToPx(int px, DisplayInfo displayInfo) {
        float density = (float)displayInfo.logicalDensityDpi / 160.0f;
        return Math.round(density * (float)px);
    }

    public static final class StatusBar
    extends SystemBar {
        private final int displayId;
        private StatusBarBehavior behavior = NO_STATUS_BAR;
        private boolean isVisible = true;

        StatusBar(int displayId) {
            this.displayId = displayId;
        }

        @Override
        int getId() {
            return 0;
        }

        StatusBarBehavior getBehavior() {
            return this.behavior;
        }

        void setBehavior(StatusBarBehavior behavior) {
            this.behavior = behavior;
        }

        @Override
        public boolean isVisible() {
            return this.isVisible;
        }

        boolean setVisible(boolean isVisible) {
            boolean didChange = this.isVisible != isVisible;
            this.isVisible = isVisible;
            return didChange;
        }

        @Override
        public SystemBar.Side getSide() {
            return this.behavior.calculateSide(this.displayId);
        }

        @Override
        public int getSize() {
            return this.behavior.calculateSize(this.displayId);
        }

        @Nonnull
        public String toString() {
            return "StatusBar{isVisible=" + this.isVisible + "}";
        }
    }

    public static final class NavigationBar
    extends SystemBar {
        private final int displayId;
        private NavigationBarBehavior behavior = NO_NAVIGATION_BAR;
        private boolean isVisible = true;

        NavigationBar(int displayId) {
            this.displayId = displayId;
        }

        @Override
        int getId() {
            return 1;
        }

        NavigationBarBehavior getBehavior() {
            return this.behavior;
        }

        void setBehavior(NavigationBarBehavior behavior) {
            this.behavior = behavior;
        }

        @Override
        public boolean isVisible() {
            return this.isVisible;
        }

        boolean setVisible(boolean isVisible) {
            boolean didChange = this.isVisible != isVisible;
            this.isVisible = isVisible;
            return didChange;
        }

        @Override
        public SystemBar.Side getSide() {
            return this.behavior.calculateSide(this.displayId);
        }

        @Override
        public int getSize() {
            return this.behavior.calculateSize(this.displayId);
        }

        @Nonnull
        public String toString() {
            return "NavigationBar{isVisible=" + this.isVisible + "}";
        }
    }

    public static interface StatusBarBehavior
    extends SystemBarBehavior {
    }

    public static interface NavigationBarBehavior
    extends SystemBarBehavior {
    }

    public static abstract class SystemBar {
        SystemBar() {
        }

        abstract int getId();

        public abstract Side getSide();

        public abstract int getSize();

        public abstract boolean isVisible();

        void insetFrame(Rect outFrame) {
            switch (this.getSide().ordinal()) {
                case 0: {
                    outFrame.left += this.getSize();
                    break;
                }
                case 1: {
                    outFrame.top += this.getSize();
                    break;
                }
                case 2: {
                    outFrame.right -= this.getSize();
                    break;
                }
                case 3: {
                    outFrame.bottom -= this.getSize();
                }
            }
        }

        Rect inFrame(Rect displayFrame, Rect frame) {
            switch (this.getSide().ordinal()) {
                case 0: {
                    return new Rect(0, 0, Math.max(0, this.getSize() - frame.left), frame.bottom);
                }
                case 1: {
                    return new Rect(0, 0, frame.right, Math.max(0, this.getSize() - frame.top));
                }
                case 2: {
                    int rightSize = Math.max(0, this.getSize() - (displayFrame.right - frame.right));
                    return new Rect(frame.right - rightSize, 0, frame.right, frame.bottom);
                }
                case 3: {
                    int bottomSize = Math.max(0, this.getSize() - (displayFrame.bottom - frame.bottom));
                    return new Rect(0, frame.bottom - bottomSize, frame.right, frame.bottom);
                }
            }
            throw new IllegalStateException();
        }

        void putInsets(Rect displayFrame, Rect frame, Rect insets) {
            switch (this.getSide().ordinal()) {
                case 0: {
                    insets.left = Math.max(insets.left, this.getSize() - frame.left);
                    break;
                }
                case 1: {
                    insets.top = Math.max(insets.top, this.getSize() - frame.top);
                    break;
                }
                case 2: {
                    insets.right = Math.max(insets.right, this.getSize() - (displayFrame.right - frame.right));
                    break;
                }
                case 3: {
                    insets.bottom = Math.max(insets.bottom, this.getSize() - (displayFrame.bottom - frame.bottom));
                }
            }
        }

        public static enum Side {
            LEFT,
            TOP,
            RIGHT,
            BOTTOM;

        }
    }

    static final class NoStatusBarBehavior
    implements StatusBarBehavior {
        NoStatusBarBehavior() {
        }

        @Override
        public SystemBar.Side calculateSide(int displayId) {
            return SystemBar.Side.TOP;
        }

        @Override
        public int calculateSize(int displayId) {
            return 0;
        }
    }

    static final class StandardStatusBarBehavior
    implements StatusBarBehavior {
        private static final int HEIGHT_DP = 24;

        StandardStatusBarBehavior() {
        }

        @Override
        public SystemBar.Side calculateSide(int displayId) {
            return SystemBar.Side.TOP;
        }

        @Override
        public int calculateSize(int displayId) {
            return SystemUi.dpToPx(24, displayId);
        }
    }

    private static class NoNavigationBarBehavior
    implements NavigationBarBehavior {
        private NoNavigationBarBehavior() {
        }

        @Override
        public SystemBar.Side calculateSide(int displayId) {
            return SystemBar.Side.BOTTOM;
        }

        @Override
        public int calculateSize(int displayId) {
            return 0;
        }
    }

    private static class GesturalNavigationBarBehavior
    implements NavigationBarBehavior {
        private static final int HEIGHT_DP = 24;

        private GesturalNavigationBarBehavior() {
        }

        @Override
        public SystemBar.Side calculateSide(int displayId) {
            return SystemBar.Side.BOTTOM;
        }

        @Override
        public int calculateSize(int displayId) {
            return SystemUi.dpToPx(24, displayId);
        }
    }

    private static class ButtonNavigationBarBehavior
    implements NavigationBarBehavior {
        private static final int BOTTOM_HEIGHT_DP = 48;
        private static final int SIDE_HEIGHT_DP = 42;
        private static final int LARGE_SCREEN_DP = 600;
        private static final int LARGE_SCREEN_HEIGHT_DP = 56;

        private ButtonNavigationBarBehavior() {
        }

        @Override
        public SystemBar.Side calculateSide(int displayId) {
            return this.calculateSide(DisplayManagerGlobal.getInstance().getDisplayInfo(displayId));
        }

        private SystemBar.Side calculateSide(DisplayInfo info) {
            if (this.isLargeScreen(info)) {
                return SystemBar.Side.BOTTOM;
            }
            switch (info.rotation) {
                case 1: {
                    return SystemBar.Side.LEFT;
                }
                case 2: {
                    return SystemBar.Side.RIGHT;
                }
            }
            return SystemBar.Side.BOTTOM;
        }

        @Override
        public int calculateSize(int displayId) {
            DisplayInfo displayInfo = DisplayManagerGlobal.getInstance().getDisplayInfo(displayId);
            int sizeDp = this.isLargeScreen(displayInfo) ? 56 : (this.calculateSide(displayInfo) == SystemBar.Side.BOTTOM ? 48 : 42);
            return SystemUi.dpToPx(sizeDp, displayInfo);
        }

        private boolean isLargeScreen(DisplayInfo info) {
            return Math.max(info.logicalWidth, info.logicalHeight) >= SystemUi.dpToPx(600, info);
        }
    }

    public static interface SystemBarBehavior {
        public SystemBar.Side calculateSide(int var1);

        public int calculateSize(int var1);
    }

    static interface OnChangeListener {
        public void onChange();
    }
}

