/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.speech.IRecognitionService;
import android.speech.RecognitionListener;
import android.speech.RecognitionSupport;
import android.speech.RecognitionSupportCallback;
import android.speech.SpeechRecognizer;
import com.google.common.base.Preconditions;
import java.util.Queue;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=SpeechRecognizer.class)
public class ShadowSpeechRecognizer {
    private static SpeechRecognizer latestSpeechRecognizer;
    private static boolean isOnDeviceRecognitionAvailable;
    @RealObject
    SpeechRecognizer realSpeechRecognizer;
    private final ShadowSpeechRecognizerState state = new ShadowSpeechRecognizerState();

    @Resetter
    public static void reset() {
        latestSpeechRecognizer = null;
        isOnDeviceRecognitionAvailable = true;
    }

    public static SpeechRecognizer getLatestSpeechRecognizer() {
        return latestSpeechRecognizer;
    }

    @Implementation
    protected static SpeechRecognizer createSpeechRecognizer(Context context, ComponentName serviceComponent) {
        SpeechRecognizer result;
        latestSpeechRecognizer = result = ((SpeechRecognizerReflector)Reflector.reflector(SpeechRecognizerReflector.class)).createSpeechRecognizer(context, serviceComponent);
        return result;
    }

    @Implementation(minSdk=33)
    protected static SpeechRecognizer createOnDeviceSpeechRecognizer(Context context) {
        SpeechRecognizer result;
        latestSpeechRecognizer = result = ((SpeechRecognizerReflector)Reflector.reflector(SpeechRecognizerReflector.class)).createOnDeviceSpeechRecognizer(context);
        return result;
    }

    public static void setIsOnDeviceRecognitionAvailable(boolean available) {
        isOnDeviceRecognitionAvailable = available;
    }

    @Implementation(minSdk=33)
    protected static boolean isOnDeviceRecognitionAvailable(Context context) {
        return isOnDeviceRecognitionAvailable;
    }

    protected ShadowSpeechRecognizerState getState() {
        return this.state;
    }

    protected ShadowSpeechRecognizerDirectAccessors getDirectAccessors() {
        return (ShadowSpeechRecognizerDirectAccessors)Reflector.reflector(SpeechRecognizerReflector.class, (Object)this.realSpeechRecognizer);
    }

    public boolean isDestroyed() {
        return this.getState().isRecognizerDestroyed;
    }

    @Implementation(maxSdk=34)
    protected void destroy() {
        this.getState().isRecognizerDestroyed = true;
        this.getDirectAccessors().destroy();
    }

    public Intent getLastRecognizerIntent() {
        return this.getState().recognizerIntent;
    }

    @Implementation(maxSdk=34)
    protected void startListening(Intent recognizerIntent) {
        ShadowSpeechRecognizerState shadowState = this.getState();
        shadowState.recognizerIntent = recognizerIntent;
        shadowState.isRecognizerDestroyed = false;
        new Handler(Looper.getMainLooper()).post(() -> {
            ShadowSpeechRecognizerDirectAccessors directAccessors = this.getDirectAccessors();
            directAccessors.setService(ShadowSpeechRecognizer.createFakeSpeechRecognitionService());
            Handler taskHandler = directAccessors.getHandler();
            Queue<Message> pendingTasks = directAccessors.getPendingTasks();
            while (!pendingTasks.isEmpty()) {
                taskHandler.sendMessage(pendingTasks.poll());
            }
        });
    }

    @Implementation(maxSdk=34)
    protected void handleChangeListener(RecognitionListener listener) {
        this.getState().recognitionListener = listener;
    }

    public void triggerOnEndOfSpeech() {
        this.getState().recognitionListener.onEndOfSpeech();
    }

    public void triggerOnError(int error) {
        this.getState().recognitionListener.onError(error);
    }

    public void triggerOnReadyForSpeech(Bundle bundle) {
        this.getState().recognitionListener.onReadyForSpeech(bundle);
    }

    public void triggerOnPartialResults(Bundle bundle) {
        this.getState().recognitionListener.onPartialResults(bundle);
    }

    public void triggerOnResults(Bundle bundle) {
        this.getState().recognitionListener.onResults(bundle);
    }

    public void triggerOnRmsChanged(float rmsdB) {
        this.getState().recognitionListener.onRmsChanged(rmsdB);
    }

    @Implementation(minSdk=33, maxSdk=34)
    @RequiresApi(api=33)
    protected void checkRecognitionSupport(@Nonnull Intent recognizerIntent, @Nonnull Executor executor, @Nonnull @ClassName(value="android.speech.RecognitionSupportCallback") @ClassName(value="android.speech.RecognitionSupportCallback") Object supportListener) {
        Preconditions.checkArgument((boolean)(supportListener instanceof RecognitionSupportCallback));
        ShadowSpeechRecognizerState shadowState = this.getState();
        shadowState.recognitionSupportExecutor = executor;
        shadowState.recognitionSupportCallback = supportListener;
    }

    @Nullable
    @RequiresApi(value=33)
    public Intent getLatestModelDownloadIntent() {
        return this.getState().latestModelDownloadIntent;
    }

    @Implementation(minSdk=33, maxSdk=34)
    protected void triggerModelDownload(Intent recognizerIntent) {
        this.getState().latestModelDownloadIntent = recognizerIntent;
    }

    @RequiresApi(value=33)
    public void triggerSupportResult(Object recognitionSupport) {
        Preconditions.checkArgument((boolean)(recognitionSupport instanceof RecognitionSupport));
        ShadowSpeechRecognizerState shadowState = this.getState();
        shadowState.recognitionSupportExecutor.execute(() -> ((RecognitionSupportCallback)shadowState.recognitionSupportCallback).onSupportResult((RecognitionSupport)recognitionSupport));
    }

    @RequiresApi(value=33)
    public void triggerSupportError(int error) {
        ShadowSpeechRecognizerState shadowState = this.getState();
        shadowState.recognitionSupportExecutor.execute(() -> ((RecognitionSupportCallback)shadowState.recognitionSupportCallback).onError(error));
    }

    private static IRecognitionService createFakeSpeechRecognitionService() {
        return (IRecognitionService)ReflectionHelpers.createDelegatingProxy(IRecognitionService.class, (Object)new AlwaysAliveSpeechRecognitionServiceDelegate());
    }

    static {
        isOnDeviceRecognitionAvailable = true;
    }

    public static class ShadowSpeechRecognizerState {
        private boolean isRecognizerDestroyed = false;
        private Intent recognizerIntent;
        private RecognitionListener recognitionListener;
        private Executor recognitionSupportExecutor;
        private Object recognitionSupportCallback;
        @Nullable
        private Intent latestModelDownloadIntent;
    }

    @ForType(value=SpeechRecognizer.class)
    static interface SpeechRecognizerReflector
    extends ShadowSpeechRecognizerDirectAccessors {
        @Static
        @Direct
        public SpeechRecognizer createSpeechRecognizer(Context var1, ComponentName var2);

        @Static
        @Direct
        public SpeechRecognizer createOnDeviceSpeechRecognizer(Context var1);

        @Override
        @Direct
        public void destroy();

        @Override
        @Accessor(value="mService")
        public void setService(IRecognitionService var1);

        @Override
        @Accessor(value="mPendingTasks")
        public Queue<Message> getPendingTasks();

        @Override
        @Accessor(value="mHandler")
        public Handler getHandler();
    }

    protected static interface ShadowSpeechRecognizerDirectAccessors {
        public void destroy();

        public void setService(IRecognitionService var1);

        public Queue<Message> getPendingTasks();

        public Handler getHandler();
    }

    private static class AlwaysAliveSpeechRecognitionServiceDelegate {
        private AlwaysAliveSpeechRecognitionServiceDelegate() {
        }

        public IBinder asBinder() {
            return (IBinder)ReflectionHelpers.createDelegatingProxy(IBinder.class, (Object)new AlwaysAliveBinderDelegate());
        }
    }

    private static class AlwaysAliveBinderDelegate {
        private AlwaysAliveBinderDelegate() {
        }

        public boolean isBinderAlive() {
            return true;
        }
    }
}

