/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Camera;
import android.graphics.Matrix;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(className="android.view.RenderNode", isInAndroidSdk=false, maxSdk=28)
public class ShadowRenderNode {
    private static final float NON_ZERO_EPSILON = 0.001f;
    private float alpha = 1.0f;
    private float cameraDistance;
    private boolean clipToOutline;
    private float elevation;
    private boolean overlappingRendering;
    private boolean pivotExplicitlySet;
    private float pivotX;
    private float pivotY;
    private float rotation;
    private float rotationX;
    private float rotationY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float translationX;
    private float translationY;
    private float translationZ;
    private int left;
    private int top;
    private int right;
    private int bottom;

    @Implementation
    protected boolean setAlpha(float alpha) {
        this.alpha = alpha;
        return true;
    }

    @Implementation
    protected float getAlpha() {
        return this.alpha;
    }

    @Implementation
    protected boolean setCameraDistance(float cameraDistance) {
        this.cameraDistance = cameraDistance;
        return true;
    }

    @Implementation
    protected float getCameraDistance() {
        return this.cameraDistance;
    }

    @Implementation
    protected boolean setClipToOutline(boolean clipToOutline) {
        this.clipToOutline = clipToOutline;
        return true;
    }

    @Implementation
    protected boolean getClipToOutline() {
        return this.clipToOutline;
    }

    @Implementation
    protected boolean setElevation(float lift) {
        this.elevation = lift;
        return true;
    }

    @Implementation
    protected float getElevation() {
        return this.elevation;
    }

    @Implementation
    protected boolean setHasOverlappingRendering(boolean overlappingRendering) {
        this.overlappingRendering = overlappingRendering;
        return true;
    }

    @Implementation
    protected boolean hasOverlappingRendering() {
        return this.overlappingRendering;
    }

    @Implementation
    protected boolean setRotation(float rotation) {
        this.rotation = rotation;
        return true;
    }

    @Implementation
    protected float getRotation() {
        return this.rotation;
    }

    @Implementation
    protected boolean setRotationX(float rotationX) {
        this.rotationX = rotationX;
        return true;
    }

    @Implementation
    protected float getRotationX() {
        return this.rotationX;
    }

    @Implementation
    protected boolean setRotationY(float rotationY) {
        this.rotationY = rotationY;
        return true;
    }

    @Implementation
    protected float getRotationY() {
        return this.rotationY;
    }

    @Implementation
    protected boolean setScaleX(float scaleX) {
        this.scaleX = scaleX;
        return true;
    }

    @Implementation
    protected float getScaleX() {
        return this.scaleX;
    }

    @Implementation
    protected boolean setScaleY(float scaleY) {
        this.scaleY = scaleY;
        return true;
    }

    @Implementation
    protected float getScaleY() {
        return this.scaleY;
    }

    @Implementation
    protected boolean setTranslationX(float translationX) {
        this.translationX = translationX;
        return true;
    }

    @Implementation
    protected boolean setTranslationY(float translationY) {
        this.translationY = translationY;
        return true;
    }

    @Implementation
    protected boolean setTranslationZ(float translationZ) {
        this.translationZ = translationZ;
        return true;
    }

    @Implementation
    protected float getTranslationX() {
        return this.translationX;
    }

    @Implementation
    protected float getTranslationY() {
        return this.translationY;
    }

    @Implementation
    protected float getTranslationZ() {
        return this.translationZ;
    }

    @Implementation
    protected boolean isPivotExplicitlySet() {
        return this.pivotExplicitlySet;
    }

    @Implementation(minSdk=28)
    protected boolean resetPivot() {
        this.pivotExplicitlySet = false;
        this.pivotX = 0.0f;
        this.pivotY = 0.0f;
        return true;
    }

    @Implementation
    protected boolean setPivotX(float pivotX) {
        this.pivotX = pivotX;
        this.pivotExplicitlySet = true;
        return true;
    }

    @Implementation
    protected float getPivotX() {
        return this.pivotX;
    }

    @Implementation
    protected boolean setPivotY(float pivotY) {
        this.pivotY = pivotY;
        this.pivotExplicitlySet = true;
        return true;
    }

    @Implementation
    protected float getPivotY() {
        return this.pivotY;
    }

    @Implementation
    protected boolean setLeft(int left) {
        this.left = left;
        return true;
    }

    @Implementation(minSdk=29)
    protected int getLeft() {
        return this.left;
    }

    @Implementation
    protected boolean setTop(int top) {
        this.top = top;
        return true;
    }

    @Implementation(minSdk=29)
    protected int getTop() {
        return this.top;
    }

    @Implementation
    protected boolean setRight(int right) {
        this.right = right;
        return true;
    }

    @Implementation
    protected boolean setBottom(int bottom) {
        this.bottom = bottom;
        return true;
    }

    public int getWidth() {
        return this.right - this.left;
    }

    public int getHeight() {
        return this.bottom - this.top;
    }

    @Implementation
    protected boolean setLeftTopRightBottom(int left, int top, int right, int bottom) {
        return this.setPosition(left, top, right, bottom);
    }

    public boolean setPosition(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        return true;
    }

    @Implementation
    protected boolean offsetLeftAndRight(int offset) {
        this.left += offset;
        this.right += offset;
        return true;
    }

    @Implementation
    protected boolean offsetTopAndBottom(int offset) {
        this.top += offset;
        this.bottom += offset;
        return true;
    }

    @Implementation
    protected void getInverseMatrix(Matrix matrix) {
        this.getMatrix(matrix);
        matrix.invert(matrix);
    }

    @Implementation
    protected void getMatrix(Matrix matrix) {
        if (!this.pivotExplicitlySet) {
            this.pivotX = (float)this.getWidth() / 2.0f;
            this.pivotY = (float)this.getHeight() / 2.0f;
        }
        matrix.reset();
        if (ShadowRenderNode.isZero(this.rotationX) && ShadowRenderNode.isZero(this.rotationY)) {
            matrix.setTranslate(this.translationX, this.translationY);
            matrix.preRotate(this.rotation, this.pivotX, this.pivotY);
            matrix.preScale(this.scaleX, this.scaleY, this.pivotX, this.pivotY);
        } else {
            matrix.preScale(this.scaleX, this.scaleY, this.pivotX, this.pivotY);
            Camera camera = new Camera();
            camera.rotateX(this.rotationX);
            camera.rotateY(this.rotationY);
            camera.rotateZ(-this.rotation);
            Matrix transform = new Matrix();
            camera.getMatrix(transform);
            transform.preTranslate(-this.pivotX, -this.pivotY);
            transform.postTranslate(this.pivotX + this.translationX, this.pivotY + this.translationY);
            matrix.postConcat(transform);
        }
    }

    @Implementation
    protected boolean hasIdentityMatrix() {
        Matrix matrix = new Matrix();
        this.getMatrix(matrix);
        return matrix.isIdentity();
    }

    @Implementation
    protected boolean isValid() {
        return true;
    }

    @Implementation
    protected static boolean nSetLayerType(long renderNode, int layerType) {
        return true;
    }

    @Implementation
    protected static boolean nSetLayerPaint(long renderNode, long paint) {
        return true;
    }

    private static boolean isZero(float value) {
        return Math.abs(value) <= 0.001f;
    }
}

