/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.Process;
import android.os.UserHandle;
import android.permission.PermissionControllerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=PermissionControllerManager.class, minSdk=29, isInAndroidSdk=false)
public class ShadowPermissionControllerManager {
    private static final AtomicBoolean resolveInfoRegistered = new AtomicBoolean();
    private PackageManager packageManager;
    @RealObject
    PermissionControllerManager realObject;

    @Implementation
    protected void __constructor__(@Nonnull Context context, @Nonnull Handler handler) {
        this.packageManager = context.getPackageManager();
        if (resolveInfoRegistered.compareAndSet(false, true)) {
            this.ensureResolveInfoRegistered();
        }
        Shadow.invokeConstructor(PermissionControllerManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler)});
    }

    @Implementation
    protected void revokeRuntimePermissions(@Nonnull Map<String, List<String>> request, boolean doDryRun, int reason, @Nonnull Executor executor, @Nonnull PermissionControllerManager.OnRevokeRuntimePermissionsCallback callback) {
        if (doDryRun) {
            throw new UnsupportedOperationException("Dry run not implemented");
        }
        HashMap result = new HashMap();
        UserHandle userHandle = Process.myUserHandle();
        for (String packageName : request.keySet()) {
            List<String> permissions = request.get(packageName);
            ArrayList<String> revokedPermissions = new ArrayList<String>();
            for (String permission2 : permissions) {
                try {
                    this.packageManager.revokeRuntimePermission(packageName, permission2, userHandle);
                    revokedPermissions.add(permission2);
                }
                catch (RuntimeException runtimeException) {}
            }
            if (revokedPermissions.isEmpty()) continue;
            result.put(packageName, revokedPermissions);
        }
        executor.execute(() -> callback.onRevokeRuntimePermissions(result));
    }

    private void ensureResolveInfoRegistered() {
        Intent intent = new Intent("android.permission.PermissionControllerService");
        intent.setPackage("org.robolectric.permissioncontroller");
        ResolveInfo resolveInfo = new ResolveInfo();
        resolveInfo.serviceInfo = new ServiceInfo();
        resolveInfo.serviceInfo.packageName = "org.robolectric.permissioncontroller";
        resolveInfo.serviceInfo.name = "org.robolectric.permissioncontroller.PermissionControllerManagerService";
        Shadows.shadowOf(this.packageManager).addResolveInfoForIntent(intent, resolveInfo);
    }

    @Resetter
    public static void reset() {
        resolveInfoRegistered.set(false);
    }
}

