/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Path;
import android.graphics.PathMeasure;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.CachedPathIteratorFactory;
import org.robolectric.shadows.ShadowLegacyPath;

@Implements(value=PathMeasure.class)
public class ShadowPathMeasure {
    private CachedPathIteratorFactory mOriginalPathIterator;

    @Implementation
    protected void __constructor__(Path path, boolean forceClosed) {
        if (path != null) {
            ShadowLegacyPath shadowPath = (ShadowLegacyPath)Shadow.extract((Object)path);
            this.mOriginalPathIterator = new CachedPathIteratorFactory(shadowPath.getJavaShape().getPathIterator(null));
        }
    }

    @Implementation
    protected float getLength() {
        if (this.mOriginalPathIterator == null) {
            return 0.0f;
        }
        return this.mOriginalPathIterator.iterator().getTotalLength();
    }

    @Implementation
    protected boolean getPosTan(float distance, float[] pos, float[] tan) {
        if (pos != null && pos.length < 2 || tan != null && tan.length < 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.getLength() > 0.0f) {
            pos[0] = ShadowPathMeasure.round(distance / this.getLength(), 4);
            pos[1] = ShadowPathMeasure.round(distance / this.getLength(), 4);
        }
        return true;
    }

    private static float round(float d, int decimalPlace) {
        BigDecimal bd = new BigDecimal(d);
        bd = bd.setScale(decimalPlace, RoundingMode.HALF_UP);
        return bd.floatValue();
    }
}

