/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.PackageInstaller;
import android.content.pm.VersionedPackage;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.PersistableBundle;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;

@Implements(value=PackageInstaller.class)
@SuppressLint(value={"NewApi"})
public class ShadowPackageInstaller {
    private int nextSessionId = 1;
    private final Map<Integer, PackageInstaller.SessionInfo> sessionInfos = new HashMap<Integer, PackageInstaller.SessionInfo>();
    private final Map<Integer, PackageInstaller.Session> sessions = new HashMap<Integer, PackageInstaller.Session>();
    private final Set<CallbackInfo> callbackInfos = Collections.synchronizedSet(new HashSet());
    private final Map<String, UninstalledPackage> uninstalledPackages = new HashMap<String, UninstalledPackage>();

    @Implementation
    protected List<PackageInstaller.SessionInfo> getAllSessions() {
        return ImmutableList.copyOf(this.sessionInfos.values());
    }

    @Implementation
    protected List<PackageInstaller.SessionInfo> getMySessions() {
        return this.getAllSessions();
    }

    @Implementation
    protected void registerSessionCallback(@Nonnull PackageInstaller.SessionCallback callback, @Nonnull Handler handler) {
        CallbackInfo callbackInfo = new CallbackInfo();
        callbackInfo.callback = callback;
        callbackInfo.handler = handler;
        this.callbackInfos.add(callbackInfo);
    }

    @Implementation
    protected void unregisterSessionCallback(@Nonnull PackageInstaller.SessionCallback callback) {
        Iterator<CallbackInfo> i = this.callbackInfos.iterator();
        while (i.hasNext()) {
            CallbackInfo callbackInfo = i.next();
            if (callbackInfo.callback != callback) continue;
            i.remove();
            return;
        }
    }

    @Implementation
    @Nullable
    protected PackageInstaller.SessionInfo getSessionInfo(int sessionId) {
        return this.sessionInfos.get(sessionId);
    }

    @Implementation
    protected int createSession(@Nonnull PackageInstaller.SessionParams params) throws IOException {
        PackageInstaller.SessionInfo sessionInfo = new PackageInstaller.SessionInfo();
        sessionInfo.sessionId = this.nextSessionId++;
        sessionInfo.active = true;
        sessionInfo.appPackageName = params.appPackageName;
        sessionInfo.appLabel = params.appLabel;
        sessionInfo.appIcon = params.appIcon;
        if (Build.VERSION.SDK_INT >= 28) {
            sessionInfo.installerPackageName = params.installerPackageName;
        }
        this.sessionInfos.put(sessionInfo.getSessionId(), sessionInfo);
        for (CallbackInfo callbackInfo : new ArrayList<CallbackInfo>(this.callbackInfos)) {
            callbackInfo.handler.post(() -> callbackInfo.callback.onCreated(sessionInfo.sessionId));
        }
        return sessionInfo.sessionId;
    }

    @Implementation
    protected void abandonSession(int sessionId) {
        this.sessionInfos.remove(sessionId);
        this.sessions.remove(sessionId);
        for (CallbackInfo callbackInfo : new ArrayList<CallbackInfo>(this.callbackInfos)) {
            callbackInfo.handler.post(() -> callbackInfo.callback.onFinished(sessionId, false));
        }
    }

    @Implementation
    @Nonnull
    protected PackageInstaller.Session openSession(int sessionId) throws IOException {
        if (!this.sessionInfos.containsKey(sessionId)) {
            throw new SecurityException("Invalid session Id: " + sessionId);
        }
        if (this.sessions.containsKey(sessionId) && this.sessions.get(sessionId) != null) {
            return this.sessions.get(sessionId);
        }
        PackageInstaller.Session session = new PackageInstaller.Session(null);
        ShadowSession shadowSession = (ShadowSession)Shadow.extract((Object)session);
        shadowSession.setShadowPackageInstaller(sessionId, this);
        this.sessions.put(sessionId, session);
        return session;
    }

    @Implementation
    protected void updateSessionAppIcon(int sessionId, Bitmap appIcon) {
        PackageInstaller.SessionInfo sessionInfo = this.sessionInfos.get(sessionId);
        if (sessionInfo == null) {
            throw new SecurityException("Invalid session Id: " + sessionId);
        }
        sessionInfo.appIcon = appIcon;
        for (CallbackInfo callbackInfo : new ArrayList<CallbackInfo>(this.callbackInfos)) {
            callbackInfo.handler.post(() -> callbackInfo.callback.onBadgingChanged(sessionId));
        }
    }

    @Implementation
    protected void updateSessionAppLabel(int sessionId, CharSequence appLabel) {
        PackageInstaller.SessionInfo sessionInfo = this.sessionInfos.get(sessionId);
        if (sessionInfo == null) {
            throw new SecurityException("Invalid session Id: " + sessionId);
        }
        sessionInfo.appLabel = appLabel;
        for (CallbackInfo callbackInfo : new ArrayList<CallbackInfo>(this.callbackInfos)) {
            callbackInfo.handler.post(() -> callbackInfo.callback.onBadgingChanged(sessionId));
        }
    }

    @Implementation(minSdk=34)
    protected void uninstall(VersionedPackage versionedPackage, int flags, IntentSender statusReceiver) {
        this.uninstalledPackages.put(versionedPackage.getPackageName(), new UninstalledPackage(versionedPackage.getLongVersionCode(), statusReceiver));
    }

    @Implementation(minSdk=26)
    protected void uninstall(VersionedPackage versionedPackage, IntentSender statusReceiver) {
        if (Build.VERSION.SDK_INT < 28) {
            this.uninstalledPackages.put(versionedPackage.getPackageName(), new UninstalledPackage(Long.valueOf(versionedPackage.getVersionCode()), statusReceiver));
        } else {
            this.uninstalledPackages.put(versionedPackage.getPackageName(), new UninstalledPackage(versionedPackage.getLongVersionCode(), statusReceiver));
        }
    }

    @Implementation
    protected void uninstall(String packageName, IntentSender statusReceiver) {
        this.uninstalledPackages.put(packageName, new UninstalledPackage(-1L, statusReceiver));
    }

    @Implementation(minSdk=31)
    protected void uninstallExistingPackage(String packageName, IntentSender statusReceiver) {
        this.uninstalledPackages.put(packageName, new UninstalledPackage(-1L, statusReceiver));
    }

    public Long getLastUninstalledVersion(String packageName) {
        if (this.uninstalledPackages.get(packageName) == null) {
            return null;
        }
        return this.uninstalledPackages.get((Object)packageName).version;
    }

    public IntentSender getLastUninstalledStatusReceiver(String packageName) {
        if (this.uninstalledPackages.get(packageName) == null) {
            return null;
        }
        return this.uninstalledPackages.get((Object)packageName).intentSender;
    }

    public List<PackageInstaller.SessionCallback> getAllSessionCallbacks() {
        return ImmutableList.copyOf(this.callbackInfos.stream().map(info -> info.callback).iterator());
    }

    public void setSessionProgress(int sessionId, float progress) {
        PackageInstaller.SessionInfo sessionInfo = this.sessionInfos.get(sessionId);
        if (sessionInfo == null) {
            throw new SecurityException("Invalid session Id: " + sessionId);
        }
        sessionInfo.progress = progress;
        for (CallbackInfo callbackInfo : new ArrayList<CallbackInfo>(this.callbackInfos)) {
            callbackInfo.handler.post(() -> callbackInfo.callback.onProgressChanged(sessionId, progress));
        }
    }

    public void setSessionActiveState(int sessionId, boolean active) {
        for (CallbackInfo callbackInfo : new ArrayList<CallbackInfo>(this.callbackInfos)) {
            callbackInfo.handler.post(() -> callbackInfo.callback.onActiveChanged(sessionId, active));
        }
    }

    @Deprecated
    public void setSessionSucceeds(int sessionId) {
        this.setSessionFinishes(sessionId, true);
    }

    public void setSessionFails(int sessionId) {
        this.setSessionFinishes(sessionId, false);
    }

    public void setPreapprovalDialogApproved(int sessionId) throws IntentSender.SendIntentException {
        this.sendPreapprovalUpdate(sessionId, 0);
    }

    public void setPreapprovalDialogDenied(int sessionId) throws IntentSender.SendIntentException {
        this.sendPreapprovalUpdate(sessionId, 1);
    }

    public void setPreapprovalDialogDismissed(int sessionId) throws IntentSender.SendIntentException {
        this.sendPreapprovalUpdate(sessionId, 3);
    }

    private void sendPreapprovalUpdate(int sessionId, int status) throws IntentSender.SendIntentException {
        ShadowSession shadowSession = Shadows.shadowOf(this.sessions.get(sessionId));
        Intent fillIn = new Intent();
        fillIn.putExtra("android.content.pm.extra.SESSION_ID", sessionId);
        fillIn.putExtra("android.content.pm.extra.STATUS", status);
        fillIn.putExtra("android.content.pm.extra.PRE_APPROVAL", true);
        shadowSession.preapprovalStatusReceiver.sendIntent((Context)RuntimeEnvironment.getApplication(), 0, fillIn, null, null, null);
    }

    private void setSessionFinishes(int sessionId, boolean success) {
        for (CallbackInfo callbackInfo : new ArrayList<CallbackInfo>(this.callbackInfos)) {
            callbackInfo.handler.post(() -> callbackInfo.callback.onFinished(sessionId, success));
        }
        PackageInstaller.Session session = this.sessions.get(sessionId);
        ShadowSession shadowSession = (ShadowSession)Shadow.extract((Object)session);
        if (success) {
            try {
                shadowSession.statusReceiver.sendIntent((Context)RuntimeEnvironment.getApplication(), 0, null, null, null, null);
            }
            catch (IntentSender.SendIntentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class CallbackInfo {
        PackageInstaller.SessionCallback callback;
        Handler handler;

        private CallbackInfo() {
        }
    }

    @Implements(value=PackageInstaller.Session.class)
    public static class ShadowSession {
        private OutputStream outputStream;
        private boolean outputStreamOpen;
        private IntentSender statusReceiver;
        private IntentSender preapprovalStatusReceiver;
        private int sessionId;
        private ShadowPackageInstaller shadowPackageInstaller;
        private PersistableBundle appMetadata = new PersistableBundle();

        @Implementation(minSdk=34)
        protected void requestUserPreapproval(@Nonnull @ClassName(value="android.content.pm.PackageInstaller$PreapprovalDetails") @ClassName(value="android.content.pm.PackageInstaller$PreapprovalDetails") Object details, @Nonnull IntentSender statusReceiver) {
            this.preapprovalStatusReceiver = statusReceiver;
        }

        @Implementation(minSdk=34)
        protected void setAppMetadata(@Nullable PersistableBundle data) throws IOException {
            this.appMetadata = data;
        }

        @Implementation(minSdk=34)
        @Nonnull
        protected PersistableBundle getAppMetadata() {
            return this.appMetadata;
        }

        @Implementation
        @Nonnull
        protected OutputStream openWrite(@Nonnull String name, long offsetBytes, long lengthBytes) throws IOException {
            this.outputStream = new OutputStream(){

                @Override
                public void write(int aByte) throws IOException {
                }

                @Override
                public void close() throws IOException {
                    outputStreamOpen = false;
                }
            };
            this.outputStreamOpen = true;
            return this.outputStream;
        }

        @Implementation
        protected void fsync(@Nonnull OutputStream out) throws IOException {
        }

        @Implementation
        protected void commit(@Nonnull IntentSender statusReceiver) {
            this.statusReceiver = statusReceiver;
            if (this.outputStreamOpen) {
                throw new SecurityException("OutputStream still open");
            }
            this.shadowPackageInstaller.setSessionSucceeds(this.sessionId);
        }

        @Implementation
        protected void close() {
        }

        @Implementation
        protected void abandon() {
            this.shadowPackageInstaller.abandonSession(this.sessionId);
        }

        private void setShadowPackageInstaller(int sessionId, ShadowPackageInstaller shadowPackageInstaller) {
            this.sessionId = sessionId;
            this.shadowPackageInstaller = shadowPackageInstaller;
        }
    }

    private static class UninstalledPackage {
        Long version;
        IntentSender intentSender;

        public UninstalledPackage(Long version, IntentSender intentSender) {
            this.version = version;
            this.intentSender = intentSender;
        }
    }

    @Implements(value=PackageInstaller.SessionInfo.class)
    public static class ShadowSessionInfo {
        @RealObject
        private PackageInstaller.SessionInfo sessionInfo;

        @Implementation
        protected Bitmap getAppIcon() {
            return this.sessionInfo.appIcon;
        }
    }
}

