/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Matrix;
import android.os.Parcel;
import android.view.MotionEvent;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadows.NativeBitSet64;
import org.robolectric.shadows.NativeInput;
import org.robolectric.shadows.ShadowInputEvent;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=MotionEvent.class)
public class ShadowMotionEvent
extends ShadowInputEvent {
    private static final NativeObjRegistry<NativeInput.MotionEvent> nativeMotionEventRegistry = new NativeObjRegistry(NativeInput.MotionEvent.class);
    private static final int HISTORY_CURRENT = Integer.MIN_VALUE;
    @RealObject
    private MotionEvent realMotionEvent;

    @Resetter
    public static void reset() {
        ReflectionHelpers.setStaticField(MotionEvent.class, (String)"gRecyclerTop", null);
        ReflectionHelpers.setStaticField(MotionEvent.class, (String)"gSharedTempPointerCoords", null);
        ReflectionHelpers.setStaticField(MotionEvent.class, (String)"gSharedTempPointerProperties", null);
        ReflectionHelpers.setStaticField(MotionEvent.class, (String)"gRecyclerUsed", (Object)0);
        ReflectionHelpers.setStaticField(MotionEvent.class, (String)"gSharedTempPointerIndexMap", null);
    }

    private static void validatePointerCount(int pointerCount) {
        Preconditions.checkState((pointerCount >= 1 ? 1 : 0) != 0, (Object)"pointerCount must be at least 1");
    }

    private static void validatePointerPropertiesArray(MotionEvent.PointerProperties[] pointerPropertiesObjArray, int pointerCount) {
        Objects.requireNonNull(pointerPropertiesObjArray, "pointerProperties array must not be null");
        Preconditions.checkState((pointerPropertiesObjArray.length >= pointerCount ? 1 : 0) != 0, (Object)"pointerProperties array must be large enough to hold all pointers");
    }

    private static void validatePointerCoordsObjArray(MotionEvent.PointerCoords[] pointerCoordsObjArray, int pointerCount) {
        Objects.requireNonNull(pointerCoordsObjArray, "pointerCoords array must not be null");
        Preconditions.checkState((pointerCoordsObjArray.length >= pointerCount ? 1 : 0) != 0, (Object)"pointerCoords array must be large enough to hold all pointers");
    }

    private static void validatePointerIndex(int pointerIndex, int pointerCount) {
        Preconditions.checkState((pointerIndex >= 0 && pointerIndex < pointerCount ? 1 : 0) != 0, (Object)"pointerIndex out of range");
    }

    private static void validateHistoryPos(int historyPos, int historySize) {
        Preconditions.checkState((historyPos >= 0 && historyPos < historySize ? 1 : 0) != 0, (Object)"historyPos out of range");
    }

    private static void validatePointerCoords(MotionEvent.PointerCoords pointerCoordsObj) {
        Objects.requireNonNull(pointerCoordsObj, "pointerCoords must not be null");
    }

    private static void validatePointerProperties(MotionEvent.PointerProperties pointerPropertiesObj) {
        Objects.requireNonNull(pointerPropertiesObj, "pointerProperties must not be null");
    }

    private static NativeInput.PointerCoords pointerCoordsToNative(MotionEvent.PointerCoords pointerCoordsObj, float xOffset, float yOffset) {
        float[] valuesArray;
        NativeInput.PointerCoords outRawPointerCoords = new NativeInput.PointerCoords();
        outRawPointerCoords.clear();
        outRawPointerCoords.setAxisValue(0, pointerCoordsObj.x - xOffset);
        outRawPointerCoords.setAxisValue(1, pointerCoordsObj.y - yOffset);
        outRawPointerCoords.setAxisValue(2, pointerCoordsObj.pressure);
        outRawPointerCoords.setAxisValue(3, pointerCoordsObj.size);
        outRawPointerCoords.setAxisValue(4, pointerCoordsObj.touchMajor);
        outRawPointerCoords.setAxisValue(5, pointerCoordsObj.touchMinor);
        outRawPointerCoords.setAxisValue(6, pointerCoordsObj.toolMajor);
        outRawPointerCoords.setAxisValue(7, pointerCoordsObj.toolMinor);
        outRawPointerCoords.setAxisValue(8, pointerCoordsObj.orientation);
        outRawPointerCoords.setAxisValue(27, pointerCoordsObj.getAxisValue(27));
        outRawPointerCoords.setAxisValue(28, pointerCoordsObj.getAxisValue(28));
        long packedAxisBits = (Long)ReflectionHelpers.getField((Object)pointerCoordsObj, (String)"mPackedAxisBits");
        NativeBitSet64 bits = new NativeBitSet64(packedAxisBits);
        if (!bits.isEmpty() && (valuesArray = (float[])ReflectionHelpers.getField((Object)pointerCoordsObj, (String)"mPackedAxisValues")) != null) {
            int index = 0;
            do {
                int axis = bits.clearFirstMarkedBit();
                outRawPointerCoords.setAxisValue(axis, valuesArray[index++]);
            } while (!bits.isEmpty());
        }
        return outRawPointerCoords;
    }

    private static void pointerCoordsFromNative(NativeInput.PointerCoords rawPointerCoords, float xOffset, float yOffset, MotionEvent.PointerCoords outPointerCoordsObj) {
        outPointerCoordsObj.clear();
        outPointerCoordsObj.x = rawPointerCoords.getAxisValue(0) + xOffset;
        outPointerCoordsObj.y = rawPointerCoords.getAxisValue(1) + yOffset;
        NativeBitSet64 bits = new NativeBitSet64(rawPointerCoords.getBits());
        bits.clearBit(0);
        bits.clearBit(1);
        while (!bits.isEmpty()) {
            int axis = bits.clearFirstMarkedBit();
            outPointerCoordsObj.setAxisValue(axis, rawPointerCoords.getAxisValue(axis));
        }
    }

    @Implementation(maxSdk=28)
    @HiddenApi
    protected static long nativeInitialize(long nativePtr, int deviceId, int source, int action, int flags, int edgeFlags, int metaState, int buttonState, float xOffset, float yOffset, float xPrecision, float yPrecision, long downTimeNanos, long eventTimeNanos, int pointerCount, MotionEvent.PointerProperties[] pointerPropertiesObjArray, MotionEvent.PointerCoords[] pointerCoordsObjArray) {
        return ShadowMotionEvent.nativeInitialize(nativePtr, deviceId, source, 0, action, flags, edgeFlags, metaState, buttonState, 0, xOffset, yOffset, xPrecision, yPrecision, downTimeNanos, eventTimeNanos, pointerCount, pointerPropertiesObjArray, pointerCoordsObjArray);
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected static long nativeInitialize(long nativePtr, int deviceId, int source, int displayId, int action, int flags, int edgeFlags, int metaState, int buttonState, int classification, float xOffset, float yOffset, float xPrecision, float yPrecision, long downTimeNanos, long eventTimeNanos, int pointerCount, MotionEvent.PointerProperties[] pointerIds, MotionEvent.PointerCoords[] pointerCoords) {
        NativeInput.MotionEvent event;
        ShadowMotionEvent.validatePointerCount(pointerCount);
        ShadowMotionEvent.validatePointerPropertiesArray(pointerIds, pointerCount);
        ShadowMotionEvent.validatePointerCoordsObjArray(pointerCoords, pointerCount);
        if (nativePtr > 0L) {
            event = (NativeInput.MotionEvent)nativeMotionEventRegistry.getNativeObject(nativePtr);
        } else {
            event = new NativeInput.MotionEvent();
            nativePtr = nativeMotionEventRegistry.register((Object)event);
        }
        NativeInput.PointerCoords[] rawPointerCoords = new NativeInput.PointerCoords[pointerCount];
        for (int i = 0; i < pointerCount; ++i) {
            MotionEvent.PointerCoords pointerCoordsObj = pointerCoords[i];
            Objects.requireNonNull(pointerCoordsObj);
            rawPointerCoords[i] = ShadowMotionEvent.pointerCoordsToNative(pointerCoordsObj, xOffset, yOffset);
        }
        event.initialize(deviceId, source, action, 0, flags, edgeFlags, metaState, buttonState, classification, xOffset, yOffset, xPrecision, yPrecision, downTimeNanos, eventTimeNanos, pointerCount, pointerIds, rawPointerCoords);
        return nativePtr;
    }

    @Implementation
    @HiddenApi
    protected static void nativeDispose(long nativePtr) {
        nativeMotionEventRegistry.unregister(nativePtr);
    }

    @Implementation
    @HiddenApi
    protected static void nativeAddBatch(long nativePtr, long eventTimeNanos, MotionEvent.PointerCoords[] pointerCoordsObjArray, int metaState) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerCoordsObjArray(pointerCoordsObjArray, pointerCount);
        NativeInput.PointerCoords[] rawPointerCoords = new NativeInput.PointerCoords[pointerCount];
        for (int i = 0; i < pointerCount; ++i) {
            MotionEvent.PointerCoords pointerCoordsObj = pointerCoordsObjArray[i];
            Objects.requireNonNull(pointerCoordsObj);
            rawPointerCoords[i] = ShadowMotionEvent.pointerCoordsToNative(pointerCoordsObj, event.getXOffset(), event.getYOffset());
        }
        event.addSample(eventTimeNanos, rawPointerCoords);
        event.setMetaState(event.getMetaState() | metaState);
    }

    @Implementation
    @HiddenApi
    protected static void nativeGetPointerCoords(long nativePtr, int pointerIndex, int historyPos, MotionEvent.PointerCoords outPointerCoordsObj) {
        NativeInput.PointerCoords rawPointerCoords;
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        ShadowMotionEvent.validatePointerCoords(outPointerCoordsObj);
        if (historyPos == Integer.MIN_VALUE) {
            rawPointerCoords = event.getRawPointerCoords(pointerIndex);
        } else {
            int historySize = event.getHistorySize();
            ShadowMotionEvent.validateHistoryPos(historyPos, historySize);
            rawPointerCoords = event.getHistoricalRawPointerCoords(pointerIndex, historyPos);
        }
        ShadowMotionEvent.pointerCoordsFromNative(rawPointerCoords, event.getXOffset(), event.getYOffset(), outPointerCoordsObj);
    }

    @Implementation
    @HiddenApi
    protected static void nativeGetPointerProperties(long nativePtr, int pointerIndex, MotionEvent.PointerProperties outPointerPropertiesObj) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        ShadowMotionEvent.validatePointerProperties(outPointerPropertiesObj);
        MotionEvent.PointerProperties pointerProperties = event.getPointerProperties(pointerIndex);
        outPointerPropertiesObj.copyFrom(pointerProperties);
    }

    @Implementation
    @HiddenApi
    protected static long nativeReadFromParcel(long nativePtr, Parcel parcelObj) {
        NativeInput.MotionEvent event;
        if (nativePtr == 0L) {
            event = new NativeInput.MotionEvent();
            nativePtr = nativeMotionEventRegistry.register((Object)event);
        } else {
            event = (NativeInput.MotionEvent)nativeMotionEventRegistry.getNativeObject(nativePtr);
        }
        boolean status = event.readFromParcel(parcelObj);
        if (!status) {
            if (nativePtr > 0L) {
                nativeMotionEventRegistry.unregister(nativePtr);
            }
            throw new RuntimeException("Failed to read MotionEvent parcel.");
        }
        return nativePtr;
    }

    @Implementation
    @HiddenApi
    protected static void nativeWriteToParcel(long nativePtr, Parcel parcel) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        if (!event.writeToParcel(parcel)) {
            throw new RuntimeException("Failed to write MotionEvent parcel.");
        }
    }

    @Implementation
    @HiddenApi
    protected static String nativeAxisToString(int axis) {
        for (Field field : MotionEvent.class.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            try {
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !field.getName().startsWith("AXIS_") || field.getInt(null) != axis) continue;
                return field.getName().substring(5);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Implementation
    @HiddenApi
    protected static int nativeAxisFromString(String label) {
        try {
            Field constantField = MotionEvent.class.getDeclaredField("AXIS_" + label);
            return constantField.getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return 0;
        }
    }

    @Implementation
    @HiddenApi
    protected static int nativeGetPointerId(long nativePtr, int pointerIndex) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        return event.getPointerId(pointerIndex);
    }

    @Implementation
    @HiddenApi
    protected static int nativeGetToolType(long nativePtr, int pointerIndex) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        return event.getToolType(pointerIndex);
    }

    @Implementation
    @HiddenApi
    protected static long nativeGetEventTimeNanos(long nativePtr, int historyPos) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        if (historyPos == Integer.MIN_VALUE) {
            return event.getEventTime();
        }
        int historySize = event.getHistorySize();
        ShadowMotionEvent.validateHistoryPos(historyPos, historySize);
        return event.getHistoricalEventTime(historyPos);
    }

    @Implementation
    @HiddenApi
    protected static float nativeGetRawAxisValue(long nativePtr, int axis, int pointerIndex, int historyPos) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        if (historyPos == Integer.MIN_VALUE) {
            return event.getRawAxisValue(axis, pointerIndex);
        }
        int historySize = event.getHistorySize();
        ShadowMotionEvent.validateHistoryPos(historyPos, historySize);
        return event.getHistoricalRawAxisValue(axis, pointerIndex, historyPos);
    }

    @Implementation
    @HiddenApi
    protected static float nativeGetAxisValue(long nativePtr, int axis, int pointerIndex, int historyPos) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        if (historyPos == Integer.MIN_VALUE) {
            return event.getAxisValue(axis, pointerIndex);
        }
        int historySize = event.getHistorySize();
        ShadowMotionEvent.validateHistoryPos(historyPos, historySize);
        return event.getHistoricalAxisValue(axis, pointerIndex, historyPos);
    }

    @Implementation
    @HiddenApi
    protected static long nativeCopy(long destNativePtr, long sourceNativePtr, boolean keepHistory) {
        NativeInput.MotionEvent destEvent = (NativeInput.MotionEvent)nativeMotionEventRegistry.peekNativeObject(destNativePtr);
        if (destEvent == null) {
            destEvent = new NativeInput.MotionEvent();
            destNativePtr = nativeMotionEventRegistry.register((Object)destEvent);
        }
        NativeInput.MotionEvent sourceEvent = ShadowMotionEvent.getNativeMotionEvent(sourceNativePtr);
        destEvent.copyFrom(sourceEvent, keepHistory);
        return destNativePtr;
    }

    @Implementation
    @HiddenApi
    protected static int nativeGetDeviceId(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getDeviceId();
    }

    @Implementation
    @HiddenApi
    protected static int nativeGetSource(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getSource();
    }

    @Implementation
    @HiddenApi
    protected static void nativeSetSource(long nativePtr, int source) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setSource(source);
    }

    @Implementation
    @HiddenApi
    protected static int nativeGetAction(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getAction();
    }

    @Implementation
    @HiddenApi
    protected static void nativeSetAction(long nativePtr, int action) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setAction(action);
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected static int nativeGetActionButton(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getActionButton();
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected static void nativeSetActionButton(long nativePtr, int button) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setActionButton(button);
    }

    @Implementation
    @HiddenApi
    protected static boolean nativeIsTouchEvent(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.isTouchEvent();
    }

    @Implementation
    @HiddenApi
    protected static int nativeGetFlags(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getFlags();
    }

    @Implementation
    @HiddenApi
    protected static void nativeSetFlags(long nativePtr, int flags) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setFlags(flags);
    }

    @Implementation
    @HiddenApi
    protected static int nativeGetEdgeFlags(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getEdgeFlags();
    }

    @Implementation
    @HiddenApi
    protected static void nativeSetEdgeFlags(long nativePtr, int edgeFlags) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setEdgeFlags(edgeFlags);
    }

    @Implementation
    @HiddenApi
    protected static int nativeGetMetaState(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getMetaState();
    }

    @Implementation
    @HiddenApi
    protected static int nativeGetButtonState(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getButtonState();
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected static void nativeSetButtonState(long nativePtr, int buttonState) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setButtonState(buttonState);
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected static int nativeGetClassification(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getClassification();
    }

    @Implementation
    @HiddenApi
    protected static void nativeOffsetLocation(long nativePtr, float deltaX, float deltaY) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.offsetLocation(deltaX, deltaY);
    }

    @Implementation(maxSdk=34)
    @HiddenApi
    protected static float nativeGetXOffset(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getXOffset();
    }

    @Implementation(maxSdk=34)
    @HiddenApi
    protected static float nativeGetYOffset(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getYOffset();
    }

    @Implementation(minSdk=35)
    protected final MotionEvent split(int idBits) {
        NativeInput.MotionEvent event = this.getNativeMotionEvent();
        return event.nativeSplit(idBits);
    }

    @Implementation(minSdk=35)
    @HiddenApi
    protected static float nativeGetRawXOffset(long nativePtr) {
        return ShadowMotionEvent.getNativeMotionEvent(nativePtr).getXOffset();
    }

    @Implementation(minSdk=35)
    @HiddenApi
    protected static float nativeGetRawYOffset(long nativePtr) {
        return ShadowMotionEvent.getNativeMotionEvent(nativePtr).getYOffset();
    }

    @Implementation
    @HiddenApi
    protected static float nativeGetXPrecision(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getXPrecision();
    }

    @Implementation
    @HiddenApi
    protected static float nativeGetYPrecision(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getYPrecision();
    }

    @Implementation
    @HiddenApi
    protected static long nativeGetDownTimeNanos(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getDownTime();
    }

    @Implementation
    @HiddenApi
    protected static void nativeSetDownTimeNanos(long nativePtr, long downTimeNanos) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setDownTime(downTimeNanos);
    }

    @Implementation
    @HiddenApi
    protected static int nativeGetPointerCount(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getPointerCount();
    }

    @Implementation
    @HiddenApi
    protected static int nativeFindPointerIndex(long nativePtr, int pointerId) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.findPointerIndex(pointerId);
    }

    @Implementation
    @HiddenApi
    protected static int nativeGetHistorySize(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getHistorySize();
    }

    @Implementation
    @HiddenApi
    protected static void nativeScale(long nativePtr, float scale) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.scale(scale);
    }

    protected static NativeInput.MotionEvent getNativeMotionEvent(long nativePtr) {
        Preconditions.checkState((nativePtr > 0L ? 1 : 0) != 0, (Object)"MotionEvent has not been initialized. Ensure MotionEvent.obtain was used to create it, instead of creating it directly or via a Mocking framework");
        return (NativeInput.MotionEvent)nativeMotionEventRegistry.getNativeObject(nativePtr);
    }

    @Implementation
    protected void transform(Matrix matrix) {
        Objects.requireNonNull(matrix);
        NativeInput.MotionEvent event = this.getNativeMotionEvent();
        float[] m = new float[9];
        matrix.getValues(m);
        event.transform(m);
    }

    protected NativeInput.MotionEvent getNativeMotionEvent() {
        long nativePtr = (Long)ReflectionHelpers.getField((Object)this.realMotionEvent, (String)"mNativePtr");
        return (NativeInput.MotionEvent)nativeMotionEventRegistry.getNativeObject(nativePtr);
    }

    @Deprecated
    public MotionEvent setPointer2(float pointer1X, float pointer1Y) {
        NativeInput.MotionEvent event = this.getNativeMotionEvent();
        List<NativeInput.PointerCoords> pointerCoords = event.getSamplePointerCoords();
        List<MotionEvent.PointerProperties> pointerProperties = event.getPointerProperties();
        ShadowMotionEvent.ensureTwoPointers(pointerCoords, pointerProperties);
        pointerCoords.get(1).setAxisValue(0, pointer1X);
        pointerCoords.get(1).setAxisValue(1, pointer1Y);
        return this.realMotionEvent;
    }

    private static void ensureTwoPointers(List<NativeInput.PointerCoords> pointerCoords, List<MotionEvent.PointerProperties> pointerProperties) {
        if (pointerCoords.size() < 2) {
            pointerCoords.add(new NativeInput.PointerCoords());
        }
        if (pointerProperties.size() < 2) {
            pointerProperties.add(new MotionEvent.PointerProperties());
        }
    }

    @Deprecated
    public void setPointerIndex(int pointerIndex) {
        NativeInput.MotionEvent event = this.getNativeMotionEvent();
        event.setAction(event.getAction() | (pointerIndex & 0xFF) << 8);
    }

    @Deprecated
    public void setPointerIds(int index0PointerId, int index1PointerId) {
        NativeInput.MotionEvent event = this.getNativeMotionEvent();
        List<NativeInput.PointerCoords> pointerCoords = event.getSamplePointerCoords();
        List<MotionEvent.PointerProperties> pointerProperties = event.getPointerProperties();
        ShadowMotionEvent.ensureTwoPointers(pointerCoords, pointerProperties);
        pointerProperties.get((int)0).id = index0PointerId;
        pointerProperties.get((int)1).id = index1PointerId;
    }
}

