/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioRoutesInfo;
import android.media.MediaRouter;
import android.os.Parcel;
import android.text.TextUtils;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=MediaRouter.class)
public class ShadowMediaRouter {
    public static final String BLUETOOTH_DEVICE_NAME = "TestBluetoothDevice";
    @RealObject
    private MediaRouter realObject;

    public void addBluetoothRoute() {
        this.updateBluetoothAudioRoute(BLUETOOTH_DEVICE_NAME);
        this.realObject.selectRoute(1, ShadowMediaRouter.getBluetoothA2dpRoute());
    }

    public void removeBluetoothRoute() {
        this.updateBluetoothAudioRoute(null);
    }

    public boolean isBluetoothRouteSelected(int type) {
        return this.realObject.getSelectedRoute(type).equals(ShadowMediaRouter.getBluetoothA2dpRoute());
    }

    private static MediaRouter.RouteInfo getBluetoothA2dpRoute() {
        return (MediaRouter.RouteInfo)ReflectionHelpers.getField((Object)ReflectionHelpers.getStaticField(MediaRouter.class, (String)"sStatic"), (String)"mBluetoothA2dpRoute");
    }

    private void updateBluetoothAudioRoute(@Nullable String bluetoothDeviceName) {
        this.callUpdateAudioRoutes(ShadowMediaRouter.newAudioRouteInfo(bluetoothDeviceName));
    }

    private static AudioRoutesInfo newAudioRouteInfo(@Nullable String bluetoothDeviceName) {
        Parcel p = Parcel.obtain();
        TextUtils.writeToParcel((CharSequence)bluetoothDeviceName, (Parcel)p, (int)0);
        p.setDataPosition(0);
        return (AudioRoutesInfo)AudioRoutesInfo.CREATOR.createFromParcel(p);
    }

    private void callUpdateAudioRoutes(AudioRoutesInfo routesInfo) {
        ReflectionHelpers.callInstanceMethod((Object)ReflectionHelpers.getStaticField(MediaRouter.class, (String)"sStatic"), (String)"updateAudioRoutes", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(AudioRoutesInfo.class, (Object)routesInfo)});
    }

    @Resetter
    public static void reset() {
        ReflectionHelpers.setStaticField(MediaRouter.class, (String)"sStatic", null);
    }
}

