/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.graphics.fonts.FontStyle;
import android.util.ArrayMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.res.Fs;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.shadows.ShadowTypeface;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Typeface.class, isInAndroidSdk=false)
@SuppressLint(value={"NewApi"})
public class ShadowLegacyTypeface
extends ShadowTypeface {
    private static final AtomicLong nextFontId = new AtomicLong(1L);
    private ShadowTypeface.FontDesc description;
    @RealObject
    Typeface realTypeface;

    @Implementation
    protected static void __staticInitializer__() {
        Shadow.directInitialize(Typeface.class);
        if (RuntimeEnvironment.getApiLevel() > 30) {
            Typeface.loadPreinstalledSystemFontMap();
        }
    }

    @Implementation(minSdk=28)
    protected static Typeface create(Typeface family, int weight, boolean italic) {
        if (family == null) {
            return ShadowLegacyTypeface.createUnderlyingTypeface(null, weight);
        }
        ShadowTypeface shadowTypeface = (ShadowTypeface)Shadow.extract((Object)family);
        return ShadowLegacyTypeface.createUnderlyingTypeface(shadowTypeface.getFontDescription().getFamilyName(), weight);
    }

    @Implementation
    protected static Typeface create(String familyName, int style) {
        return ShadowLegacyTypeface.createUnderlyingTypeface(familyName, style);
    }

    @Implementation
    protected static Typeface create(Typeface family, int style) {
        if (family == null) {
            return ShadowLegacyTypeface.createUnderlyingTypeface(null, style);
        }
        ShadowTypeface shadowTypeface = (ShadowTypeface)Shadow.extract((Object)family);
        return ShadowLegacyTypeface.createUnderlyingTypeface(shadowTypeface.getFontDescription().getFamilyName(), style);
    }

    @Implementation
    protected static Typeface createFromAsset(AssetManager mgr, String path) {
        ShadowAssetManager shadowAssetManager = (ShadowAssetManager)Shadow.extract((Object)mgr);
        Collection<Path> assetDirs = shadowAssetManager.getAllAssetDirs();
        for (Path assetDir : assetDirs) {
            Path[] files;
            Path assetFile = assetDir.resolve(path);
            if (Files.exists(assetFile, new LinkOption[0])) {
                return ShadowLegacyTypeface.createUnderlyingTypeface(path, 0);
            }
            try {
                files = Fs.listFiles((Path)assetDir, f -> f.getFileName().toString().startsWith(path));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (files.length == 0) continue;
            return ShadowLegacyTypeface.createUnderlyingTypeface(path, 0);
        }
        throw new RuntimeException("Font asset not found " + path);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static Typeface createFromResources(AssetManager mgr, String path, int cookie) {
        return ShadowLegacyTypeface.createUnderlyingTypeface(path, 0);
    }

    @Implementation(minSdk=26)
    protected static Typeface createFromResources(@ClassName(value="android.content.res.FontResourcesParser$FamilyResourceEntry") @ClassName(value="android.content.res.FontResourcesParser$FamilyResourceEntry") Object entry, AssetManager mgr, String path) {
        return ShadowLegacyTypeface.createUnderlyingTypeface(path, 0);
    }

    @Implementation
    protected static Typeface createFromFile(File path) {
        String familyName = path.toPath().getFileName().toString();
        return ShadowLegacyTypeface.createUnderlyingTypeface(familyName, 0);
    }

    @Implementation
    protected static Typeface createFromFile(String path) {
        return ShadowLegacyTypeface.createFromFile(new File(path));
    }

    @Implementation
    protected int getStyle() {
        return this.description.getStyle();
    }

    @Implementation
    public boolean equals(Object o) {
        if (o instanceof Typeface) {
            Typeface other = (Typeface)o;
            return Objects.equals(this.getFontDescription(), Shadows.shadowOf(other).getFontDescription());
        }
        return false;
    }

    @Implementation
    public int hashCode() {
        return this.getFontDescription().hashCode();
    }

    @HiddenApi
    @Implementation
    protected static Typeface createFromFamilies(@ClassName(value="[Landroid.graphics.FontFamily;") @ClassName(value="[Landroid.graphics.FontFamily;") Object families) {
        return null;
    }

    @HiddenApi
    @Implementation(maxSdk=25)
    protected static Typeface createFromFamiliesWithDefault(@ClassName(value="[Landroid.graphics.FontFamily;") @ClassName(value="[Landroid.graphics.FontFamily;") Object families) {
        return null;
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static Typeface createFromFamiliesWithDefault(@ClassName(value="[Landroid.graphics.FontFamily;") @ClassName(value="[Landroid.graphics.FontFamily;") Object families, int weight, int italic) {
        return ShadowLegacyTypeface.createUnderlyingTypeface("fake-font", 0);
    }

    @Implementation(minSdk=28)
    protected static Typeface createFromFamiliesWithDefault(@ClassName(value="[Landroid.graphics.FontFamily;") @ClassName(value="[Landroid.graphics.FontFamily;") Object families, String fallbackName, int weight, int italic) {
        return ShadowLegacyTypeface.createUnderlyingTypeface(fallbackName, 0);
    }

    @Implementation(minSdk=28, maxSdk=28)
    protected static void buildSystemFallback(String xmlPath, String fontDir, ArrayMap<String, Typeface> fontMap, ArrayMap<String, ?> fallbackMap) {
        fontMap.put((Object)"sans-serif", (Object)ShadowLegacyTypeface.createUnderlyingTypeface("sans-serif", 0));
    }

    @Implementation(maxSdk=27)
    protected static void init() {
    }

    @HiddenApi
    @Implementation(minSdk=29, maxSdk=30)
    protected static void initSystemDefaultTypefaces(Map<String, Typeface> systemFontMap, Map<String, ?> fallbacks, @ClassName(value="[Landroid.text.FontConfig$Alias;") @ClassName(value="[Landroid.text.FontConfig$Alias;") Object aliases) {
    }

    protected static Typeface createUnderlyingTypeface(String familyName, int style) {
        long thisFontId = nextFontId.getAndIncrement();
        Typeface result = (Typeface)ReflectionHelpers.callConstructor(Typeface.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)thisFontId)});
        ((ShadowLegacyTypeface)Shadow.extract((Object)result)).description = new ShadowTypeface.FontDesc(familyName, style);
        return result;
    }

    @Implementation(minSdk=26, maxSdk=30)
    protected static long nativeCreateFromArray(long[] familyArray, int weight, int italic) {
        return nextFontId.incrementAndGet();
    }

    @Override
    public ShadowTypeface.FontDesc getFontDescription() {
        return this.description;
    }

    @Implementation(minSdk=31)
    protected static void nativeForceSetStaticFinalField(String fieldname, Typeface typeface) {
        ReflectionHelpers.setStaticField(Typeface.class, (String)fieldname, (Object)typeface);
    }

    @Implementation(minSdk=31)
    protected static long nativeCreateFromArray(long[] familyArray, long fallbackTypeface, int weight, int italic) {
        return ShadowLegacyTypeface.nativeCreateFromArray(familyArray, weight, italic);
    }

    @ForType(value=Typeface.CustomFallbackBuilder.class)
    static interface CustomFallbackBuilderReflector {
        @Direct
        public Typeface build();

        @Accessor(value="mStyle")
        public FontStyle getStyle();
    }

    public static final class CustomFallbackBuilderPicker
    extends GraphicsShadowPicker<Object> {
        public CustomFallbackBuilderPicker() {
            super(ShadowCustomFallbackBuilder.class, null);
        }
    }

    @Implements(value=Typeface.CustomFallbackBuilder.class, minSdk=29, shadowPicker=CustomFallbackBuilderPicker.class)
    public static class ShadowCustomFallbackBuilder {
        @RealObject
        Typeface.CustomFallbackBuilder realBuilder;

        @Implementation
        protected Typeface build() {
            Typeface result = ((CustomFallbackBuilderReflector)Reflector.reflector(CustomFallbackBuilderReflector.class, (Object)this.realBuilder)).build();
            FontStyle style = ((CustomFallbackBuilderReflector)Reflector.reflector(CustomFallbackBuilderReflector.class, (Object)this.realBuilder)).getStyle();
            ((ShadowLegacyTypeface)Shadow.extract((Object)result)).description = new ShadowTypeface.FontDesc(null, style.getWeight());
            return result;
        }
    }

    @Implements(value=Typeface.Builder.class, minSdk=29)
    public static class ShadowBuilder {
        @RealObject
        Typeface.Builder realBuilder;

        @Implementation
        protected Typeface build() {
            String path = (String)ReflectionHelpers.getField((Object)this.realBuilder, (String)"mPath");
            return ShadowLegacyTypeface.createUnderlyingTypeface(path, 0);
        }
    }
}

