/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.input.InputManagerGlobal;
import android.util.SparseArray;
import android.view.InputDevice;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowInputManager;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=InputManagerGlobal.class, isInAndroidSdk=false, minSdk=34)
public class ShadowInputManagerGlobal {
    @RealObject
    InputManagerGlobal realInputManager;

    @Implementation
    protected void populateInputDevicesLocked() throws ClassNotFoundException {
        SparseArray<InputDevice> inputDevices;
        if (ReflectionHelpers.getField((Object)this.realInputManager, (String)"mInputDevicesChangedListener") == null) {
            ReflectionHelpers.setField((Object)this.realInputManager, (String)"mInputDevicesChangedListener", (Object)ReflectionHelpers.callConstructor(Class.forName("android.hardware.input.InputManagerGlobal$InputDevicesChangedListener"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
        }
        if ((inputDevices = this.getInputDevices()) == null) {
            this.setInputDevices((SparseArray<InputDevice>)new SparseArray());
        }
    }

    SparseArray<InputDevice> getInputDevices() {
        return ((InputManagerReflector)Reflector.reflector(InputManagerReflector.class, (Object)this.realInputManager)).getInputDevices();
    }

    private void setInputDevices(SparseArray<InputDevice> devices) {
        ((InputManagerReflector)Reflector.reflector(InputManagerReflector.class, (Object)this.realInputManager)).setInputDevices(devices);
    }

    @Implementation
    protected boolean[] deviceHasKeys(int deviceId, int[] keyCodes) {
        return ShadowInputManager.deviceHasKeysImpl(deviceId, keyCodes);
    }

    @Resetter
    public static void reset() {
        ReflectionHelpers.setStaticField(InputManagerGlobal.class, (String)"sInstance", null);
    }

    @ForType(value=InputManagerGlobal.class)
    static interface InputManagerReflector {
        @Accessor(value="mInputDevices")
        public SparseArray<InputDevice> getInputDevices();

        @Accessor(value="mInputDevices")
        public void setInputDevices(SparseArray<InputDevice> var1);
    }
}

