/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowDrawable;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=GradientDrawable.class)
public class ShadowGradientDrawable
extends ShadowDrawable {
    @RealObject
    private GradientDrawable realGradientDrawable;
    private int color;
    private int shape;
    private int strokeColor;
    private int strokeWidth;

    @Implementation
    protected void setColor(int color) {
        this.color = color;
        ((GradientDrawableReflector)Reflector.reflector(GradientDrawableReflector.class, (Object)this.realGradientDrawable)).setColor(color);
    }

    @Implementation
    protected void setShape(int shape) {
        this.shape = shape;
        ((GradientDrawableReflector)Reflector.reflector(GradientDrawableReflector.class, (Object)this.realGradientDrawable)).setShape(shape);
    }

    @Implementation
    protected void setStroke(int width, int color) {
        this.strokeWidth = width;
        this.strokeColor = color;
        ((GradientDrawableReflector)Reflector.reflector(GradientDrawableReflector.class, (Object)this.realGradientDrawable)).setStroke(width, color);
    }

    public int getLastSetColor() {
        return this.color;
    }

    @Implementation(minSdk=24)
    protected int getShape() {
        if (Build.VERSION.SDK_INT < 24) {
            return this.shape;
        }
        return ((GradientDrawableReflector)Reflector.reflector(GradientDrawableReflector.class, (Object)this.realGradientDrawable)).getShape();
    }

    public int getStrokeWidth() {
        return this.strokeWidth;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    @ForType(value=GradientDrawable.class)
    static interface GradientDrawableReflector {
        @Direct
        public int getShape();

        @Direct
        public void setColor(int var1);

        @Direct
        public void setShape(int var1);

        @Direct
        public void setStroke(int var1, int var2);
    }
}

