/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.FingerprintManager;
import android.hardware.fingerprint.FingerprintSensorPropertiesInternal;
import android.os.CancellationSignal;
import android.os.Handler;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=FingerprintManager.class, minSdk=23)
public class ShadowFingerprintManager {
    private static final String TAG = "ShadowFingerprintManager";
    private static boolean isHardwareDetected;
    protected static FingerprintManager.CryptoObject pendingCryptoObject;
    private static FingerprintManager.AuthenticationCallback pendingCallback;
    private static List<Fingerprint> fingerprints;

    @Resetter
    public static void reset() {
        isHardwareDetected = false;
        pendingCryptoObject = null;
        pendingCallback = null;
        fingerprints = Collections.emptyList();
    }

    public void authenticationSucceeds() {
        if (pendingCallback == null) {
            throw new IllegalStateException("No active fingerprint authentication request.");
        }
        pendingCallback.onAuthenticationSucceeded(this.createAuthenticationResult());
    }

    protected FingerprintManager.AuthenticationResult createAuthenticationResult() {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            return new FingerprintManager.AuthenticationResult(pendingCryptoObject, null, 0, false);
        }
        if (RuntimeEnvironment.getApiLevel() >= 25) {
            return (FingerprintManager.AuthenticationResult)ReflectionHelpers.callConstructor(FingerprintManager.AuthenticationResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(FingerprintManager.CryptoObject.class, (Object)pendingCryptoObject), ReflectionHelpers.ClassParameter.from(Fingerprint.class, null), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
        }
        return (FingerprintManager.AuthenticationResult)ReflectionHelpers.callConstructor(FingerprintManager.AuthenticationResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(FingerprintManager.CryptoObject.class, (Object)pendingCryptoObject), ReflectionHelpers.ClassParameter.from(Fingerprint.class, null)});
    }

    public void authenticationFails() {
        if (pendingCallback == null) {
            throw new IllegalStateException("No active fingerprint authentication request.");
        }
        pendingCallback.onAuthenticationFailed();
    }

    @Implementation
    protected void authenticate(FingerprintManager.CryptoObject crypto, CancellationSignal cancel, int flags, FingerprintManager.AuthenticationCallback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an authentication callback");
        }
        if (cancel != null) {
            if (cancel.isCanceled()) {
                Log.w((String)TAG, (String)"authentication already canceled");
                return;
            }
            cancel.setOnCancelListener(() -> {
                pendingCallback = null;
                pendingCryptoObject = null;
            });
        }
        pendingCryptoObject = crypto;
        pendingCallback = callback;
    }

    @Deprecated
    public void setHasEnrolledFingerprints(boolean hasEnrolledFingerprints) {
        this.setDefaultFingerprints(hasEnrolledFingerprints ? 1 : 0);
    }

    @Implementation
    protected boolean hasEnrolledFingerprints() {
        return !fingerprints.isEmpty();
    }

    @HiddenApi
    @Implementation
    protected List<Fingerprint> getEnrolledFingerprints() {
        return new ArrayList<Fingerprint>(fingerprints);
    }

    public int getFingerprintId(int index) {
        return (Integer)ReflectionHelpers.callInstanceMethod((Object)this.getEnrolledFingerprints().get(index), (String)(RuntimeEnvironment.getApiLevel() > 28 ? "getBiometricId" : "getFingerId"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public void setDefaultFingerprints(int num) {
        this.setEnrolledFingerprints((Fingerprint[])IntStream.range(0, num).mapToObj(i -> new Fingerprint((CharSequence)("Fingerprint " + i), 0, i, 0L)).toArray(Fingerprint[]::new));
    }

    private void setEnrolledFingerprints(Fingerprint ... fingerprints) {
        ShadowFingerprintManager.fingerprints = Arrays.asList(fingerprints);
    }

    public void setIsHardwareDetected(boolean isHardwareDetected) {
        ShadowFingerprintManager.isHardwareDetected = isHardwareDetected;
    }

    @Implementation(minSdk=23)
    protected boolean isHardwareDetected() {
        return isHardwareDetected;
    }

    @Implementation(minSdk=31)
    protected List<FingerprintSensorPropertiesInternal> getSensorPropertiesInternal() {
        return new ArrayList<FingerprintSensorPropertiesInternal>();
    }

    static {
        fingerprints = Collections.emptyList();
    }
}

