/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.ProxyInfo;
import android.os.Handler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowNetwork;
import org.robolectric.shadows.ShadowNetworkCapabilities;
import org.robolectric.shadows.ShadowNetworkInfo;
import org.robolectric.shadows.ShadowSettings;

@Implements(value=ConnectivityManager.class)
public class ShadowConnectivityManager {
    static final int NET_ID_WIFI = 1;
    static final int NET_ID_MOBILE = 0;
    private static NetworkInfo activeNetworkInfo;
    private static boolean backgroundDataSetting;
    private static boolean networkCallbacksEnabled;
    private static int restrictBackgroundStatus;
    private static int networkPreference;
    private static final Map<Integer, NetworkInfo> networkTypeToNetworkInfo;
    private static final HashSet<ConnectivityManager.NetworkCallback> networkCallbacks;
    private static final HashSet<PendingIntent> networkCallbackPendingIntents;
    private static final Map<Integer, Network> netIdToNetwork;
    private static final Map<Integer, NetworkInfo> netIdToNetworkInfo;
    private static Network processBoundNetwork;
    private static boolean defaultNetworkActive;
    private static final HashSet<ConnectivityManager.OnNetworkActiveListener> onNetworkActiveListeners;
    private static final Map<Network, Boolean> reportedNetworkConnectivity;
    private static final Map<Network, NetworkCapabilities> networkCapabilitiesMap;
    private static String captivePortalServerUrl;
    private static final Map<Network, LinkProperties> linkPropertiesMap;
    private static final Map<Network, ProxyInfo> proxyInfoMap;

    private static void resetNetworkDefaults() {
        networkTypeToNetworkInfo.clear();
        NetworkInfo wifi = ShadowNetworkInfo.newInstance(NetworkInfo.DetailedState.DISCONNECTED, 1, 0, true, false);
        networkTypeToNetworkInfo.put(1, wifi);
        NetworkInfo mobile = ShadowNetworkInfo.newInstance(NetworkInfo.DetailedState.CONNECTED, 0, 2, true, true);
        networkTypeToNetworkInfo.put(0, mobile);
        activeNetworkInfo = mobile;
        netIdToNetwork.clear();
        netIdToNetwork.put(1, ShadowNetwork.newInstance(1));
        netIdToNetwork.put(0, ShadowNetwork.newInstance(0));
        netIdToNetworkInfo.clear();
        netIdToNetworkInfo.put(1, wifi);
        netIdToNetworkInfo.put(0, mobile);
        NetworkCapabilities wifiNetworkCapabilities = ShadowNetworkCapabilities.newInstance();
        Shadows.shadowOf(wifiNetworkCapabilities).addTransportType(1);
        NetworkCapabilities mobileNetworkCapabilities = ShadowNetworkCapabilities.newInstance();
        Shadows.shadowOf(mobileNetworkCapabilities).addTransportType(0);
        networkCapabilitiesMap.clear();
        networkCapabilitiesMap.put(netIdToNetwork.get(1), wifiNetworkCapabilities);
        networkCapabilitiesMap.put(netIdToNetwork.get(0), mobileNetworkCapabilities);
        backgroundDataSetting = false;
        networkCallbacksEnabled = true;
        restrictBackgroundStatus = 1;
        networkPreference = 1;
        defaultNetworkActive = true;
        networkCallbacks.clear();
        networkCallbackPendingIntents.clear();
        onNetworkActiveListeners.clear();
        reportedNetworkConnectivity.clear();
        linkPropertiesMap.clear();
        proxyInfoMap.clear();
        processBoundNetwork = null;
        captivePortalServerUrl = "http://10.0.0.2";
    }

    @Resetter
    public static void reset() {
        ShadowConnectivityManager.resetNetworkDefaults();
    }

    public void setNetworkCallbacksEnabled(boolean enabled) {
        networkCallbacksEnabled = enabled;
    }

    public Set<ConnectivityManager.NetworkCallback> getNetworkCallbacks() {
        return networkCallbacks;
    }

    public Set<PendingIntent> getNetworkCallbackPendingIntents() {
        return networkCallbackPendingIntents;
    }

    public Map<Network, Boolean> getReportedNetworkConnectivity() {
        return new HashMap<Network, Boolean>(reportedNetworkConnectivity);
    }

    @Implementation
    protected void registerNetworkCallback(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback) {
        this.registerNetworkCallback(request, networkCallback, null);
    }

    @Implementation(minSdk=26)
    protected void registerNetworkCallback(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
        networkCallbacks.add(networkCallback);
    }

    @Implementation(minSdk=23)
    protected void registerNetworkCallback(NetworkRequest request, PendingIntent pendingIntent) {
        networkCallbackPendingIntents.add(pendingIntent);
    }

    @Implementation
    protected void requestNetwork(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback) {
        this.registerNetworkCallback(request, networkCallback);
    }

    @Implementation(minSdk=26)
    protected void requestNetwork(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback, int timeoutMs) {
        this.registerNetworkCallback(request, networkCallback);
    }

    @Implementation(minSdk=26)
    protected void requestNetwork(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
        this.registerNetworkCallback(request, networkCallback);
    }

    @Implementation(minSdk=26)
    protected void requestNetwork(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback, Handler handler, int timeoutMs) {
        this.registerNetworkCallback(request, networkCallback);
    }

    @Implementation(minSdk=24)
    protected void registerDefaultNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
        networkCallbacks.add(networkCallback);
    }

    @Implementation(minSdk=26)
    protected void registerDefaultNetworkCallback(ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
        networkCallbacks.add(networkCallback);
    }

    @Implementation(minSdk=31)
    protected void registerBestMatchingNetworkCallback(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
        networkCallbacks.add(networkCallback);
    }

    @Implementation
    protected void unregisterNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
        if (networkCallback == null) {
            throw new IllegalArgumentException("Invalid NetworkCallback");
        }
        networkCallbacks.remove(networkCallback);
    }

    @Implementation(minSdk=23)
    protected void unregisterNetworkCallback(PendingIntent pendingIntent) {
        if (pendingIntent == null) {
            throw new IllegalArgumentException("Invalid NetworkCallback");
        }
        networkCallbackPendingIntents.remove(pendingIntent);
    }

    @Implementation
    protected NetworkInfo getActiveNetworkInfo() {
        return activeNetworkInfo;
    }

    @Implementation(minSdk=23)
    protected Network getActiveNetwork() {
        if (defaultNetworkActive && activeNetworkInfo != null) {
            return netIdToNetwork.get(activeNetworkInfo.getType());
        }
        return null;
    }

    @Implementation
    protected NetworkInfo[] getAllNetworkInfo() {
        if (defaultNetworkActive) {
            return networkTypeToNetworkInfo.values().toArray(new NetworkInfo[0]);
        }
        return null;
    }

    @Implementation
    protected NetworkInfo getNetworkInfo(int networkType) {
        return networkTypeToNetworkInfo.get(networkType);
    }

    @Implementation
    protected NetworkInfo getNetworkInfo(Network network) {
        if (network == null) {
            return null;
        }
        ShadowNetwork shadowNetwork = (ShadowNetwork)Shadow.extract((Object)network);
        return netIdToNetworkInfo.get(shadowNetwork.getNetId());
    }

    @Implementation
    protected Network[] getAllNetworks() {
        return netIdToNetwork.values().toArray(new Network[0]);
    }

    @Implementation
    protected boolean getBackgroundDataSetting() {
        return backgroundDataSetting;
    }

    @Implementation
    protected void setNetworkPreference(int preference) {
        networkPreference = preference;
    }

    @Implementation
    protected int getNetworkPreference() {
        return networkPreference;
    }

    @Implementation
    protected boolean isActiveNetworkMetered() {
        if (defaultNetworkActive && activeNetworkInfo != null) {
            return activeNetworkInfo.getType() == 0;
        }
        return false;
    }

    @Implementation(minSdk=23)
    protected boolean bindProcessToNetwork(Network network) {
        processBoundNetwork = network;
        return true;
    }

    @Implementation(minSdk=23)
    protected Network getBoundNetworkForProcess() {
        return processBoundNetwork;
    }

    public void setNetworkInfo(int networkType, NetworkInfo networkInfo) {
        networkTypeToNetworkInfo.put(networkType, networkInfo);
    }

    @Implementation(minSdk=24)
    protected String getCaptivePortalServerUrl() {
        return captivePortalServerUrl;
    }

    public void setCaptivePortalServerUrl(String captivePortalServerUrl) {
        ShadowConnectivityManager.captivePortalServerUrl = captivePortalServerUrl;
    }

    @HiddenApi
    @Implementation
    public void setBackgroundDataSetting(boolean b) {
        backgroundDataSetting = b;
    }

    public void setActiveNetworkInfo(NetworkInfo info) {
        activeNetworkInfo = info;
        if (info != null) {
            networkTypeToNetworkInfo.put(info.getType(), info);
            netIdToNetwork.put(info.getType(), ShadowNetwork.newInstance(info.getType()));
            netIdToNetworkInfo.put(info.getType(), info);
        } else {
            networkTypeToNetworkInfo.clear();
            netIdToNetwork.clear();
        }
    }

    public void addNetwork(Network network, NetworkInfo networkInfo) {
        ShadowNetwork shadowNetwork = (ShadowNetwork)Shadow.extract((Object)network);
        int netId = shadowNetwork.getNetId();
        netIdToNetwork.put(netId, network);
        netIdToNetworkInfo.put(netId, networkInfo);
    }

    public void removeNetwork(Network network) {
        ShadowNetwork shadowNetwork = (ShadowNetwork)Shadow.extract((Object)network);
        int netId = shadowNetwork.getNetId();
        netIdToNetwork.remove(netId);
        netIdToNetworkInfo.remove(netId);
    }

    public void clearAllNetworks() {
        netIdToNetwork.clear();
        netIdToNetworkInfo.clear();
    }

    public void setDefaultNetworkActive(boolean isActive) {
        defaultNetworkActive = isActive;
        if (defaultNetworkActive) {
            for (ConnectivityManager.OnNetworkActiveListener l : onNetworkActiveListeners) {
                if (l == null) continue;
                l.onNetworkActive();
            }
        }
        if (!networkCallbacksEnabled) {
            return;
        }
        NetworkInfo activeNetworkInfo = this.getActiveNetworkInfo();
        if (activeNetworkInfo == null) {
            return;
        }
        Network defaultNetwork = netIdToNetwork.get(activeNetworkInfo.getType());
        if (defaultNetwork == null) {
            return;
        }
        HashSet<ConnectivityManager.NetworkCallback> stableNetworkCallbacks = new HashSet<ConnectivityManager.NetworkCallback>(networkCallbacks);
        for (ConnectivityManager.NetworkCallback c : stableNetworkCallbacks) {
            if (c == null) continue;
            if (defaultNetworkActive) {
                c.onAvailable(defaultNetwork);
                continue;
            }
            c.onLost(defaultNetwork);
        }
    }

    @Implementation
    protected boolean isDefaultNetworkActive() {
        return defaultNetworkActive;
    }

    @Implementation
    protected void addDefaultNetworkActiveListener(ConnectivityManager.OnNetworkActiveListener l) {
        onNetworkActiveListeners.add(l);
    }

    @Implementation
    protected void removeDefaultNetworkActiveListener(ConnectivityManager.OnNetworkActiveListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Invalid OnNetworkActiveListener");
        }
        onNetworkActiveListeners.remove(l);
    }

    @Implementation(minSdk=23)
    protected void reportNetworkConnectivity(Network network, boolean hasConnectivity) {
        reportedNetworkConnectivity.put(network, hasConnectivity);
    }

    @Implementation
    protected NetworkCapabilities getNetworkCapabilities(Network network) {
        return networkCapabilitiesMap.get(network);
    }

    public void setNetworkCapabilities(Network network, NetworkCapabilities networkCapabilities) {
        networkCapabilitiesMap.put(network, networkCapabilities);
    }

    @Implementation
    protected void setAirplaneMode(boolean enable) {
        ShadowSettings.setAirplaneMode(enable);
    }

    @Implementation
    protected LinkProperties getLinkProperties(Network network) {
        return linkPropertiesMap.get(network);
    }

    public void setLinkProperties(Network network, LinkProperties linkProperties) {
        linkPropertiesMap.put(network, linkProperties);
    }

    @Implementation(minSdk=24)
    protected int getRestrictBackgroundStatus() {
        return restrictBackgroundStatus;
    }

    public void setRestrictBackgroundStatus(int status) {
        if (status <= 0 || status >= 4) {
            throw new IllegalArgumentException("Invalid RESTRICT_BACKGROUND_STATUS value.");
        }
        restrictBackgroundStatus = status;
    }

    public void setProxyForNetwork(Network network, ProxyInfo proxyInfo) {
        proxyInfoMap.put(network, proxyInfo);
    }

    @Implementation(minSdk=23)
    protected ProxyInfo getProxyForNetwork(Network network) {
        return proxyInfoMap.get(network);
    }

    static {
        networkCallbacksEnabled = true;
        restrictBackgroundStatus = 1;
        networkPreference = 1;
        networkTypeToNetworkInfo = new HashMap<Integer, NetworkInfo>();
        networkCallbacks = new HashSet();
        networkCallbackPendingIntents = new HashSet();
        netIdToNetwork = new HashMap<Integer, Network>();
        netIdToNetworkInfo = new HashMap<Integer, NetworkInfo>();
        defaultNetworkActive = true;
        onNetworkActiveListeners = new HashSet();
        reportedNetworkConnectivity = new HashMap<Network, Boolean>();
        networkCapabilitiesMap = new HashMap<Network, NetworkCapabilities>();
        captivePortalServerUrl = "http://10.0.0.2";
        linkPropertiesMap = new HashMap<Network, LinkProperties>();
        proxyInfoMap = new HashMap<Network, ProxyInfo>();
        ShadowConnectivityManager.resetNetworkDefaults();
    }
}

