/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.CamcorderProfile;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=CamcorderProfile.class)
public class ShadowCamcorderProfile {
    private static final Table<Integer, Integer, CamcorderProfile> profiles = HashBasedTable.create();

    public static void addProfile(int cameraId, int quality, CamcorderProfile profile) {
        profiles.put((Object)cameraId, (Object)quality, (Object)profile);
    }

    @Resetter
    public static void reset() {
        profiles.clear();
    }

    public static CamcorderProfile createProfile(int duration, int quality, int fileFormat, int videoCodec, int videoBitRate, int videoFrameRate, int videoWidth, int videoHeight, int audioCodec, int audioBitRate, int audioSampleRate, int audioChannels) {
        return (CamcorderProfile)ReflectionHelpers.callConstructor(CamcorderProfile.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)duration), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)quality), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)fileFormat), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)videoCodec), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)videoBitRate), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)videoFrameRate), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)videoWidth), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)videoHeight), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)audioCodec), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)audioBitRate), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)audioSampleRate), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)audioChannels)});
    }

    @Implementation
    protected static boolean hasProfile(int cameraId, int quality) {
        return profiles.contains((Object)cameraId, (Object)quality);
    }

    @Implementation
    protected static CamcorderProfile get(int cameraId, int quality) {
        return (CamcorderProfile)profiles.get((Object)cameraId, (Object)quality);
    }
}

