/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.AdvertisingSetCallback;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;

@Implements(value=BluetoothLeAdvertiser.class, minSdk=26)
public class ShadowBluetoothLeAdvertiser {
    @ReflectorObject
    protected BluetoothLeAdvertiserReflector bluetoothLeAdvertiserReflector;
    private AdvertiseData lastAdvertiseData;

    public int getAdvertisementRequestCount() {
        return this.bluetoothLeAdvertiserReflector.getLegacyAdvertisers().size();
    }

    public int getAdvertisingSetRequestCount() {
        return this.bluetoothLeAdvertiserReflector.getAdvertisingSets().size();
    }

    @Implementation
    protected void startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseCallback callback) {
        this.bluetoothLeAdvertiserReflector.startAdvertising(settings, advertiseData, callback);
        this.lastAdvertiseData = advertiseData;
    }

    @Implementation
    protected void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, AdvertisingSetCallback callback) {
        this.bluetoothLeAdvertiserReflector.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, callback);
        this.lastAdvertiseData = advertiseData;
    }

    public AdvertiseData getLastAdvertisingData() {
        return this.lastAdvertiseData;
    }

    @ForType(value=BluetoothLeAdvertiser.class)
    private static interface BluetoothLeAdvertiserReflector {
        @Accessor(value="mLegacyAdvertisers")
        public Map<AdvertiseCallback, AdvertisingSetCallback> getLegacyAdvertisers();

        @Accessor(value="mAdvertisingSets")
        public Map<?, ?> getAdvertisingSets();

        @Direct
        public void startAdvertisingSet(AdvertisingSetParameters var1, AdvertiseData var2, AdvertiseData var3, PeriodicAdvertisingParameters var4, AdvertiseData var5, AdvertisingSetCallback var6);

        @Direct
        public void startAdvertising(AdvertiseSettings var1, AdvertiseData var2, AdvertiseCallback var3);
    }
}

