/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.os.WorkSource;
import com.android.internal.annotations.GuardedBy;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AlarmManager.class)
public class ShadowAlarmManager {
    public static final long WINDOW_EXACT = 0L;
    public static final long WINDOW_HEURISTIC = -1L;
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();
    private static boolean canScheduleExactAlarms;
    private static boolean autoSchedule;
    private final Handler schedulingHandler = new Handler(Looper.getMainLooper());
    @GuardedBy(value={"scheduledAlarms"})
    private final PriorityQueue<InternalScheduledAlarm> scheduledAlarms = new PriorityQueue();
    @RealObject
    private AlarmManager realObject;

    @Resetter
    public static void reset() {
        TimeZone.setDefault(DEFAULT_TIMEZONE);
        canScheduleExactAlarms = false;
        autoSchedule = false;
    }

    public static void setAutoSchedule(boolean autoSchedule) {
        ShadowAlarmManager.autoSchedule = autoSchedule;
    }

    @Implementation
    protected void set(int type, long triggerAtMs, PendingIntent operation) {
        this.setImpl(type, triggerAtMs, -1L, 0L, operation, null, null, false);
    }

    @Implementation(minSdk=24)
    protected void set(int type, long triggerAtMs, @Nullable String tag, AlarmManager.OnAlarmListener listener, @Nullable Handler handler) {
        this.setImpl(type, triggerAtMs, -1L, 0L, tag, listener, new HandlerExecutor(handler), null, false);
    }

    @Implementation
    protected void setRepeating(int type, long triggerAtMs, long intervalMs, PendingIntent operation) {
        this.setImpl(type, triggerAtMs, -1L, intervalMs, operation, null, null, false);
    }

    @Implementation
    protected void setWindow(int type, long windowStartMs, long windowLengthMs, PendingIntent operation) {
        this.setImpl(type, windowStartMs, windowLengthMs, 0L, operation, null, null, false);
    }

    @Implementation(minSdk=24)
    protected void setWindow(int type, long windowStartMs, long windowLengthMs, @Nullable String tag, AlarmManager.OnAlarmListener listener, @Nullable Handler handler) {
        this.setImpl(type, windowStartMs, windowLengthMs, 0L, tag, listener, new HandlerExecutor(handler), null, false);
    }

    @Implementation(minSdk=34)
    protected void setWindow(int type, long windowStartMs, long windowLengthMs, @Nullable String tag, Executor executor, AlarmManager.OnAlarmListener listener) {
        this.setImpl(type, windowStartMs, windowLengthMs, 0L, tag, listener, executor, null, false);
    }

    @Implementation(minSdk=34)
    protected void setWindow(int type, long windowStartMs, long windowLengthMs, @Nullable String tag, Executor executor, WorkSource workSource, AlarmManager.OnAlarmListener listener) {
        this.setImpl(type, windowStartMs, windowLengthMs, 0L, tag, listener, executor, workSource, false);
    }

    @Implementation(minSdk=31)
    protected void setPrioritized(int type, long windowStartMs, long windowLengthMs, @Nullable String tag, Executor executor, AlarmManager.OnAlarmListener listener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        this.setImpl(type, windowStartMs, windowLengthMs, 0L, tag, listener, executor, null, true);
    }

    @Implementation
    protected void setExact(int type, long triggerAtMs, PendingIntent operation) {
        this.setImpl(type, triggerAtMs, 0L, 0L, operation, null, null, false);
    }

    @Implementation(minSdk=24)
    protected void setExact(int type, long triggerAtTime, @Nullable String tag, AlarmManager.OnAlarmListener listener, @Nullable Handler targetHandler) {
        this.setImpl(type, triggerAtTime, 0L, 0L, tag, listener, new HandlerExecutor(targetHandler), null, false);
    }

    @Implementation
    protected void setAlarmClock(AlarmManager.AlarmClockInfo info, PendingIntent operation) {
        this.setImpl(0, info.getTriggerTime(), 0L, 0L, operation, null, info, true);
    }

    @Implementation
    protected void set(int type, long triggerAtMs, long windowLengthMs, long intervalMs, PendingIntent operation, @Nullable WorkSource workSource) {
        this.setImpl(type, triggerAtMs, windowLengthMs, intervalMs, operation, workSource, null, false);
    }

    @Implementation(minSdk=24)
    protected void set(int type, long triggerAtMs, long windowLengthMs, long intervalMs, @Nullable String tag, AlarmManager.OnAlarmListener listener, @Nullable Handler targetHandler, @Nullable WorkSource workSource) {
        this.setImpl(type, triggerAtMs, windowLengthMs, intervalMs, tag, listener, new HandlerExecutor(targetHandler), workSource, false);
    }

    @Implementation(minSdk=24)
    protected void set(int type, long triggerAtMs, long windowLengthMs, long intervalMs, AlarmManager.OnAlarmListener listener, @Nullable Handler targetHandler, @Nullable WorkSource workSource) {
        this.setImpl(type, triggerAtMs, windowLengthMs, intervalMs, null, listener, new HandlerExecutor(targetHandler), workSource, false);
    }

    @Implementation(minSdk=31)
    protected void setExact(int type, long triggerAtMs, @Nullable String tag, Executor executor, WorkSource workSource, AlarmManager.OnAlarmListener listener) {
        Objects.requireNonNull(workSource);
        this.setImpl(type, triggerAtMs, 0L, 0L, tag, listener, executor, workSource, false);
    }

    @Implementation
    protected void setInexactRepeating(int type, long triggerAtMs, long intervalMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMs, -1L, intervalMillis, operation, null, null, false);
    }

    @Implementation(minSdk=23)
    protected void setAndAllowWhileIdle(int type, long triggerAtMs, PendingIntent operation) {
        this.setImpl(type, triggerAtMs, -1L, 0L, operation, null, null, true);
    }

    @Implementation(minSdk=23)
    protected void setExactAndAllowWhileIdle(int type, long triggerAtMs, PendingIntent operation) {
        this.setImpl(type, triggerAtMs, 0L, 0L, operation, null, null, true);
    }

    @Implementation(minSdk=34)
    protected void setExactAndAllowWhileIdle(int type, long triggerAtMs, @Nullable String tag, Executor executor, @Nullable WorkSource workSource, AlarmManager.OnAlarmListener listener) {
        this.setImpl(type, triggerAtMs, 0L, 0L, tag, listener, executor, workSource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void cancel(PendingIntent operation) {
        PriorityQueue<InternalScheduledAlarm> priorityQueue = this.scheduledAlarms;
        synchronized (priorityQueue) {
            Iterables.removeIf(this.scheduledAlarms, alarm -> {
                if (operation.equals((Object)alarm.operation)) {
                    alarm.deschedule();
                    return true;
                }
                return false;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected void cancel(AlarmManager.OnAlarmListener listener) {
        PriorityQueue<InternalScheduledAlarm> priorityQueue = this.scheduledAlarms;
        synchronized (priorityQueue) {
            Iterables.removeIf(this.scheduledAlarms, alarm -> {
                if (listener.equals((Object)alarm.onAlarmListener)) {
                    alarm.deschedule();
                    return true;
                }
                return false;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=34)
    protected void cancelAll() {
        PriorityQueue<InternalScheduledAlarm> priorityQueue = this.scheduledAlarms;
        synchronized (priorityQueue) {
            for (InternalScheduledAlarm alarm : this.scheduledAlarms) {
                alarm.deschedule();
            }
            this.scheduledAlarms.clear();
        }
    }

    @Implementation
    protected void setTimeZone(String timeZone) {
        ((AlarmManagerReflector)Reflector.reflector(AlarmManagerReflector.class, (Object)this.realObject)).setTimeZone(timeZone);
        TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
    }

    @Implementation(minSdk=31)
    protected boolean canScheduleExactAlarms() {
        return canScheduleExactAlarms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    @Nullable
    protected AlarmManager.AlarmClockInfo getNextAlarmClock() {
        PriorityQueue<InternalScheduledAlarm> priorityQueue = this.scheduledAlarms;
        synchronized (priorityQueue) {
            for (ScheduledAlarm scheduledAlarm : this.scheduledAlarms) {
                AlarmManager.AlarmClockInfo alarmClockInfo = scheduledAlarm.getAlarmClockInfo();
                if (alarmClockInfo == null) continue;
                return alarmClockInfo;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setImpl(int type, long triggerAtMs, long windowLengthMs, long intervalMs, PendingIntent operation, @Nullable WorkSource workSource, @Nullable Object alarmClockInfo, boolean allowWhileIdle) {
        PriorityQueue<InternalScheduledAlarm> priorityQueue = this.scheduledAlarms;
        synchronized (priorityQueue) {
            this.cancel(operation);
            this.scheduledAlarms.add(new InternalScheduledAlarm(type, triggerAtMs, windowLengthMs, intervalMs, operation, workSource, alarmClockInfo, allowWhileIdle).schedule());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setImpl(int type, long triggerAtMs, long windowLengthMs, long intervalMs, @Nullable String tag, AlarmManager.OnAlarmListener listener, Executor executor, @Nullable WorkSource workSource, boolean allowWhileIdle) {
        PriorityQueue<InternalScheduledAlarm> priorityQueue = this.scheduledAlarms;
        synchronized (priorityQueue) {
            this.cancel(listener);
            this.scheduledAlarms.add(new InternalScheduledAlarm(type, triggerAtMs, windowLengthMs, intervalMs, tag, listener, executor, workSource, null, allowWhileIdle).schedule());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nullable
    public ScheduledAlarm getNextScheduledAlarm() {
        PriorityQueue<InternalScheduledAlarm> priorityQueue = this.scheduledAlarms;
        synchronized (priorityQueue) {
            InternalScheduledAlarm alarm = this.scheduledAlarms.poll();
            if (alarm != null) {
                alarm.deschedule();
            }
            return alarm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ScheduledAlarm peekNextScheduledAlarm() {
        PriorityQueue<InternalScheduledAlarm> priorityQueue = this.scheduledAlarms;
        synchronized (priorityQueue) {
            return this.scheduledAlarms.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScheduledAlarm> getScheduledAlarms() {
        PriorityQueue<InternalScheduledAlarm> priorityQueue = this.scheduledAlarms;
        synchronized (priorityQueue) {
            return new ArrayList<ScheduledAlarm>(this.scheduledAlarms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAlarm(ScheduledAlarm alarm) {
        PriorityQueue<InternalScheduledAlarm> priorityQueue = this.scheduledAlarms;
        synchronized (priorityQueue) {
            if (!this.scheduledAlarms.contains(alarm)) {
                throw new IllegalArgumentException();
            }
            ((InternalScheduledAlarm)alarm).deschedule();
            ((InternalScheduledAlarm)alarm).run();
        }
    }

    public static void setCanScheduleExactAlarms(boolean scheduleExactAlarms) {
        canScheduleExactAlarms = scheduleExactAlarms;
    }

    private static final class HandlerExecutor
    implements Executor {
        private final Handler handler;

        HandlerExecutor(@Nullable Handler handler) {
            this.handler = handler != null ? handler : new Handler(Looper.getMainLooper());
        }

        @Override
        public void execute(@Nonnull Runnable command) {
            if (!this.handler.post(command)) {
                throw new RejectedExecutionException(this.handler + " is shutting down");
            }
        }
    }

    private class InternalScheduledAlarm
    extends ScheduledAlarm
    implements Runnable {
        InternalScheduledAlarm(int type, long triggerAtMs, long windowLengthMs, long intervalMs, @Nullable PendingIntent operation, @Nullable WorkSource workSource, Object alarmClockInfo, boolean allowWhileIdle) {
            super(type, triggerAtMs, windowLengthMs, intervalMs, operation, workSource, alarmClockInfo, allowWhileIdle);
        }

        InternalScheduledAlarm(int type, long triggerAtMs, long windowLengthMs, @Nullable long intervalMs, String tag, AlarmManager.OnAlarmListener listener, @Nullable Executor executor, @Nullable WorkSource workSource, Object alarmClockInfo, boolean allowWhileIdle) {
            super(type, triggerAtMs, windowLengthMs, intervalMs, tag, listener, executor, workSource, alarmClockInfo, allowWhileIdle);
        }

        InternalScheduledAlarm(long triggerAtMs, InternalScheduledAlarm alarm) {
            super(triggerAtMs, alarm);
        }

        InternalScheduledAlarm schedule() {
            if (autoSchedule) {
                ShadowAlarmManager.this.schedulingHandler.postDelayed((Runnable)this, this.triggerAtTime - SystemClock.elapsedRealtime());
            }
            return this;
        }

        void deschedule() {
            ShadowAlarmManager.this.schedulingHandler.removeCallbacks((Runnable)this);
        }

        @Override
        public void run() {
            Executor executor = this.operation != null ? Runnable::run : Objects.requireNonNull(this.executor);
            executor.execute(() -> {
                PriorityQueue priorityQueue = ShadowAlarmManager.this.scheduledAlarms;
                synchronized (priorityQueue) {
                    if (!ShadowAlarmManager.this.scheduledAlarms.remove(this)) {
                        return;
                    }
                    if (this.interval > 0L) {
                        ShadowAlarmManager.this.scheduledAlarms.add(new InternalScheduledAlarm(this.triggerAtTime + this.interval, this).schedule());
                    }
                }
                if (this.operation != null) {
                    try {
                        this.operation.send();
                    }
                    catch (PendingIntent.CanceledException e) {
                        ShadowAlarmManager.this.cancel(this.operation);
                    }
                } else if (Build.VERSION.SDK_INT >= 24) {
                    Objects.requireNonNull(this.onAlarmListener).onAlarm();
                } else {
                    throw new IllegalStateException();
                }
            });
        }
    }

    @ForType(value=AlarmManager.class)
    static interface AlarmManagerReflector {
        @Direct
        public void setTimeZone(String var1);
    }

    public static class ScheduledAlarm
    implements Comparable<ScheduledAlarm> {
        @Deprecated
        public final int type;
        @Deprecated
        public final long triggerAtTime;
        private final long windowLengthMs;
        @Deprecated
        public final long interval;
        @Nullable
        private final String tag;
        @Deprecated
        @Nullable
        public final PendingIntent operation;
        @Deprecated
        @Nullable
        public final AlarmManager.OnAlarmListener onAlarmListener;
        @Deprecated
        @Nullable
        public final Executor executor;
        @Nullable
        private final WorkSource workSource;
        @Nullable
        private final Object alarmClockInfo;
        @Deprecated
        public final boolean allowWhileIdle;
        @Deprecated
        @Nullable
        public final PendingIntent showIntent;
        @Deprecated
        @Nullable
        public final Handler handler;

        @Deprecated
        public ScheduledAlarm(int type, long triggerAtMs, PendingIntent operation, PendingIntent showIntent) {
            this(type, triggerAtMs, 0L, operation, showIntent);
        }

        @Deprecated
        public ScheduledAlarm(int type, long triggerAtMs, long intervalMs, PendingIntent operation, PendingIntent showIntent) {
            this(type, triggerAtMs, intervalMs, operation, showIntent, false);
        }

        @Deprecated
        public ScheduledAlarm(int type, long triggerAtMs, long intervalMs, PendingIntent operation, PendingIntent showIntent, boolean allowWhileIdle) {
            this(type, triggerAtMs, intervalMs, -1L, operation, null, showIntent != null ? new AlarmManager.AlarmClockInfo(triggerAtMs, showIntent) : null, allowWhileIdle);
        }

        protected ScheduledAlarm(int type, long triggerAtMs, long windowLengthMs, long intervalMs, PendingIntent operation, @Nullable WorkSource workSource, @Nullable Object alarmClockInfo, boolean allowWhileIdle) {
            this.type = type;
            this.triggerAtTime = triggerAtMs;
            this.windowLengthMs = windowLengthMs;
            this.interval = intervalMs;
            this.tag = null;
            this.operation = Objects.requireNonNull(operation);
            this.onAlarmListener = null;
            this.executor = null;
            this.workSource = workSource;
            this.alarmClockInfo = alarmClockInfo;
            this.allowWhileIdle = allowWhileIdle;
            this.handler = null;
            this.showIntent = alarmClockInfo != null ? ((AlarmManager.AlarmClockInfo)alarmClockInfo).getShowIntent() : null;
        }

        protected ScheduledAlarm(int type, long triggerAtMs, long windowLengthMs, long intervalMs, @Nullable String tag, AlarmManager.OnAlarmListener listener, Executor executor, @Nullable WorkSource workSource, @Nullable Object alarmClockInfo, boolean allowWhileIdle) {
            this.type = type;
            this.triggerAtTime = triggerAtMs;
            this.windowLengthMs = windowLengthMs;
            this.interval = intervalMs;
            this.tag = tag;
            this.operation = null;
            this.onAlarmListener = Objects.requireNonNull(listener);
            this.executor = Objects.requireNonNull(executor);
            this.workSource = workSource;
            this.alarmClockInfo = alarmClockInfo;
            this.allowWhileIdle = allowWhileIdle;
            this.handler = executor instanceof HandlerExecutor ? ((HandlerExecutor)executor).handler : null;
            this.showIntent = alarmClockInfo != null ? ((AlarmManager.AlarmClockInfo)alarmClockInfo).getShowIntent() : null;
        }

        protected ScheduledAlarm(long triggerAtMs, ScheduledAlarm alarm) {
            this.type = alarm.type;
            this.triggerAtTime = triggerAtMs;
            this.windowLengthMs = alarm.windowLengthMs;
            this.interval = alarm.interval;
            this.tag = alarm.tag;
            this.operation = alarm.operation;
            this.onAlarmListener = alarm.onAlarmListener;
            this.executor = alarm.executor;
            this.workSource = alarm.workSource;
            this.alarmClockInfo = alarm.alarmClockInfo;
            this.allowWhileIdle = alarm.allowWhileIdle;
            this.handler = alarm.handler;
            this.showIntent = alarm.showIntent;
        }

        public int getType() {
            return this.type;
        }

        public long getTriggerAtMs() {
            return this.triggerAtTime;
        }

        public long getWindowLengthMs() {
            return this.windowLengthMs;
        }

        public long getIntervalMs() {
            return this.interval;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public WorkSource getWorkSource() {
            return this.workSource;
        }

        @Nullable
        public AlarmManager.AlarmClockInfo getAlarmClockInfo() {
            return (AlarmManager.AlarmClockInfo)this.alarmClockInfo;
        }

        public boolean isAllowWhileIdle() {
            return this.allowWhileIdle;
        }

        @Override
        public int compareTo(@Nonnull ScheduledAlarm scheduledAlarm) {
            return Long.compare(this.triggerAtTime, scheduledAlarm.triggerAtTime);
        }
    }
}

