/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.annotation.RequiresPermission;
import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import android.app.IActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.LocaleList;
import android.os.Process;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.SparseIntArray;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplicationExitInfo;
import org.robolectric.shadows.ShadowApplicationPackageManager;
import org.robolectric.shadows.ShadowUserManager;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ActivityManager.class)
public class ShadowActivityManager {
    private int memoryClass = 16;
    private static String backgroundPackage;
    private static ActivityManager.MemoryInfo memoryInfo;
    private static final List<ActivityManager.AppTask> appTasks;
    private static final List<ActivityManager.RecentTaskInfo> recentTasks;
    private static final List<ActivityManager.RunningTaskInfo> tasks;
    private static final List<ActivityManager.RunningServiceInfo> services;
    private static final List<ActivityManager.RunningAppProcessInfo> processes;
    private static final List<ImportanceListener> importanceListeners;
    private static final SparseIntArray uidImportances;
    @RealObject
    private ActivityManager realObject;
    private static Boolean isLowRamDeviceOverride;
    private int lockTaskModeState = 0;
    private boolean isBackgroundRestricted;
    private static final Deque<Object> appExitInfoList;
    private ConfigurationInfo configurationInfo;
    private Context context;
    private static final ArrayList<Locale> supportedLocales;
    private LocaleList deviceLocales;

    @Implementation
    protected void __constructor__(Context context, Handler handler) {
        Shadow.invokeConstructor(ActivityManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler)});
        this.context = context;
        ActivityManager.RunningAppProcessInfo processInfo = new ActivityManager.RunningAppProcessInfo();
        ShadowActivityManager.fillInProcessInfo(processInfo);
        processInfo.processName = context.getPackageName();
        processInfo.pkgList = new String[]{context.getPackageName()};
        processes.add(processInfo);
    }

    @Implementation
    protected int getMemoryClass() {
        return this.memoryClass;
    }

    @Implementation
    protected static boolean isUserAMonkey() {
        return false;
    }

    @Implementation
    @HiddenApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    protected static int getCurrentUser() {
        return UserHandle.myUserId();
    }

    @Implementation
    protected List<ActivityManager.RunningTaskInfo> getRunningTasks(int maxNum) {
        return tasks;
    }

    @Implementation
    protected List<ActivityManager.AppTask> getAppTasks() {
        return appTasks;
    }

    @Implementation
    protected List<ActivityManager.RecentTaskInfo> getRecentTasks(int maxNum, int flags) {
        return recentTasks.size() > maxNum ? recentTasks.subList(0, maxNum) : recentTasks;
    }

    @Implementation(minSdk=29)
    protected void setDeviceLocales(LocaleList locales) {
        this.deviceLocales = locales == null ? LocaleList.forLanguageTags((String)Locale.ENGLISH.toLanguageTag()) : locales;
    }

    public LocaleList getDeviceLocales() {
        return this.deviceLocales;
    }

    @Implementation
    protected List<ActivityManager.RunningServiceInfo> getRunningServices(int maxNum) {
        return services;
    }

    @Implementation
    protected List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        if (processes.isEmpty()) {
            return null;
        }
        return processes;
    }

    @Implementation
    protected static void getMyMemoryState(ActivityManager.RunningAppProcessInfo inState) {
        ShadowActivityManager.fillInProcessInfo(inState);
        for (ActivityManager.RunningAppProcessInfo info : processes) {
            if (info.pid != Process.myPid()) continue;
            inState.importance = info.importance;
            inState.lru = info.lru;
            inState.importanceReasonCode = info.importanceReasonCode;
            inState.importanceReasonPid = info.importanceReasonPid;
            inState.lastTrimLevel = info.lastTrimLevel;
            inState.pkgList = info.pkgList;
            inState.processName = info.processName;
        }
    }

    private static void fillInProcessInfo(ActivityManager.RunningAppProcessInfo processInfo) {
        processInfo.pid = Process.myPid();
        processInfo.uid = Process.myUid();
    }

    @HiddenApi
    @Implementation
    protected boolean switchUser(int userid) {
        ShadowUserManager shadowUserManager = (ShadowUserManager)Shadow.extract((Object)this.context.getSystemService("user"));
        shadowUserManager.switchUser(userid);
        return true;
    }

    @Implementation(minSdk=29)
    protected boolean switchUser(UserHandle userHandle) {
        return this.switchUser(userHandle.getIdentifier());
    }

    @Implementation
    protected void killBackgroundProcesses(String packageName) {
        backgroundPackage = packageName;
    }

    @Implementation
    protected void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        if (memoryInfo != null) {
            outInfo.availMem = ShadowActivityManager.memoryInfo.availMem;
            outInfo.lowMemory = ShadowActivityManager.memoryInfo.lowMemory;
            outInfo.threshold = ShadowActivityManager.memoryInfo.threshold;
            outInfo.totalMem = ShadowActivityManager.memoryInfo.totalMem;
        }
    }

    @Implementation
    protected ConfigurationInfo getDeviceConfigurationInfo() {
        return this.configurationInfo == null ? new ConfigurationInfo() : this.configurationInfo;
    }

    public void setDeviceConfigurationInfo(ConfigurationInfo configurationInfo) {
        this.configurationInfo = configurationInfo;
    }

    public void setTasks(List<ActivityManager.RunningTaskInfo> tasks) {
        ShadowActivityManager.tasks.clear();
        ShadowActivityManager.tasks.addAll(tasks);
    }

    public void setAppTasks(List<ActivityManager.AppTask> appTasks) {
        ShadowActivityManager.appTasks.clear();
        ShadowActivityManager.appTasks.addAll(appTasks);
    }

    public void setRecentTasks(List<ActivityManager.RecentTaskInfo> recentTasks) {
        ShadowActivityManager.recentTasks.clear();
        ShadowActivityManager.recentTasks.addAll(recentTasks);
    }

    public void setServices(List<ActivityManager.RunningServiceInfo> services) {
        ShadowActivityManager.services.clear();
        ShadowActivityManager.services.addAll(services);
    }

    public void setProcesses(List<ActivityManager.RunningAppProcessInfo> processes) {
        ShadowActivityManager.processes.clear();
        ShadowActivityManager.processes.addAll(processes);
    }

    public String getBackgroundPackage() {
        return backgroundPackage;
    }

    public void setMemoryClass(int memoryClass) {
        this.memoryClass = memoryClass;
    }

    public void setMemoryInfo(ActivityManager.MemoryInfo memoryInfo) {
        ShadowActivityManager.memoryInfo = memoryInfo;
    }

    @Implementation(minSdk=26)
    protected static IActivityManager getService() {
        return (IActivityManager)ReflectionHelpers.createNullProxy(IActivityManager.class);
    }

    @Implementation
    protected boolean isLowRamDevice() {
        if (isLowRamDeviceOverride != null) {
            return isLowRamDeviceOverride;
        }
        return ((ActivityManagerReflector)Reflector.reflector(ActivityManagerReflector.class, (Object)this.realObject)).isLowRamDevice();
    }

    public void setIsLowRamDevice(boolean isLowRamDevice) {
        isLowRamDeviceOverride = isLowRamDevice;
    }

    @Implementation(minSdk=26)
    protected void addOnUidImportanceListener(@ClassName(value="android.app.ActivityManager$OnUidImportanceListener") @ClassName(value="android.app.ActivityManager$OnUidImportanceListener") Object listener, int importanceCutpoint) {
        importanceListeners.add(new ImportanceListener(listener, importanceCutpoint));
    }

    @Implementation(minSdk=26)
    protected void removeOnUidImportanceListener(@ClassName(value="android.app.ActivityManager$OnUidImportanceListener") @ClassName(value="android.app.ActivityManager$OnUidImportanceListener") Object listener) {
        importanceListeners.remove(new ImportanceListener(listener));
    }

    @Implementation(minSdk=23)
    protected int getPackageImportance(String packageName) {
        try {
            return uidImportances.get(this.context.getPackageManager().getPackageUid(packageName, 0), 1000);
        }
        catch (PackageManager.NameNotFoundException e) {
            return 1000;
        }
    }

    @Implementation(minSdk=26)
    protected int getUidImportance(int uid) {
        return uidImportances.get(uid, 1000);
    }

    public void setUidImportance(int uid, int importance) {
        uidImportances.put(uid, importance);
        for (ImportanceListener listener : importanceListeners) {
            listener.onUidImportanceChanged(uid, importance);
        }
    }

    @Implementation(minSdk=23)
    protected int getLockTaskModeState() {
        return this.lockTaskModeState;
    }

    @Implementation
    protected boolean isInLockTaskMode() {
        return this.getLockTaskModeState() != 0;
    }

    public void setLockTaskModeState(int lockTaskModeState) {
        this.lockTaskModeState = lockTaskModeState;
    }

    @Resetter
    public static void reset() {
        backgroundPackage = null;
        memoryInfo = null;
        appTasks.clear();
        recentTasks.clear();
        tasks.clear();
        services.clear();
        processes.clear();
        importanceListeners.clear();
        uidImportances.clear();
        appExitInfoList.clear();
        isLowRamDeviceOverride = null;
        supportedLocales.clear();
    }

    @Implementation(minSdk=28)
    protected boolean isBackgroundRestricted() {
        return this.isBackgroundRestricted;
    }

    public void setBackgroundRestricted(boolean isBackgroundRestricted) {
        this.isBackgroundRestricted = isBackgroundRestricted;
    }

    @Implementation(minSdk=30)
    protected List<?> getHistoricalProcessExitReasons(String packageName, int pid, int maxNum) {
        return appExitInfoList.stream().filter(appExitInfo -> pid == 0 || ((ApplicationExitInfo)appExitInfo).getPid() == pid).limit(maxNum == 0 ? (long)appExitInfoList.size() : (long)maxNum).collect(Collectors.toCollection(ArrayList::new));
    }

    @Deprecated
    @RequiresApi(api=30)
    public void addApplicationExitInfo(String processName, int pid, int reason, int status) {
        ApplicationExitInfo info = ApplicationExitInfoBuilder.newBuilder().setProcessName(processName).setPid(pid).setReason(reason).setStatus(status).build();
        this.addApplicationExitInfo(info);
    }

    @RequiresApi(api=30)
    public void addApplicationExitInfo(Object info) {
        Preconditions.checkArgument((boolean)(info instanceof ApplicationExitInfo));
        appExitInfoList.addFirst(info);
    }

    @Implementation
    protected boolean clearApplicationUserData(String packageName, IPackageDataObserver observer) {
        this.context.getPackageManager().clearApplicationUserData(packageName, observer);
        return true;
    }

    public boolean isApplicationUserDataCleared() {
        PackageManager packageManager = RuntimeEnvironment.getApplication().getPackageManager();
        return ((ShadowApplicationPackageManager)Shadow.extract((Object)packageManager)).getClearedApplicationUserDataPackages().contains(RuntimeEnvironment.getApplication().getPackageName());
    }

    static {
        appTasks = new CopyOnWriteArrayList<ActivityManager.AppTask>();
        recentTasks = new CopyOnWriteArrayList<ActivityManager.RecentTaskInfo>();
        tasks = new CopyOnWriteArrayList<ActivityManager.RunningTaskInfo>();
        services = new CopyOnWriteArrayList<ActivityManager.RunningServiceInfo>();
        processes = new CopyOnWriteArrayList<ActivityManager.RunningAppProcessInfo>();
        importanceListeners = new CopyOnWriteArrayList<ImportanceListener>();
        uidImportances = new SparseIntArray();
        isLowRamDeviceOverride = null;
        appExitInfoList = new ArrayDeque<Object>();
        supportedLocales = new ArrayList();
    }

    @ForType(value=ActivityManager.class)
    static interface ActivityManagerReflector {
        @Direct
        public boolean isLowRamDevice();
    }

    private static class ImportanceListener {
        private final ActivityManager.OnUidImportanceListener listener;
        private final int importanceCutpoint;
        private final ArrayMap<Integer, Boolean> lastAboveCuts = new ArrayMap();

        ImportanceListener(Object listener) {
            this(listener, 0);
        }

        ImportanceListener(Object listener, int importanceCutpoint) {
            this.listener = (ActivityManager.OnUidImportanceListener)listener;
            this.importanceCutpoint = importanceCutpoint;
        }

        void onUidImportanceChanged(int uid, int importance) {
            Boolean isAboveCut = importance > this.importanceCutpoint;
            if (!isAboveCut.equals(this.lastAboveCuts.get((Object)uid))) {
                this.lastAboveCuts.put((Object)uid, (Object)isAboveCut);
                this.listener.onUidImportance(uid, importance);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImportanceListener)) {
                return false;
            }
            ImportanceListener that = (ImportanceListener)o;
            return this.listener.equals((Object)that.listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    @RequiresApi(api=30)
    public static class ApplicationExitInfoBuilder {
        private final ApplicationExitInfo instance = new ApplicationExitInfo();
        private final ShadowApplicationExitInfo shadow = (ShadowApplicationExitInfo)Shadow.extract((Object)this.instance);

        public static ApplicationExitInfoBuilder newBuilder() {
            return new ApplicationExitInfoBuilder();
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setDefiningUid(int uid) {
            this.instance.setDefiningUid(uid);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setDescription(String description) {
            this.instance.setDescription(description);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setImportance(int importance) {
            this.instance.setImportance(importance);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setPackageUid(int packageUid) {
            this.instance.setPackageUid(packageUid);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setPid(int pid) {
            this.instance.setPid(pid);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setProcessName(String processName) {
            this.instance.setProcessName(processName);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setProcessStateSummary(byte[] processStateSummary) {
            this.instance.setProcessStateSummary(processStateSummary);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setPss(long pss) {
            this.instance.setPss(pss);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setRealUid(int realUid) {
            this.instance.setRealUid(realUid);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setReason(int reason) {
            this.instance.setReason(reason);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setRss(long rss) {
            this.instance.setRss(rss);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setStatus(int status) {
            this.instance.setStatus(status);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setTimestamp(long timestamp) {
            this.instance.setTimestamp(timestamp);
            return this;
        }

        @CanIgnoreReturnValue
        public ApplicationExitInfoBuilder setTraceInputStream(InputStream in) {
            this.shadow.setTraceInputStream(in);
            return this;
        }

        public ApplicationExitInfo build() {
            return this.instance;
        }

        private ApplicationExitInfoBuilder() {
        }
    }
}

