/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Rect;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAccessibilityNodeInfo;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=AccessibilityWindowInfo.class)
public class ShadowAccessibilityWindowInfo {
    private List<AccessibilityWindowInfo> children = null;
    private AccessibilityWindowInfo parent = null;
    private AccessibilityNodeInfo rootNode = null;
    private AccessibilityNodeInfo anchorNode = null;
    private Rect boundsInScreenOverride;
    @RealObject
    private AccessibilityWindowInfo realAccessibilityWindowInfo;

    @Implementation
    protected static AccessibilityWindowInfo obtain(AccessibilityWindowInfo window) {
        AccessibilityWindowInfo newInstance = ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class)).obtain(window);
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return newInstance;
        }
        ShadowAccessibilityWindowInfo shadowInfo = (ShadowAccessibilityWindowInfo)Shadow.extract((Object)window);
        ShadowAccessibilityWindowInfo newShadow = (ShadowAccessibilityWindowInfo)Shadow.extract((Object)newInstance);
        if (shadowInfo.boundsInScreenOverride != null) {
            newShadow.boundsInScreenOverride = new Rect(shadowInfo.boundsInScreenOverride);
        }
        newShadow.parent = shadowInfo.parent;
        newShadow.rootNode = shadowInfo.rootNode;
        newShadow.anchorNode = shadowInfo.anchorNode;
        newShadow.children = shadowInfo.children != null ? new ArrayList<AccessibilityWindowInfo>(shadowInfo.children) : null;
        return newInstance;
    }

    @Implementation
    protected int getChildCount() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).getChildCount();
        }
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Implementation
    protected AccessibilityWindowInfo getChild(int index) {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).getChild(index);
        }
        if (this.children == null) {
            return null;
        }
        return this.children.get(index);
    }

    @Implementation
    protected AccessibilityWindowInfo getParent() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).getParent();
        }
        return this.parent;
    }

    @Implementation
    protected AccessibilityNodeInfo getRoot() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).getRoot();
        }
        return this.rootNode == null ? null : AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)this.rootNode);
    }

    @Implementation(minSdk=24)
    protected AccessibilityNodeInfo getAnchor() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).getAnchor();
        }
        return this.anchorNode == null ? null : AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)this.anchorNode);
    }

    @Implementation
    protected void getBoundsInScreen(Rect outBounds) {
        if (ShadowAccessibilityNodeInfo.useRealAni() || this.boundsInScreenOverride == null) {
            ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).getBoundsInScreen(outBounds);
        } else {
            outBounds.set(this.boundsInScreenOverride);
        }
    }

    @Implementation
    protected void recycle() {
        ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).recycle();
        this.children = null;
        this.parent = null;
        this.rootNode = null;
        this.anchorNode = null;
        this.boundsInScreenOverride = null;
    }

    public void setRoot(AccessibilityNodeInfo root) {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        this.rootNode = root;
    }

    public void setAnchor(AccessibilityNodeInfo anchor) {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        this.anchorNode = anchor;
    }

    @Implementation
    public void setType(int value) {
        ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).setType(value);
    }

    @Implementation(maxSdk=29)
    public void setBoundsInScreen(Rect bounds) {
        if (RuntimeEnvironment.getApiLevel() <= 29) {
            ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).setBoundsInScreen(bounds);
        } else {
            this.boundsInScreenOverride = bounds;
        }
    }

    @Implementation
    public void setAccessibilityFocused(boolean value) {
        ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).setAccessibilityFocused(value);
    }

    @Implementation
    public void setActive(boolean value) {
        ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).setActive(value);
    }

    @Implementation
    public void setId(int value) {
        ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).setId(value);
    }

    @Implementation
    public void setLayer(int value) {
        ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).setLayer(value);
    }

    @Implementation(minSdk=24)
    public void setTitle(CharSequence value) {
        ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).setTitle(value);
    }

    @Implementation
    public void setFocused(boolean focused) {
        ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).setFocused(focused);
    }

    @Implementation(minSdk=26)
    public void setPictureInPicture(boolean pictureInPicture) {
        ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).setPictureInPicture(pictureInPicture);
    }

    @Implementation(minSdk=30)
    public void setDisplayId(int displayId) {
        ((AccessibilityWindowInfoReflector)Reflector.reflector(AccessibilityWindowInfoReflector.class, (Object)this.realAccessibilityWindowInfo)).setDisplayId(displayId);
    }

    public void addChild(AccessibilityWindowInfo child) {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        if (this.children == null) {
            this.children = new ArrayList<AccessibilityWindowInfo>();
        }
        this.children.add(child);
        ((ShadowAccessibilityWindowInfo)Shadow.extract((Object)child)).parent = this.realAccessibilityWindowInfo;
    }

    @ForType(value=AccessibilityWindowInfo.class)
    static interface AccessibilityWindowInfoReflector {
        @Direct
        public void setId(int var1);

        @Direct
        public void setType(int var1);

        @Direct
        public void setAccessibilityFocused(boolean var1);

        @Direct
        public void setActive(boolean var1);

        @Direct
        public void setLayer(int var1);

        @Direct
        public void setTitle(CharSequence var1);

        @Direct
        public void setFocused(boolean var1);

        @Direct
        public void setPictureInPicture(boolean var1);

        @Direct
        public void setDisplayId(int var1);

        @Direct
        public void setBoundsInScreen(Rect var1);

        @Direct
        public void getBoundsInScreen(Rect var1);

        @Direct
        public int getChildCount();

        @Direct
        public AccessibilityWindowInfo getChild(int var1);

        @Direct
        public AccessibilityWindowInfo getParent();

        @Direct
        public AccessibilityNodeInfo getRoot();

        @Direct
        public AccessibilityNodeInfo getAnchor();

        @Direct
        public void recycle();

        @Direct
        @Static
        public AccessibilityWindowInfo obtain(AccessibilityWindowInfo var1);
    }
}

