/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.os.Parcel;
import android.telephony.CellIdentityGsm;
import android.telephony.CellInfoGsm;
import android.telephony.CellSignalStrengthGsm;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.shadows.CellIdentityGsmBuilder;
import org.robolectric.shadows.CellSignalStrengthGsmBuilder;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@RequiresApi(value=29)
public class CellInfoGsmBuilder {
    private boolean isRegistered = false;
    private long timeStamp = 0L;
    private int cellConnectionStatus = 0;
    private CellIdentityGsm cellIdentity;
    private CellSignalStrengthGsm cellSignalStrength;

    private CellInfoGsmBuilder() {
    }

    public static CellInfoGsmBuilder newBuilder() {
        return new CellInfoGsmBuilder();
    }

    public CellInfoGsmBuilder setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
        return this;
    }

    public CellInfoGsmBuilder setTimeStampNanos(long timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public CellInfoGsmBuilder setCellConnectionStatus(int cellConnectionStatus) {
        this.cellConnectionStatus = cellConnectionStatus;
        return this;
    }

    public CellInfoGsmBuilder setCellIdentity(CellIdentityGsm cellIdentity) {
        this.cellIdentity = cellIdentity;
        return this;
    }

    public CellInfoGsmBuilder setCellSignalStrength(CellSignalStrengthGsm cellSignalStrength) {
        this.cellSignalStrength = cellSignalStrength;
        return this;
    }

    public CellInfoGsm build() {
        if (this.cellIdentity == null) {
            this.cellIdentity = CellIdentityGsmBuilder.getDefaultInstance();
        }
        if (this.cellSignalStrength == null) {
            this.cellSignalStrength = CellSignalStrengthGsmBuilder.getDefaultInstance();
        }
        if (RuntimeEnvironment.getApiLevel() <= 33) {
            Parcel p = Parcel.obtain();
            p.writeInt(1);
            p.writeInt(this.isRegistered ? 1 : 0);
            p.writeLong(this.timeStamp);
            p.writeInt(this.cellConnectionStatus);
            this.cellIdentity.writeToParcel(p, 0);
            this.cellSignalStrength.writeToParcel(p, 0);
            p.setDataPosition(0);
            CellInfoGsm cellInfoGsm = (CellInfoGsm)CellInfoGsm.CREATOR.createFromParcel(p);
            p.recycle();
            return cellInfoGsm;
        }
        return ((CellInfoGsmReflector)Reflector.reflector(CellInfoGsmReflector.class)).newCellInfoGsm(this.cellConnectionStatus, this.isRegistered, this.timeStamp, this.cellIdentity, this.cellSignalStrength);
    }

    @ForType(value=CellInfoGsm.class)
    private static interface CellInfoGsmReflector {
        @Constructor
        public CellInfoGsm newCellInfoGsm(int var1, boolean var2, long var3, CellIdentityGsm var5, CellSignalStrengthGsm var6);
    }
}

