/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.Pair;
import android.view.KeyEvent;
import android.view.inputmethod.SurroundingText;
import android.view.inputmethod.TextAttribute;
import com.android.internal.inputmethod.RemoteAccessibilityInputConnection;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowAccessibilityInputConnection;

@Implements(value=RemoteAccessibilityInputConnection.class, minSdk=33, isInAndroidSdk=false)
public class ShadowRemoteAccessibilityInputConnection {
    private SurroundingText surroundingTextToReturn = null;
    private final List<Integer> contextMenuActions = new ArrayList<Integer>();
    private final List<Integer> editorActions = new ArrayList<Integer>();
    private final List<KeyEvent> keyEvents = new ArrayList<KeyEvent>();
    private final List<Pair<Integer, Integer>> setSelections = new ArrayList<Pair<Integer, Integer>>();
    private final List<ShadowAccessibilityInputConnection.SurroundingTextArgs> surroundingTextArguments = new ArrayList<ShadowAccessibilityInputConnection.SurroundingTextArgs>();
    private final List<ShadowAccessibilityInputConnection.CommitTextArgs> commitTextArguments = new ArrayList<ShadowAccessibilityInputConnection.CommitTextArgs>();
    private final List<Pair<Integer, Integer>> deleteSurroundingTextArguments = new ArrayList<Pair<Integer, Integer>>();

    @Implementation(minSdk=33)
    protected void commitText(CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        this.commitTextArguments.add(ShadowAccessibilityInputConnection.CommitTextArgs.create(text, newCursorPosition, textAttribute));
    }

    @Implementation(minSdk=33)
    protected SurroundingText getSurroundingText(int beforeLength, int afterLength, int flags) {
        this.surroundingTextArguments.add(ShadowAccessibilityInputConnection.SurroundingTextArgs.create(beforeLength, afterLength, flags));
        return this.surroundingTextToReturn;
    }

    @Implementation(minSdk=33)
    protected void performContextMenuAction(int id2) {
        this.contextMenuActions.add(id2);
    }

    @Implementation(minSdk=33)
    protected void performEditorAction(int editorAction) {
        this.editorActions.add(editorAction);
    }

    @Implementation(minSdk=33)
    protected void sendKeyEvent(KeyEvent event) {
        this.keyEvents.add(event);
    }

    @Implementation(minSdk=33)
    protected void setSelection(int start, int end) {
        this.setSelections.add((Pair<Integer, Integer>)Pair.create((Object)start, (Object)end));
    }

    @Implementation(minSdk=33)
    protected void deleteSurroundingText(int beforeLength, int afterLength) {
        this.deleteSurroundingTextArguments.add((Pair<Integer, Integer>)Pair.create((Object)beforeLength, (Object)afterLength));
    }

    List<ShadowAccessibilityInputConnection.CommitTextArgs> getCommitTextArguments() {
        return ImmutableList.copyOf(this.commitTextArguments);
    }

    void setSurroundingText(SurroundingText surroundingText) {
        this.surroundingTextToReturn = surroundingText;
    }

    List<ShadowAccessibilityInputConnection.SurroundingTextArgs> getSurroundingTextArguments() {
        return ImmutableList.copyOf(this.surroundingTextArguments);
    }

    List<Integer> getContextMenuActions() {
        return ImmutableList.copyOf(this.contextMenuActions);
    }

    List<Integer> getEditorActions() {
        return ImmutableList.copyOf(this.editorActions);
    }

    List<KeyEvent> getKeyEvents() {
        return ImmutableList.copyOf(this.keyEvents);
    }

    List<Pair<Integer, Integer>> getSetSelections() {
        return ImmutableList.copyOf(this.setSelections);
    }

    List<Pair<Integer, Integer>> getDeleteSurroundingTextArguments() {
        return ImmutableList.copyOf(this.deleteSurroundingTextArguments);
    }
}

