/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.Network;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.AutoValue_ShadowNsdManager_NsdServiceKey;
import org.robolectric.util.Logger;

@Implements(value=NsdManager.class)
public class ShadowNsdManager {
    private static final Map<NsdServiceKey, NsdManager.RegistrationListener> registeredServices = new HashMap<NsdServiceKey, NsdManager.RegistrationListener>();
    private static final Map<NsdManager.RegistrationListener, NsdServiceInfo> registeredListeners = new HashMap<NsdManager.RegistrationListener, NsdServiceInfo>();
    private static final Map<NsdManager.DiscoveryListener, String> discoveryListeners = new HashMap<NsdManager.DiscoveryListener, String>();
    private static final Map<String, ArrayList<NsdManager.DiscoveryListener>> discoveryServiceTypes = new HashMap<String, ArrayList<NsdManager.DiscoveryListener>>();
    private static final Map<NsdManager.ResolveListener, NsdServiceInfo> resolveListeners = new HashMap<NsdManager.ResolveListener, NsdServiceInfo>();
    private static final Map<NsdServiceKey, ArrayList<NsdManager.ResolveListener>> resolveServices = new HashMap<NsdServiceKey, ArrayList<NsdManager.ResolveListener>>();

    @Implementation(maxSdk=32)
    protected void init() {
    }

    @Implementation(maxSdk=32)
    protected void registerService(NsdServiceInfo serviceInfo, int protocolType, NsdManager.RegistrationListener listener) {
        this.registerService(serviceInfo, protocolType, Runnable::run, listener);
    }

    @Implementation(minSdk=33)
    protected void registerService(NsdServiceInfo serviceInfo, int protocolType, Executor executor, NsdManager.RegistrationListener listener) {
        NsdServiceKey serviceKey = NsdServiceKey.create(serviceInfo.getServiceName(), serviceInfo.getServiceType());
        if (registeredListeners.containsKey(listener)) {
            throw new UnsupportedOperationException("registerService: listener already registered");
        }
        if (protocolType != 1) {
            Logger.warn((String)"registerService: invalid protocol type", (Object[])new Object[0]);
            executor.execute(() -> listener.onRegistrationFailed(serviceInfo, 6));
            return;
        }
        registeredServices.put(serviceKey, listener);
        registeredListeners.put(listener, serviceInfo);
        executor.execute(() -> listener.onServiceRegistered(serviceInfo));
    }

    @Implementation
    protected void unregisterService(NsdManager.RegistrationListener listener) {
        if (!registeredListeners.containsKey(listener)) {
            throw new UnsupportedOperationException("unregisterService: listener not registered");
        }
        NsdServiceInfo serviceInfo = registeredListeners.get(listener);
        registeredServices.remove(ShadowNsdManager.getServiceKey(serviceInfo));
        registeredListeners.remove(listener);
        listener.onServiceUnregistered(serviceInfo);
    }

    @Implementation(maxSdk=32)
    protected void discoverServices(String serviceType, int protocolType, NsdManager.DiscoveryListener listener) {
        this.discoverServices(serviceType, protocolType, null, Runnable::run, listener);
    }

    @Implementation(minSdk=33)
    protected void discoverServices(String serviceType, int protocolType, Network network, Executor executor, NsdManager.DiscoveryListener listener) {
        if (discoveryListeners.containsKey(listener)) {
            throw new UnsupportedOperationException("discoverServices: listener already registered");
        }
        discoveryServiceTypes.putIfAbsent(serviceType, new ArrayList());
        discoveryServiceTypes.get(serviceType).add(listener);
        discoveryListeners.put(listener, serviceType);
        executor.execute(() -> listener.onDiscoveryStarted(serviceType));
    }

    @Implementation
    protected void stopServiceDiscovery(NsdManager.DiscoveryListener listener) {
        if (!discoveryListeners.containsKey(listener)) {
            throw new UnsupportedOperationException("stopServiceDiscovery: listener not registered");
        }
        String serviceType = discoveryListeners.get(listener);
        discoveryServiceTypes.remove(serviceType);
        discoveryListeners.remove(listener);
        listener.onDiscoveryStopped(serviceType);
    }

    @Implementation
    protected void resolveService(NsdServiceInfo serviceInfo, NsdManager.ResolveListener listener) {
        if (resolveListeners.containsKey(listener)) {
            throw new UnsupportedOperationException("resolveService: listener already registered");
        }
        NsdServiceKey serviceKey = ShadowNsdManager.getServiceKey(serviceInfo);
        resolveServices.putIfAbsent(serviceKey, new ArrayList());
        if (!resolveServices.containsKey(serviceKey)) {
            resolveServices.put(serviceKey, new ArrayList());
        }
        resolveServices.get(serviceKey).add(listener);
        resolveListeners.put(listener, serviceInfo);
    }

    private static NsdServiceKey getServiceKey(NsdServiceInfo serviceInfo) {
        return NsdServiceKey.create(serviceInfo.getServiceName(), serviceInfo.getServiceType());
    }

    @Resetter
    public static void reset() {
        registeredServices.clear();
        registeredListeners.clear();
        discoveryListeners.clear();
        discoveryServiceTypes.clear();
        resolveListeners.clear();
        resolveServices.clear();
    }

    @Nullable
    public NsdManager.RegistrationListener getRegistrationListener(NsdServiceInfo serviceInfo) {
        NsdServiceKey serviceKey = ShadowNsdManager.getServiceKey(serviceInfo);
        if (registeredServices.containsKey(serviceKey)) {
            return registeredServices.get(serviceKey);
        }
        return null;
    }

    @Nullable
    public NsdServiceInfo getRegisteredServiceInfo(NsdManager.RegistrationListener listener) {
        if (registeredListeners.containsKey(listener)) {
            return registeredListeners.get(listener);
        }
        return null;
    }

    @Nullable
    public List<NsdManager.DiscoveryListener> getDiscoveryListeners(String serviceType) {
        if (discoveryServiceTypes.containsKey(serviceType)) {
            return new ArrayList<NsdManager.DiscoveryListener>((Collection)discoveryServiceTypes.get(serviceType));
        }
        return null;
    }

    @Nullable
    public String getDiscoveryListenerServiceType(NsdManager.DiscoveryListener listener) {
        if (discoveryListeners.containsKey(listener)) {
            return discoveryListeners.get(listener);
        }
        return null;
    }

    @Nullable
    public List<NsdManager.ResolveListener> getResolveListeners(NsdServiceInfo serviceInfo) {
        NsdServiceKey serviceKey = ShadowNsdManager.getServiceKey(serviceInfo);
        if (resolveServices.containsKey(serviceKey)) {
            return new ArrayList<NsdManager.ResolveListener>((Collection)resolveServices.get(serviceKey));
        }
        return null;
    }

    @Nullable
    public NsdServiceInfo getResolveListenerServiceInfo(NsdManager.ResolveListener listener) {
        if (resolveListeners.containsKey(listener)) {
            return resolveListeners.get(listener);
        }
        return null;
    }

    protected void removeResolveListener(NsdManager.ResolveListener listener) {
        if (resolveListeners.containsKey(listener)) {
            NsdServiceInfo serviceInfo = resolveListeners.get(listener);
            NsdServiceKey serviceKey = ShadowNsdManager.getServiceKey(serviceInfo);
            resolveServices.get(serviceKey).remove(listener);
            resolveListeners.remove(listener);
        }
    }

    @AutoValue
    static abstract class NsdServiceKey {
        NsdServiceKey() {
        }

        public static NsdServiceKey create(String serviceName, String serviceType) {
            return new AutoValue_ShadowNsdManager_NsdServiceKey(serviceName, serviceType);
        }

        abstract String serviceName();

        abstract String serviceType();
    }
}

