/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaDataSource;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import java.io.FileDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.util.DataSource;

@Implements(value=MediaMetadataRetriever.class)
public class ShadowMediaMetadataRetriever {
    private DataSource dataSource;
    private static final Map<DataSource, Map<Integer, String>> metadata = new HashMap<DataSource, Map<Integer, String>>();
    private static final Map<DataSource, Map<Long, Bitmap>> frames = new HashMap<DataSource, Map<Long, Bitmap>>();
    private static final Map<DataSource, Map<String, Bitmap>> scaledFrames = new HashMap<DataSource, Map<String, Bitmap>>();
    private static final Map<DataSource, RuntimeException> exceptions = new HashMap<DataSource, RuntimeException>();

    public void setDataSource(DataSource dataSource) {
        RuntimeException e = exceptions.get(dataSource);
        if (e != null) {
            e.fillInStackTrace();
            throw e;
        }
        this.dataSource = dataSource;
    }

    @Implementation
    protected void setDataSource(String path) {
        this.setDataSource(DataSource.toDataSource(path));
    }

    @Implementation
    protected void setDataSource(Context context, Uri uri) {
        this.setDataSource(DataSource.toDataSource(context, uri));
    }

    @Implementation
    protected void setDataSource(String uri, Map<String, String> headers) {
        this.setDataSource(DataSource.toDataSource(uri, headers));
    }

    @Implementation
    protected void setDataSource(FileDescriptor fd, long offset, long length) {
        this.setDataSource(DataSource.toDataSource(fd, offset, length));
    }

    @Implementation(minSdk=23)
    protected void setDataSource(MediaDataSource mediaDataSource) {
        this.setDataSource(DataSource.toDataSource(mediaDataSource));
    }

    @Implementation
    protected String extractMetadata(int keyCode) {
        if (metadata.containsKey(this.dataSource)) {
            return metadata.get(this.dataSource).get(keyCode);
        }
        return null;
    }

    @Implementation(minSdk=30)
    protected Bitmap getFrameAtTime(long timeUs, int option, MediaMetadataRetriever.BitmapParams params) {
        return this.getFrameAtTime(timeUs, option);
    }

    @Implementation
    protected Bitmap getFrameAtTime(long timeUs, int option) {
        return frames.containsKey(this.dataSource) ? frames.get(this.dataSource).get(timeUs) : null;
    }

    @Implementation
    protected Bitmap getFrameAtTime() {
        return this.getFrameAtTime(1L, 0);
    }

    @Implementation(minSdk=27)
    protected Bitmap getScaledFrameAtTime(long timeUs, int option, int dstWidth, int dstHeight) {
        return scaledFrames.containsKey(this.dataSource) ? scaledFrames.get(this.dataSource).get(ShadowMediaMetadataRetriever.getScaledFrameKey(timeUs, dstWidth, dstHeight)) : null;
    }

    public static void addException(DataSource ds, RuntimeException e) {
        exceptions.put(ds, e);
    }

    public static void addMetadata(DataSource ds, int keyCode, String value) {
        if (!metadata.containsKey(ds)) {
            metadata.put(ds, new HashMap());
        }
        metadata.get(ds).put(keyCode, value);
    }

    public static void addMetadata(String path, int keyCode, String value) {
        ShadowMediaMetadataRetriever.addMetadata(DataSource.toDataSource(path), keyCode, value);
    }

    public static void addFrame(DataSource ds, long time, Bitmap bitmap) {
        if (!frames.containsKey(ds)) {
            frames.put(ds, new HashMap());
        }
        frames.get(ds).put(time, bitmap);
    }

    public static void addScaledFrame(DataSource ds, long time, int dstWidth, int dstHeight, Bitmap bitmap) {
        if (!scaledFrames.containsKey(ds)) {
            scaledFrames.put(ds, new HashMap());
        }
        scaledFrames.get(ds).put(ShadowMediaMetadataRetriever.getScaledFrameKey(time, dstWidth, dstHeight), bitmap);
    }

    public static void addFrame(String path, long time, Bitmap bitmap) {
        ShadowMediaMetadataRetriever.addFrame(DataSource.toDataSource(path), time, bitmap);
    }

    public static void addFrame(Context context, Uri uri, long time, Bitmap bitmap) {
        ShadowMediaMetadataRetriever.addFrame(DataSource.toDataSource(context, uri), time, bitmap);
    }

    public static void addFrame(String uri, Map<String, String> headers, long time, Bitmap bitmap) {
        ShadowMediaMetadataRetriever.addFrame(DataSource.toDataSource(uri, headers), time, bitmap);
    }

    public static void addFrame(FileDescriptor fd, long time, Bitmap bitmap) {
        ShadowMediaMetadataRetriever.addFrame(DataSource.toDataSource(fd), time, bitmap);
    }

    public static void addFrame(FileDescriptor fd, long offset, long length, long time, Bitmap bitmap) {
        ShadowMediaMetadataRetriever.addFrame(DataSource.toDataSource(fd, offset, length), time, bitmap);
    }

    @Resetter
    public static void reset() {
        metadata.clear();
        frames.clear();
        scaledFrames.clear();
        exceptions.clear();
        DataSource.reset();
    }

    private static String getScaledFrameKey(long time, int dstWidth, int dstHeight) {
        return String.format("%d_%dx%d", time, dstWidth, dstHeight);
    }
}

