/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.HardwareRenderer;
import android.graphics.RenderNode;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.shadows.ShadowVirtualRefBasePtr;

@Implements(value=HardwareRenderer.class, isInAndroidSdk=false, minSdk=29)
public class ShadowHardwareRenderer {
    private static long nextCreateProxy = 0L;

    @Implementation(maxSdk=29)
    protected static long nCreateProxy(boolean translucent, long rootRenderNode) {
        return ++nextCreateProxy;
    }

    @Implementation
    protected static long nCreateTextureLayer(long nativeProxy) {
        return ShadowVirtualRefBasePtr.put(nativeProxy);
    }

    @Implementation(minSdk=30, maxSdk=30)
    protected static long nCreateProxy(boolean translucent, boolean isWideGamut, long rootRenderNode) {
        return ShadowHardwareRenderer.nCreateProxy(translucent, rootRenderNode);
    }

    @Implementation(minSdk=31, methodName="nCreateProxy")
    protected static long nCreateProxyFromS(boolean translucent, long rootRenderNode) {
        return ShadowHardwareRenderer.nCreateProxy(translucent, rootRenderNode);
    }

    @Implementation
    protected static Bitmap createHardwareBitmap(@ClassName(value="android.graphics.RenderNode") @ClassName(value="android.graphics.RenderNode") RenderNode node, int width, int height) {
        return ShadowHardwareRenderer.createHardwareBitmap(width, height);
    }

    private static Bitmap createHardwareBitmap(int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.HARDWARE);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.setMutable(false);
        return bitmap;
    }

    @Resetter
    public static void reset() {
        nextCreateProxy = 0L;
    }
}

