/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.AlertDialog;
import android.view.View;
import android.widget.Adapter;
import com.android.internal.app.AlertController;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAlertController;
import org.robolectric.shadows.ShadowDialog;
import org.robolectric.shadows.ShadowListView;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AlertDialog.class)
public class ShadowAlertDialog
extends ShadowDialog {
    @RealObject
    private AlertDialog realAlertDialog;
    private static ShadowAlertDialog latestAlertDialog;

    public static AlertDialog getLatestAlertDialog() {
        return latestAlertDialog == null ? null : ShadowAlertDialog.latestAlertDialog.realAlertDialog;
    }

    @Resetter
    public static void reset() {
        latestAlertDialog = null;
    }

    public void clickOnItem(int index) {
        ShadowListView shadowListView = (ShadowListView)Shadow.extract((Object)this.realAlertDialog.getListView());
        shadowListView.performItemClick(index);
    }

    @Override
    public CharSequence getTitle() {
        return this.getShadowAlertController().getTitle();
    }

    public CharSequence[] getItems() {
        Adapter adapter = this.getShadowAlertController().getAdapter();
        int count = adapter.getCount();
        CharSequence[] items = new CharSequence[count];
        for (int i = 0; i < items.length; ++i) {
            items[i] = (CharSequence)adapter.getItem(i);
        }
        return items;
    }

    public Adapter getAdapter() {
        return this.getShadowAlertController().getAdapter();
    }

    public CharSequence getMessage() {
        return this.getShadowAlertController().getMessage();
    }

    @Override
    public void show() {
        super.show();
        latestAlertDialog = this;
    }

    public View getView() {
        return this.getShadowAlertController().getView();
    }

    public int getIconId() {
        return this.getShadowAlertController().getIconId();
    }

    public View getCustomTitleView() {
        return this.getShadowAlertController().getCustomTitleView();
    }

    private ShadowAlertController getShadowAlertController() {
        AlertController alertController = (AlertController)ReflectionHelpers.getField((Object)this.realAlertDialog, (String)"mAlert");
        return (ShadowAlertController)Shadow.extract((Object)alertController);
    }
}

