/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Bundle;
import android.util.Pair;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAccessibilityWindowInfo;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=AccessibilityNodeInfo.class)
public class ShadowAccessibilityNodeInfo {
    private static int sAllocationCount = 0;
    private long mOriginNodeId;
    private List<AccessibilityNodeInfo> children;
    private List<Pair<Integer, Bundle>> performedActionAndArgsList;
    private AccessibilityNodeInfo parent;
    private AccessibilityNodeInfo labelFor;
    private AccessibilityNodeInfo labeledBy;
    private View view;
    private CharSequence text;
    private boolean refreshReturnValue = true;
    private AccessibilityWindowInfo accessibilityWindowInfo;
    private AccessibilityNodeInfo traversalAfter;
    private AccessibilityNodeInfo traversalBefore;
    private OnPerformActionListener actionListener;
    private static boolean queryFromAppProcessWasEnabled;
    @RealObject
    private AccessibilityNodeInfo realAccessibilityNodeInfo;
    @ReflectorObject
    AccessibilityNodeInfoReflector accessibilityNodeInfoReflector;

    @Implementation
    protected static AccessibilityNodeInfo obtain(AccessibilityNodeInfo info) {
        AccessibilityNodeInfo newInfo;
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return ((AccessibilityNodeInfoReflector)Reflector.reflector(AccessibilityNodeInfoReflector.class)).obtain(info);
        }
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            newInfo = ((AccessibilityNodeInfoReflector)Reflector.reflector(AccessibilityNodeInfoReflector.class)).newInstance(info);
        } else {
            newInfo = (AccessibilityNodeInfo)Shadow.newInstanceOf(AccessibilityNodeInfo.class);
            ((AccessibilityNodeInfoReflector)Reflector.reflector(AccessibilityNodeInfoReflector.class, (Object)newInfo)).init(info);
        }
        ShadowAccessibilityNodeInfo newShadow = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)newInfo);
        ShadowAccessibilityNodeInfo shadowInfo = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)info);
        newShadow.mOriginNodeId = shadowInfo.mOriginNodeId;
        newShadow.text = shadowInfo.text;
        newShadow.performedActionAndArgsList = shadowInfo.performedActionAndArgsList;
        newShadow.parent = shadowInfo.parent;
        newShadow.labelFor = shadowInfo.labelFor == null ? null : ShadowAccessibilityNodeInfo.obtain(shadowInfo.labelFor);
        newShadow.labeledBy = shadowInfo.labeledBy == null ? null : ShadowAccessibilityNodeInfo.obtain(shadowInfo.labeledBy);
        newShadow.view = shadowInfo.view;
        newShadow.actionListener = shadowInfo.actionListener;
        if (shadowInfo.children != null) {
            newShadow.children = new ArrayList<AccessibilityNodeInfo>();
            newShadow.children.addAll(shadowInfo.children);
        } else {
            newShadow.children = null;
        }
        newShadow.refreshReturnValue = shadowInfo.refreshReturnValue;
        newShadow.traversalAfter = shadowInfo.traversalAfter == null ? null : ShadowAccessibilityNodeInfo.obtain(shadowInfo.traversalAfter);
        AccessibilityNodeInfo accessibilityNodeInfo = newShadow.traversalBefore = shadowInfo.traversalBefore == null ? null : ShadowAccessibilityNodeInfo.obtain(shadowInfo.traversalBefore);
        if (shadowInfo.accessibilityWindowInfo != null) {
            newShadow.accessibilityWindowInfo = ShadowAccessibilityWindowInfo.obtain(shadowInfo.accessibilityWindowInfo);
        }
        ++sAllocationCount;
        if (shadowInfo.mOriginNodeId == 0L) {
            shadowInfo.mOriginNodeId = sAllocationCount;
        }
        return newInfo;
    }

    @Implementation
    protected static AccessibilityNodeInfo obtain(View view) {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return ((AccessibilityNodeInfoReflector)Reflector.reflector(AccessibilityNodeInfoReflector.class)).obtain(view);
        }
        AccessibilityNodeInfo obtainedInstance = (AccessibilityNodeInfo)ReflectionHelpers.callConstructor(AccessibilityNodeInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        obtainedInstance.setSource(view);
        ShadowAccessibilityNodeInfo.initShadow(obtainedInstance);
        return obtainedInstance;
    }

    @Implementation
    protected static AccessibilityNodeInfo obtain(View root, int virtualDescendantId) {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return ((AccessibilityNodeInfoReflector)Reflector.reflector(AccessibilityNodeInfoReflector.class)).obtain(root, virtualDescendantId);
        }
        AccessibilityNodeInfo obtainedInstance = (AccessibilityNodeInfo)ReflectionHelpers.callConstructor(AccessibilityNodeInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        obtainedInstance.setSource(root, virtualDescendantId);
        ShadowAccessibilityNodeInfo.initShadow(obtainedInstance);
        return obtainedInstance;
    }

    @Implementation
    protected static AccessibilityNodeInfo obtain() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return ((AccessibilityNodeInfoReflector)Reflector.reflector(AccessibilityNodeInfoReflector.class)).obtain();
        }
        AccessibilityNodeInfo obtainedInstance = (AccessibilityNodeInfo)ReflectionHelpers.callConstructor(AccessibilityNodeInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowAccessibilityNodeInfo.initShadow(obtainedInstance);
        ShadowAccessibilityNodeInfo shadowObtained = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)obtainedInstance);
        shadowObtained.view = new View(RuntimeEnvironment.getApplication().getApplicationContext());
        return obtainedInstance;
    }

    private static void initShadow(AccessibilityNodeInfo obtainedInstance) {
        ShadowAccessibilityNodeInfo shadowObtained = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)obtainedInstance);
        shadowObtained.performedActionAndArgsList = new ArrayList<Pair<Integer, Bundle>>();
        ++sAllocationCount;
        if (shadowObtained.mOriginNodeId == 0L) {
            shadowObtained.mOriginNodeId = sAllocationCount;
        }
    }

    @Resetter
    public static void resetObtainedInstances() {
        queryFromAppProcessWasEnabled = false;
    }

    @Implementation
    protected void recycle() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            this.accessibilityNodeInfoReflector.recycle();
            return;
        }
        if (this.labelFor != null) {
            this.labelFor.recycle();
        }
        if (this.labeledBy != null) {
            this.labeledBy.recycle();
        }
        if (this.traversalAfter != null) {
            this.traversalAfter.recycle();
        }
        if (this.traversalBefore != null) {
            this.traversalBefore.recycle();
        }
    }

    @Implementation
    protected int getChildCount() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.getChildCount();
        }
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Implementation
    protected AccessibilityNodeInfo getChild(int index) {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.getChild(index);
        }
        if (this.children == null) {
            return null;
        }
        AccessibilityNodeInfo child = this.children.get(index);
        if (child == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(child);
    }

    @Implementation
    protected AccessibilityNodeInfo getParent() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.getParent();
        }
        if (this.parent == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.parent);
    }

    @Implementation
    protected boolean refresh() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.refresh();
        }
        return this.refreshReturnValue;
    }

    public void setRefreshReturnValue(boolean refreshReturnValue) {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        this.refreshReturnValue = refreshReturnValue;
    }

    @Implementation
    protected void setText(CharSequence t) {
        this.accessibilityNodeInfoReflector.setText(t);
        if (!ShadowAccessibilityNodeInfo.useRealAni()) {
            this.text = t;
        }
    }

    @Implementation
    protected CharSequence getText() {
        if (ShadowAccessibilityNodeInfo.useRealAni() || this.text == null) {
            return this.accessibilityNodeInfoReflector.getText();
        }
        return this.text;
    }

    @Implementation
    protected AccessibilityNodeInfo getLabelFor() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.getLabelFor();
        }
        if (this.labelFor == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.labelFor);
    }

    public void setLabelFor(AccessibilityNodeInfo info) {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        if (this.labelFor != null) {
            this.labelFor.recycle();
        }
        this.labelFor = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation
    protected AccessibilityNodeInfo getLabeledBy() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.getLabeledBy();
        }
        if (this.labeledBy == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.labeledBy);
    }

    public void setLabeledBy(AccessibilityNodeInfo info) {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        if (this.labeledBy != null) {
            this.labeledBy.recycle();
        }
        this.labeledBy = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation
    protected AccessibilityNodeInfo getTraversalAfter() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.getTraversalAfter();
        }
        if (this.traversalAfter == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.traversalAfter);
    }

    @Implementation
    protected void setTraversalAfter(View view, int virtualDescendantId) {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            this.accessibilityNodeInfoReflector.setTraversalAfter(view, virtualDescendantId);
            return;
        }
        if (this.traversalAfter != null) {
            this.traversalAfter.recycle();
        }
        this.traversalAfter = ShadowAccessibilityNodeInfo.obtain(view);
    }

    public void setTraversalAfter(AccessibilityNodeInfo info) {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        if (this.traversalAfter != null) {
            this.traversalAfter.recycle();
        }
        this.traversalAfter = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation
    protected AccessibilityNodeInfo getTraversalBefore() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.getTraversalBefore();
        }
        if (this.traversalBefore == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.traversalBefore);
    }

    @Implementation
    protected void setTraversalBefore(View info, int virtualDescendantId) {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            this.accessibilityNodeInfoReflector.setTraversalBefore(info, virtualDescendantId);
            return;
        }
        if (this.traversalBefore != null) {
            this.traversalBefore.recycle();
        }
        this.traversalBefore = ShadowAccessibilityNodeInfo.obtain(info);
    }

    public void setTraversalBefore(AccessibilityNodeInfo info) {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        if (this.traversalBefore != null) {
            this.traversalBefore.recycle();
        }
        this.traversalBefore = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation
    protected void setSource(View source) {
        this.accessibilityNodeInfoReflector.setSource(source);
        if (!ShadowAccessibilityNodeInfo.useRealAni()) {
            this.view = source;
        }
    }

    @Implementation
    protected void setSource(View root, int virtualDescendantId) {
        this.accessibilityNodeInfoReflector.setSource(root, virtualDescendantId);
        if (!ShadowAccessibilityNodeInfo.useRealAni()) {
            this.view = root;
        }
    }

    @Implementation
    protected AccessibilityWindowInfo getWindow() {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.getWindow();
        }
        return this.accessibilityWindowInfo;
    }

    @Implementation
    protected int getWindowId() {
        if (ShadowAccessibilityNodeInfo.useRealAni() || this.accessibilityWindowInfo == null) {
            return this.accessibilityNodeInfoReflector.getWindowId();
        }
        return this.accessibilityWindowInfo.getId();
    }

    public void setAccessibilityWindowInfo(AccessibilityWindowInfo info) {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        this.accessibilityWindowInfo = info;
    }

    @Implementation
    protected boolean performAction(int action) {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.performAction(action);
        }
        return this.performAction(action, null);
    }

    @Implementation
    protected boolean performAction(int action, Bundle arguments) {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.performAction(action, arguments);
        }
        if (this.performedActionAndArgsList == null) {
            this.performedActionAndArgsList = new ArrayList<Pair<Integer, Bundle>>();
        }
        this.performedActionAndArgsList.add((Pair<Integer, Bundle>)new Pair((Object)action, (Object)arguments));
        return this.actionListener == null || this.actionListener.onPerformAccessibilityAction(action, arguments);
    }

    @Implementation
    public boolean equals(Object object) {
        if (ShadowAccessibilityNodeInfo.useRealAni()) {
            return this.accessibilityNodeInfoReflector.equals(object);
        }
        if (!(object instanceof AccessibilityNodeInfo)) {
            return false;
        }
        AccessibilityNodeInfo info = (AccessibilityNodeInfo)object;
        ShadowAccessibilityNodeInfo otherShadow = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)info);
        if (this.view != null) {
            return this.view == otherShadow.view;
        }
        if (this.mOriginNodeId != 0L) {
            return this.mOriginNodeId == otherShadow.mOriginNodeId;
        }
        throw new IllegalStateException("Node has neither an ID nor View");
    }

    public void addChild(AccessibilityNodeInfo child) {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        if (this.children == null) {
            this.children = new ArrayList<AccessibilityNodeInfo>();
        }
        this.children.add(child);
        ShadowAccessibilityNodeInfo shadowAccessibilityNodeInfo = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)child);
        shadowAccessibilityNodeInfo.parent = this.realAccessibilityNodeInfo;
    }

    @Implementation
    protected void addChild(View child) {
        this.accessibilityNodeInfoReflector.addChild(child);
        if (!ShadowAccessibilityNodeInfo.useRealAni()) {
            AccessibilityNodeInfo node = AccessibilityNodeInfo.obtain((View)child);
            this.addChild(node);
        }
    }

    @Implementation
    protected void addChild(View root, int virtualDescendantId) {
        this.accessibilityNodeInfoReflector.addChild(root, virtualDescendantId);
        if (!ShadowAccessibilityNodeInfo.useRealAni()) {
            AccessibilityNodeInfo node = AccessibilityNodeInfo.obtain((View)root, (int)virtualDescendantId);
            this.addChild(node);
        }
    }

    public List<Integer> getPerformedActions() {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        if (this.performedActionAndArgsList == null) {
            this.performedActionAndArgsList = new ArrayList<Pair<Integer, Bundle>>();
        }
        ArrayList<Integer> actionsOnly = new ArrayList<Integer>();
        for (Pair<Integer, Bundle> integerBundlePair : this.performedActionAndArgsList) {
            actionsOnly.add((Integer)integerBundlePair.first);
        }
        return Collections.unmodifiableList(actionsOnly);
    }

    public List<Pair<Integer, Bundle>> getPerformedActionsWithArgs() {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        if (this.performedActionAndArgsList == null) {
            this.performedActionAndArgsList = new ArrayList<Pair<Integer, Bundle>>();
        }
        return Collections.unmodifiableList(this.performedActionAndArgsList);
    }

    @Implementation(minSdk=34)
    protected void setQueryFromAppProcessEnabled(View view, boolean enabled) {
        this.accessibilityNodeInfoReflector.setQueryFromAppProcessEnabled(view, enabled);
        if (enabled) {
            queryFromAppProcessWasEnabled = true;
        }
    }

    public void setOnPerformActionListener(OnPerformActionListener listener) {
        ShadowAccessibilityNodeInfo.checkRealAniDisabled();
        this.actionListener = listener;
    }

    static boolean useRealAni() {
        return queryFromAppProcessWasEnabled || Boolean.parseBoolean(System.getProperty("robolectric.useRealAni", "false"));
    }

    static void checkRealAniDisabled() {
        Preconditions.checkState((!queryFromAppProcessWasEnabled ? 1 : 0) != 0, (Object)"This API is not supported after a call to AccessibilityNodeInfo#setQueryFromAppProcessEnabled.");
        boolean useRealAni = Boolean.parseBoolean(System.getProperty("robolectric.useRealAni", "false"));
        Preconditions.checkState((!useRealAni ? 1 : 0) != 0, (Object)"This API is not supported when 'robolectric.useRealAni' is true");
    }

    @ForType(value=AccessibilityNodeInfo.class)
    static interface AccessibilityNodeInfoReflector {
        @Direct
        @Static
        public AccessibilityNodeInfo obtain(AccessibilityNodeInfo var1);

        @Direct
        @Static
        public AccessibilityNodeInfo obtain(View var1);

        @Direct
        @Static
        public AccessibilityNodeInfo obtain();

        @Direct
        @Static
        public AccessibilityNodeInfo obtain(View var1, int var2);

        @Direct
        public void recycle();

        @Direct
        public int getChildCount();

        @Direct
        public AccessibilityNodeInfo getChild(int var1);

        @Direct
        public AccessibilityNodeInfo getParent();

        @Direct
        public boolean refresh();

        @Direct
        public void setText(CharSequence var1);

        @Direct
        public CharSequence getText();

        @Direct
        public AccessibilityNodeInfo getLabelFor();

        @Direct
        public AccessibilityNodeInfo getLabeledBy();

        @Direct
        public AccessibilityNodeInfo getTraversalAfter();

        @Direct
        public void setTraversalAfter(View var1, int var2);

        @Direct
        public AccessibilityNodeInfo getTraversalBefore();

        @Direct
        public void setTraversalBefore(View var1, int var2);

        @Direct
        public void setSource(View var1);

        @Direct
        public void setSource(View var1, int var2);

        @Direct
        public AccessibilityWindowInfo getWindow();

        @Direct
        public int getWindowId();

        @Direct
        public boolean performAction(int var1);

        @Direct
        public boolean performAction(int var1, Bundle var2);

        @Direct
        public boolean equals(Object var1);

        @Direct
        public int hashCode();

        @Direct
        public void addChild(View var1);

        @Direct
        public void addChild(View var1, int var2);

        @Direct
        public String toString();

        @Constructor
        public AccessibilityNodeInfo newInstance(AccessibilityNodeInfo var1);

        public void init(AccessibilityNodeInfo var1);

        @Direct
        public void setQueryFromAppProcessEnabled(View var1, boolean var2);
    }

    public static interface OnPerformActionListener {
        public boolean onPerformAccessibilityAction(int var1, Bundle var2);
    }
}

