/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.util.HashMap;
import java.util.Map;

final class BluetoothConnectionManager {
    private static volatile BluetoothConnectionManager instance;
    private final Map<String, BluetoothConnectionMetadata> remoteAddressConnectionMap = new HashMap<String, BluetoothConnectionMetadata>();

    private BluetoothConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static BluetoothConnectionManager getInstance() {
        if (instance != null) return instance;
        Class<BluetoothConnectionManager> clazz = BluetoothConnectionManager.class;
        synchronized (BluetoothConnectionManager.class) {
            if (instance != null) return instance;
            instance = new BluetoothConnectionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    void registerGattClientConnection(String remoteAddress) {
        if (!this.remoteAddressConnectionMap.containsKey(remoteAddress)) {
            this.remoteAddressConnectionMap.put(remoteAddress, new BluetoothConnectionMetadata());
        }
        this.remoteAddressConnectionMap.get(remoteAddress).setHasGattClientConnection(true);
    }

    void unregisterGattClientConnection(String remoteAddress) {
        if (this.remoteAddressConnectionMap.containsKey(remoteAddress)) {
            this.remoteAddressConnectionMap.get(remoteAddress).setHasGattClientConnection(false);
        }
    }

    void registerGattServerConnection(String remoteAddress) {
        if (!this.remoteAddressConnectionMap.containsKey(remoteAddress)) {
            this.remoteAddressConnectionMap.put(remoteAddress, new BluetoothConnectionMetadata());
        }
        this.remoteAddressConnectionMap.get(remoteAddress).setHasGattServerConnection(true);
    }

    void unregisterGattServerConnection(String remoteAddress) {
        if (this.remoteAddressConnectionMap.containsKey(remoteAddress)) {
            this.remoteAddressConnectionMap.get(remoteAddress).setHasGattServerConnection(false);
        }
    }

    boolean hasGattClientConnection(String remoteAddress) {
        return this.remoteAddressConnectionMap.containsKey(remoteAddress) && this.remoteAddressConnectionMap.get(remoteAddress).hasGattClientConnection();
    }

    boolean hasGattServerConnection(String remoteAddress) {
        return this.remoteAddressConnectionMap.containsKey(remoteAddress) && this.remoteAddressConnectionMap.get(remoteAddress).hasGattServerConnection();
    }

    boolean isConnected(String remoteAddress) {
        return this.remoteAddressConnectionMap.containsKey(remoteAddress) && this.remoteAddressConnectionMap.get(remoteAddress).isConnected();
    }

    void resetConnections() {
        this.remoteAddressConnectionMap.clear();
    }

    private static class BluetoothConnectionMetadata {
        boolean hasGattClientConnection = false;
        boolean hasGattServerConnection = false;

        private BluetoothConnectionMetadata() {
        }

        void setHasGattClientConnection(boolean hasGattClientConnection) {
            this.hasGattClientConnection = hasGattClientConnection;
        }

        void setHasGattServerConnection(boolean hasGattServerConnection) {
            this.hasGattServerConnection = hasGattServerConnection;
        }

        boolean hasGattClientConnection() {
            return this.hasGattClientConnection;
        }

        boolean hasGattServerConnection() {
            return this.hasGattServerConnection;
        }

        boolean isConnected() {
            return this.hasGattClientConnection || this.hasGattServerConnection;
        }
    }
}

