/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.companion.AssociatedDevice;
import android.companion.AssociationInfo;
import android.net.MacAddress;
import com.google.common.base.Preconditions;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

public class AssociationInfoBuilder {
    private int id;
    private int userId;
    private String packageName;
    private String tag;
    private String deviceMacAddress;
    private CharSequence displayName;
    private String deviceProfile;
    private Object associatedDevice;
    private boolean selfManaged;
    private boolean notifyOnDeviceNearby;
    private long approvedMs;
    private boolean revoked;
    private long lastTimeConnectedMs;
    private int systemDataSyncFlags;

    private AssociationInfoBuilder() {
    }

    public static AssociationInfoBuilder newBuilder() {
        return new AssociationInfoBuilder();
    }

    public AssociationInfoBuilder setId(int id2) {
        this.id = id2;
        return this;
    }

    public AssociationInfoBuilder setUserId(int userId) {
        this.userId = userId;
        return this;
    }

    public AssociationInfoBuilder setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public AssociationInfoBuilder setTag(String tag) {
        Preconditions.checkState((boolean)ReflectionHelpers.hasMethod(AssociationInfo.Builder.class, (String)"setTag", (Class[])new Class[]{String.class}), (Object)"tag was removed in post-V SDKs");
        this.tag = tag;
        return this;
    }

    public AssociationInfoBuilder setDeviceMacAddress(String deviceMacAddress) {
        this.deviceMacAddress = deviceMacAddress;
        return this;
    }

    public AssociationInfoBuilder setDisplayName(CharSequence displayName) {
        this.displayName = displayName;
        return this;
    }

    public AssociationInfoBuilder setDeviceProfile(String deviceProfile) {
        this.deviceProfile = deviceProfile;
        return this;
    }

    public AssociationInfoBuilder setAssociatedDevice(Object associatedDevice) {
        this.associatedDevice = associatedDevice;
        return this;
    }

    public AssociationInfoBuilder setSelfManaged(boolean selfManaged) {
        this.selfManaged = selfManaged;
        return this;
    }

    public AssociationInfoBuilder setNotifyOnDeviceNearby(boolean notifyOnDeviceNearby) {
        this.notifyOnDeviceNearby = notifyOnDeviceNearby;
        return this;
    }

    public AssociationInfoBuilder setApprovedMs(long approvedMs) {
        this.approvedMs = approvedMs;
        return this;
    }

    public AssociationInfoBuilder setRevoked(boolean revoked) {
        this.revoked = revoked;
        return this;
    }

    public AssociationInfoBuilder setLastTimeConnectedMs(long lastTimeConnectedMs) {
        this.lastTimeConnectedMs = lastTimeConnectedMs;
        return this;
    }

    public AssociationInfoBuilder setSystemDataSyncFlags(int systemDataSyncFlags) {
        this.systemDataSyncFlags = systemDataSyncFlags;
        return this;
    }

    public AssociationInfo build() {
        try {
            MacAddress macAddress;
            MacAddress macAddress2 = macAddress = this.deviceMacAddress == null ? null : MacAddress.fromString((String)this.deviceMacAddress);
            if (RuntimeEnvironment.getApiLevel() <= 33) {
                return (AssociationInfo)ReflectionHelpers.callConstructor(AssociationInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.id), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.userId), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.packageName), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)macAddress), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)this.displayName), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.deviceProfile), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.selfManaged), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.notifyOnDeviceNearby), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.approvedMs), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.lastTimeConnectedMs)});
            }
            if (RuntimeEnvironment.getApiLevel() == 34) {
                return (AssociationInfo)ReflectionHelpers.callConstructor(AssociationInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.id), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.userId), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.packageName), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)macAddress), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)this.displayName), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.deviceProfile), ReflectionHelpers.ClassParameter.from(Class.forName("android.companion.AssociatedDevice"), (Object)this.associatedDevice), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.selfManaged), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.notifyOnDeviceNearby), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.revoked), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.approvedMs), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.lastTimeConnectedMs), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.systemDataSyncFlags)});
            }
            AssociationInfo.Builder builder = new AssociationInfo.Builder(this.id, this.userId, this.packageName).setDeviceMacAddress(macAddress).setDisplayName(this.displayName).setDeviceProfile(this.deviceProfile).setAssociatedDevice((AssociatedDevice)this.associatedDevice).setSelfManaged(this.selfManaged).setNotifyOnDeviceNearby(this.notifyOnDeviceNearby).setTimeApproved(this.approvedMs).setRevoked(this.revoked).setLastTimeConnected(this.lastTimeConnectedMs).setSystemDataSyncFlags(this.systemDataSyncFlags);
            if (this.tag != null) {
                ((BuilderReflector)Reflector.reflector(BuilderReflector.class, (Object)builder)).setTag(this.tag);
            }
            return builder.build();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @ForType(value=AssociationInfo.Builder.class)
    private static interface BuilderReflector {
        public void setTag(String var1);
    }
}

