/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.controller;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import com.google.common.base.Preconditions;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.LooperMode;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.util.ReflectionHelpers;

public abstract class ComponentController<C extends ComponentController<C, T>, T> {
    protected final C myself = this;
    protected T component;
    protected final ShadowLooper shadowMainLooper;
    protected Intent intent;
    protected boolean attached;

    public ComponentController(T component, Intent intent) {
        this(component);
        this.intent = intent;
    }

    public ComponentController(T component) {
        this.component = component;
        this.shadowMainLooper = (ShadowLooper)Shadow.extract((Object)Looper.getMainLooper());
    }

    public T get() {
        return this.component;
    }

    public abstract C create();

    public abstract C destroy();

    public Intent getIntent() {
        Intent intent;
        Intent intent2 = intent = this.intent == null ? new Intent((Context)RuntimeEnvironment.getApplication(), this.component.getClass()) : this.intent;
        if (intent.getComponent() == null) {
            intent.setClass((Context)RuntimeEnvironment.getApplication(), this.component.getClass());
        }
        return intent;
    }

    protected C invokeWhilePaused(String methodName, ReflectionHelpers.ClassParameter<?> ... classParameters) {
        return this.invokeWhilePaused(() -> ReflectionHelpers.callInstanceMethod(this.component, (String)methodName, (ReflectionHelpers.ClassParameter[])classParameters));
    }

    protected C invokeWhilePaused(Runnable runnable) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.PAUSED) {
            Preconditions.checkState((Looper.myLooper() == Looper.getMainLooper() ? 1 : 0) != 0, (Object)"Expecting to be on main thread!");
        }
        this.shadowMainLooper.runPaused(runnable);
        return this.myself;
    }
}

