/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ClipData;
import android.content.Context;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.InputEvent;
import android.view.MotionEvent;
import android.view.RemoteAnimationTarget;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManagerGlobal;
import android.window.BackMotionEvent;
import android.window.OnBackInvokedCallbackInfo;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.lang.reflect.Proxy;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowDisplay;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowUiAutomation;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=WindowManagerGlobal.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowWindowManagerGlobal {
    private static WindowSessionDelegate windowSessionDelegate = new WindowSessionDelegate();
    private static IWindowSession windowSession;

    @Resetter
    public static void reset() {
        ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setDefaultWindowManager(null);
        windowSessionDelegate = new WindowSessionDelegate();
        windowSession = null;
    }

    public static boolean getInTouchMode() {
        return windowSessionDelegate.getInTouchMode();
    }

    static void setInTouchMode(boolean inTouchMode) {
        windowSessionDelegate.setInTouchMode(inTouchMode);
    }

    public static ClipData getLastDragClipData() {
        return ShadowWindowManagerGlobal.windowSessionDelegate.lastDragClipData;
    }

    public static void clearLastDragClipData() {
        ShadowWindowManagerGlobal.windowSessionDelegate.lastDragClipData = null;
    }

    public static PredictiveBackGesture startPredictiveBackGesture(int edge) {
        return ShadowWindowManagerGlobal.startPredictiveBackGesture(edge, 0.5f);
    }

    public static PredictiveBackGesture startPredictiveBackGesture(int edge, float position) {
        Preconditions.checkArgument((position >= 0.0f && position <= 1.0f ? 1 : 0) != 0, (String)"Invalid position: %s.", (Object)Float.valueOf(position));
        Preconditions.checkState((windowSessionDelegate.currentPredictiveBackGesture == null ? 1 : 0) != 0, (Object)"Current predictive back gesture in progress.");
        if (windowSessionDelegate.onBackInvokedCallbackInfo == null || !windowSessionDelegate.onBackInvokedCallbackInfo.isAnimationCallback()) {
            return null;
        }
        try {
            ShadowLooper.idleMainLooper();
            int touchSlop = ViewConfiguration.get((Context)RuntimeEnvironment.getApplication()).getScaledTouchSlop();
            int displayWidth = ShadowDisplay.getDefaultDisplay().getWidth();
            float deltaX = (float)((edge == 0 ? 1 : -1) * touchSlop) / 2.0f;
            float downX = (float)(edge == 0 ? 0 : displayWidth) + deltaX;
            float downY = (float)ShadowDisplay.getDefaultDisplay().getHeight() * position;
            if (windowSessionDelegate.systemGestureExclusionRects != null) {
                for (Rect rect : windowSessionDelegate.systemGestureExclusionRects) {
                    if (!rect.contains(Math.round(downX), Math.round(downY))) continue;
                    return null;
                }
            }
            MotionEvent downEvent = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)0, (float)downX, (float)downY, (int)0);
            MotionEvent moveEvent = MotionEvent.obtain((MotionEvent)downEvent);
            moveEvent.setAction(2);
            moveEvent.offsetLocation(deltaX, 0.0f);
            MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)moveEvent);
            cancelEvent.setAction(3);
            ShadowUiAutomation.injectInputEvent((InputEvent)downEvent);
            ShadowUiAutomation.injectInputEvent((InputEvent)moveEvent);
            ShadowUiAutomation.injectInputEvent((InputEvent)cancelEvent);
            windowSessionDelegate.onBackInvokedCallbackInfo.getCallback().onBackStarted(BackMotionEvents.newBackMotionEvent(edge, downX + 2.0f * deltaX, downY, 0.0f));
            ShadowLooper.idleMainLooper();
            PredictiveBackGesture backGesture = new PredictiveBackGesture(edge, displayWidth, downX + 2.0f * deltaX, downY);
            windowSessionDelegate.currentPredictiveBackGesture = backGesture;
            return backGesture;
        }
        catch (RemoteException e) {
            Log.e((String)"ShadowWindowManagerGlobal", (String)"Failed to start back gesture", (Throwable)e);
            return null;
        }
    }

    @Implementation
    protected static synchronized IWindowSession getWindowSession() {
        if (windowSession == null) {
            windowSession = (IWindowSession)Proxy.newProxyInstance(IWindowSession.class.getClassLoader(), new Class[]{IWindowSession.class}, (proxy, method, args) -> {
                String methodName;
                switch (methodName = method.getName()) {
                    case "add": 
                    case "addToDisplay": 
                    case "addToDisplayAsUser": {
                        return windowSessionDelegate.getAddFlags();
                    }
                    case "getInTouchMode": {
                        return windowSessionDelegate.getInTouchMode();
                    }
                    case "performDrag": {
                        return windowSessionDelegate.performDrag(args);
                    }
                    case "prepareDrag": {
                        return windowSessionDelegate.prepareDrag();
                    }
                    case "setInTouchMode": {
                        windowSessionDelegate.setInTouchMode((Boolean)args[0]);
                        return null;
                    }
                    case "setOnBackInvokedCallbackInfo": {
                        windowSessionDelegate.onBackInvokedCallbackInfo = (OnBackInvokedCallbackInfo)args[1];
                        return null;
                    }
                    case "reportSystemGestureExclusionChanged": {
                        windowSessionDelegate.systemGestureExclusionRects = (List)args[1];
                        return null;
                    }
                }
                return ReflectionHelpers.defaultValueForType((String)method.getReturnType().getName());
            });
        }
        return windowSession;
    }

    @Implementation
    protected static synchronized IWindowSession peekWindowSession() {
        return windowSession;
    }

    @Implementation
    public static Object getWindowManagerService() throws RemoteException {
        IWindowManager service = ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).getWindowManagerService();
        if (service == null) {
            service = IWindowManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"window"));
            ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setWindowManagerService(service);
        }
        return service;
    }

    private static class WindowSessionDelegate {
        static final int ADD_FLAG_IN_TOUCH_MODE = 1;
        static final int ADD_FLAG_APP_VISIBLE = 2;
        private boolean inTouchMode = ShadowView.useRealGraphics();
        protected ClipData lastDragClipData;
        private OnBackInvokedCallbackInfo onBackInvokedCallbackInfo;
        private List<Rect> systemGestureExclusionRects;
        private PredictiveBackGesture currentPredictiveBackGesture;

        private WindowSessionDelegate() {
        }

        protected int getAddFlags() {
            int res = 0;
            if (ShadowView.useRealGraphics() || "true".equals(System.getProperty("robolectric.areWindowsMarkedVisible", "false"))) {
                res |= 2;
            }
            if (this.getInTouchMode()) {
                res |= 1;
            }
            return res;
        }

        public boolean getInTouchMode() {
            return this.inTouchMode;
        }

        public void setInTouchMode(boolean inTouchMode) {
            this.inTouchMode = inTouchMode;
        }

        public IBinder prepareDrag() {
            return new Binder();
        }

        public Object performDrag(Object[] args) {
            for (int i = args.length - 1; i >= 0; --i) {
                if (!(args[i] instanceof ClipData)) continue;
                this.lastDragClipData = (ClipData)args[i];
                return RuntimeEnvironment.getApiLevel() >= 28 ? new Binder() : Boolean.valueOf(true);
            }
            throw new AssertionError((Object)"Missing ClipData param");
        }
    }

    @ForType(value=WindowManagerGlobal.class)
    static interface WindowManagerGlobalReflector {
        @Accessor(value="sDefaultWindowManager")
        @Static
        public void setDefaultWindowManager(WindowManagerGlobal var1);

        @Static
        @Accessor(value="sWindowManagerService")
        public IWindowManager getWindowManagerService();

        @Static
        @Accessor(value="sWindowManagerService")
        public void setWindowManagerService(IWindowManager var1);

        @Accessor(value="mViews")
        public List<View> getWindowViews();
    }

    public static final class PredictiveBackGesture
    implements Closeable {
        private final int edge;
        private final int displayWidth;
        private final float startTouchX;
        private final float progressThreshold;
        private float touchX;
        private float touchY;
        private boolean isCancelled;
        private boolean isFinished;

        private PredictiveBackGesture(int edge, int displayWidth, float touchX, float touchY) {
            this.edge = edge;
            this.displayWidth = displayWidth;
            this.progressThreshold = ViewConfiguration.get((Context)RuntimeEnvironment.getApplication()).getScaledTouchSlop();
            this.startTouchX = touchX;
            this.touchX = touchX;
            this.touchY = touchY;
        }

        public void moveBy(float dx, float dy) {
            Preconditions.checkState((!this.isCancelled && !this.isFinished ? 1 : 0) != 0);
            try {
                this.touchX += dx;
                this.touchY += dy;
                windowSessionDelegate.onBackInvokedCallbackInfo.getCallback().onBackProgressed(BackMotionEvents.newBackMotionEvent(this.edge, this.touchX, this.touchY, this.caclulateProgress()));
                ShadowLooper.idleMainLooper();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void cancel() {
            Preconditions.checkState((!this.isCancelled && !this.isFinished ? 1 : 0) != 0);
            this.isCancelled = true;
            try {
                windowSessionDelegate.onBackInvokedCallbackInfo.getCallback().onBackCancelled();
                windowSessionDelegate.currentPredictiveBackGesture = null;
                ShadowLooper.idleMainLooper();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            Preconditions.checkState((!this.isFinished ? 1 : 0) != 0);
            this.isFinished = true;
            if (!this.isCancelled) {
                try {
                    windowSessionDelegate.onBackInvokedCallbackInfo.getCallback().onBackInvoked();
                    windowSessionDelegate.currentPredictiveBackGesture = null;
                    ShadowLooper.idleMainLooper();
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private float caclulateProgress() {
            int direction = this.edge == 0 ? 1 : -1;
            float draggableWidth = (this.edge == 0 ? (float)this.displayWidth - this.startTouchX : this.startTouchX) - this.progressThreshold;
            return Math.max(((this.touchX - this.startTouchX) * (float)direction - this.progressThreshold) / draggableWidth, 0.0f);
        }
    }

    private static class BackMotionEvents {
        private BackMotionEvents() {
        }

        static BackMotionEvent newBackMotionEvent(int edge, float touchX, float touchY, float progress) {
            block4: {
                if (RuntimeEnvironment.getApiLevel() >= 34) {
                    try {
                        return ((BackMotionEventReflector)Reflector.reflector(BackMotionEventReflector.class)).newBackMotionEventV(touchX, touchY, progress, 0.0f, 0.0f, Boolean.FALSE, edge, null);
                    }
                    catch (Throwable t) {
                        if (NoSuchMethodException.class.isInstance(t) || AssertionError.class.isInstance(t)) break block4;
                        if (RuntimeException.class.isInstance(t)) {
                            throw (RuntimeException)t;
                        }
                        throw new RuntimeException(t);
                    }
                }
            }
            return ((BackMotionEventReflector)Reflector.reflector(BackMotionEventReflector.class)).newBackMotionEvent(touchX, touchY, progress, 0.0f, 0.0f, edge, null);
        }
    }

    @ForType(value=BackMotionEvent.class)
    static interface BackMotionEventReflector {
        @Constructor
        public BackMotionEvent newBackMotionEvent(float var1, float var2, float var3, float var4, float var5, int var6, RemoteAnimationTarget var7);

        @Constructor
        public BackMotionEvent newBackMotionEventV(float var1, float var2, float var3, float var4, float var5, boolean var6, int var7, RemoteAnimationTarget var8);
    }
}

