/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.safetycenter.SafetyCenterManager;
import android.safetycenter.SafetyEvent;
import android.safetycenter.SafetySourceData;
import android.safetycenter.SafetySourceErrorDetails;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=SafetyCenterManager.class, minSdk=33, isInAndroidSdk=false)
public class ShadowSafetyCenterManager {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Map<String, SafetySourceData> dataById = new HashMap<String, SafetySourceData>();
    @GuardedBy(value="lock")
    private final Map<String, SafetyEvent> eventsById = new HashMap<String, SafetyEvent>();
    @GuardedBy(value="lock")
    private final Map<String, SafetySourceErrorDetails> errorsById = new HashMap<String, SafetySourceErrorDetails>();
    @GuardedBy(value="lock")
    private final Set<String> throwForId = new HashSet<String>();
    @GuardedBy(value="lock")
    private boolean enabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean isSafetyCenterEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void setSafetySourceData(String safetySourceId, SafetySourceData safetySourceData, SafetyEvent safetyEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isSafetyCenterEnabled()) {
                return;
            }
            this.maybeThrowForId(safetySourceId);
            this.dataById.put(safetySourceId, safetySourceData);
            this.eventsById.put(safetySourceId, safetyEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected SafetySourceData getSafetySourceData(String safetySourceId) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isSafetyCenterEnabled()) {
                return null;
            }
            this.maybeThrowForId(safetySourceId);
            return this.dataById.get(safetySourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void reportSafetySourceError(String safetySourceId, SafetySourceErrorDetails safetySourceErrorDetails) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isSafetyCenterEnabled()) {
                return;
            }
            this.maybeThrowForId(safetySourceId);
            this.errorsById.put(safetySourceId, safetySourceErrorDetails);
        }
    }

    @GuardedBy(value="lock")
    private void maybeThrowForId(String safetySourceId) {
        if (this.throwForId.contains(safetySourceId)) {
            throw new IllegalArgumentException(String.format("%s is invalid", safetySourceId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSafetyCenterEnabled(boolean enabled) {
        Object object = this.lock;
        synchronized (object) {
            this.enabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwOnSafetySourceId(String safetySourceId) {
        Object object = this.lock;
        synchronized (object) {
            this.throwForId.add(safetySourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SafetyEvent getLastSafetyEvent(String safetySourceId) {
        Object object = this.lock;
        synchronized (object) {
            return this.eventsById.get(safetySourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SafetySourceErrorDetails getLastSafetySourceError(String safetySourceId) {
        Object object = this.lock;
        synchronized (object) {
            return this.errorsById.get(safetySourceId);
        }
    }
}

