/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import android.view.Choreographer;
import android.view.DisplayEventReceiver;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowChoreographer;
import org.robolectric.shadows.ShadowDisplayEventReceiver;
import org.robolectric.shadows.ShadowPausedLooper;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Choreographer.class, shadowPicker=ShadowChoreographer.Picker.class, isInAndroidSdk=false)
public class ShadowPausedChoreographer
extends ShadowChoreographer {
    private static final Set<Looper> choreographedLoopers = new CopyOnWriteArraySet<Looper>();
    @RealObject
    private Choreographer realChoreographer;

    @Implementation(maxSdk=25)
    protected void __constructor__(Looper looper) {
        ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class, (Object)this.realChoreographer)).__constructor__(looper);
        choreographedLoopers.add(looper);
    }

    @Implementation(minSdk=26, maxSdk=33)
    protected void __constructor__(Looper looper, int vsyncSource) {
        ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class, (Object)this.realChoreographer)).__constructor__(looper, vsyncSource);
        choreographedLoopers.add(looper);
    }

    @Implementation(minSdk=34)
    protected void __constructor__(Looper looper, int vsyncSource, long layerHandle) {
        ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class, (Object)this.realChoreographer)).__constructor__(looper, vsyncSource, layerHandle);
        choreographedLoopers.add(looper);
    }

    static void reset(Looper looper) {
        if (choreographedLoopers.remove(looper)) {
            if (looper.getThread() == Thread.currentThread()) {
                ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class)).getThreadInstance().remove();
            } else if (looper.getThread().isAlive()) {
                ShadowPausedLooper shadowLooper = (ShadowPausedLooper)Shadow.extract((Object)looper);
                shadowLooper.postSyncQuiet(() -> ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class)).getThreadInstance().remove());
            }
        }
    }

    static void clearLoopers() {
        choreographedLoopers.clear();
    }

    @VisibleForTesting
    boolean isInitialized() {
        DisplayEventReceiver receiver = ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class, (Object)this.realObject)).getReceiver();
        return ((ShadowDisplayEventReceiver.DisplayEventReceiverReflector)Reflector.reflector(ShadowDisplayEventReceiver.DisplayEventReceiverReflector.class, (Object)receiver)).getReceiverPtr() != 0L;
    }
}

