/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Paint;
import android.graphics.Rect;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.PaintNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowNativeTypeface;
import org.robolectric.shadows.ShadowPaint;

@Implements(minSdk=26, value=Paint.class, looseSignatures=true, shadowPicker=Picker.class, isInAndroidSdk=false, callNativeMethodsByDefault=true)
public class ShadowNativePaint {
    private PaintNatives paintNatives = new PaintNatives();
    private static final int ELEGANT_TEXT_HEIGHT_ENABLED = 0;
    private static final int ELEGANT_TEXT_HEIGHT_DISABLED = 1;

    @Implementation(minSdk=26, maxSdk=34)
    protected static long nGetNativeFinalizer() {
        return PaintNatives.nGetNativeFinalizer();
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static long nInit() {
        DefaultNativeRuntimeLoader.injectAndLoad();
        ShadowNativeTypeface.ensureInitialized();
        return PaintNatives.nInit();
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static int nGetHyphenEdit(long paintPtr) {
        return PaintNatives.nGetEndHyphenEdit((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static void nSetHyphenEdit(long paintPtr, int hyphen) {
        PaintNatives.nSetStartHyphenEdit((long)paintPtr, (int)0);
        PaintNatives.nSetEndHyphenEdit((long)paintPtr, (int)hyphen);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static long nInitWithPaint(long paint) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return PaintNatives.nInitWithPaint((long)paint);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static int nBreakText(long nObject, char[] text, int index, int count, float maxWidth, int bidiFlags, float[] measuredWidth) {
        return PaintNatives.nBreakText((long)nObject, (char[])text, (int)index, (int)count, (float)maxWidth, (int)bidiFlags, (float[])measuredWidth);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static int nBreakText(long nObject, String text, boolean measureForwards, float maxWidth, int bidiFlags, float[] measuredWidth) {
        return PaintNatives.nBreakText((long)nObject, (String)text, (boolean)measureForwards, (float)maxWidth, (int)bidiFlags, (float[])measuredWidth);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static int nBreakText(long nObject, long typefacePtr, char[] text, int index, int count, float maxWidth, int bidiFlags, float[] measuredWidth) {
        return PaintNatives.nBreakText((long)nObject, (long)typefacePtr, (char[])text, (int)index, (int)count, (float)maxWidth, (int)bidiFlags, (float[])measuredWidth);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static int nBreakText(long nObject, long typefacePtr, String text, boolean measureForwards, float maxWidth, int bidiFlags, float[] measuredWidth) {
        return PaintNatives.nBreakText((long)nObject, (long)typefacePtr, (String)text, (boolean)measureForwards, (float)maxWidth, (int)bidiFlags, (float[])measuredWidth);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static float nGetTextAdvances(long paintPtr, char[] text, int index, int count, int contextIndex, int contextCount, int bidiFlags, float[] advances, int advancesIndex) {
        return PaintNatives.nGetTextAdvances((long)paintPtr, (char[])text, (int)index, (int)count, (int)contextIndex, (int)contextCount, (int)bidiFlags, (float[])advances, (int)advancesIndex);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static float nGetTextAdvances(long paintPtr, String text, int start, int end, int contextStart, int contextEnd, int bidiFlags, float[] advances, int advancesIndex) {
        return PaintNatives.nGetTextAdvances((long)paintPtr, (String)text, (int)start, (int)end, (int)contextStart, (int)contextEnd, (int)bidiFlags, (float[])advances, (int)advancesIndex);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static float nGetTextAdvances(long paintPtr, long typefacePtr, char[] text, int index, int count, int contextIndex, int contextCount, int bidiFlags, float[] advances, int advancesIndex) {
        return PaintNatives.nGetTextAdvances((long)paintPtr, (long)typefacePtr, (char[])text, (int)index, (int)count, (int)contextIndex, (int)contextCount, (int)bidiFlags, (float[])advances, (int)advancesIndex);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static float nGetTextAdvances(long paintPtr, long typefacePtr, String text, int index, int count, int contextIndex, int contextCount, int bidiFlags, float[] advances, int advancesIndex) {
        return PaintNatives.nGetTextAdvances((long)paintPtr, (long)typefacePtr, (String)text, (int)index, (int)count, (int)contextIndex, (int)contextCount, (int)bidiFlags, (float[])advances, (int)advancesIndex);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected int nGetTextRunCursor(long paintPtr, char[] text, int contextStart, int contextLength, int dir, int offset, int cursorOpt) {
        return this.paintNatives.nGetTextRunCursor(paintPtr, text, contextStart, contextLength, dir, offset, cursorOpt);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected int nGetTextRunCursor(long paintPtr, String text, int contextStart, int contextEnd, int dir, int offset, int cursorOpt) {
        return this.paintNatives.nGetTextRunCursor(paintPtr, text, contextStart, contextEnd, dir, offset, cursorOpt);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected int nGetTextRunCursor(long paintPtr, long typefacePtr, char[] text, int contextStart, int contextLength, int dir, int offset, int cursorOpt) {
        return this.paintNatives.nGetTextRunCursor(paintPtr, typefacePtr, text, contextStart, contextLength, dir, offset, cursorOpt);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected int nGetTextRunCursor(long paintPtr, long typefacePtr, String text, int contextStart, int contextEnd, int dir, int offset, int cursorOpt) {
        return this.paintNatives.nGetTextRunCursor(paintPtr, typefacePtr, text, contextStart, contextEnd, dir, offset, cursorOpt);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static void nGetTextPath(long paintPtr, int bidiFlags, char[] text, int index, int count, float x, float y, long path) {
        PaintNatives.nGetTextPath((long)paintPtr, (int)bidiFlags, (char[])text, (int)index, (int)count, (float)x, (float)y, (long)path);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static void nGetTextPath(long paintPtr, int bidiFlags, String text, int start, int end, float x, float y, long path) {
        PaintNatives.nGetTextPath((long)paintPtr, (int)bidiFlags, (String)text, (int)start, (int)end, (float)x, (float)y, (long)path);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nGetTextPath(long paintPtr, long typefacePtr, int bidiFlags, char[] text, int index, int count, float x, float y, long path) {
        PaintNatives.nGetTextPath((long)paintPtr, (long)typefacePtr, (int)bidiFlags, (char[])text, (int)index, (int)count, (float)x, (float)y, (long)path);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nGetTextPath(long paintPtr, long typefacePtr, int bidiFlags, String text, int start, int end, float x, float y, long path) {
        PaintNatives.nGetTextPath((long)paintPtr, (long)typefacePtr, (int)bidiFlags, (String)text, (int)start, (int)end, (float)x, (float)y, (long)path);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static void nGetStringBounds(long nativePaint, String text, int start, int end, int bidiFlags, Rect bounds) {
        PaintNatives.nGetStringBounds((long)nativePaint, (String)text, (int)start, (int)end, (int)bidiFlags, (Rect)bounds);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nGetStringBounds(long nativePaint, long typefacePtr, String text, int start, int end, int bidiFlags, Rect bounds) {
        PaintNatives.nGetStringBounds((long)nativePaint, (long)typefacePtr, (String)text, (int)start, (int)end, (int)bidiFlags, (Rect)bounds);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static int nGetColor(long paintPtr) {
        return PaintNatives.nGetColor((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static int nGetAlpha(long paintPtr) {
        return PaintNatives.nGetAlpha((long)paintPtr);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static void nGetCharArrayBounds(long nativePaint, char[] text, int index, int count, int bidiFlags, Rect bounds) {
        PaintNatives.nGetCharArrayBounds((long)nativePaint, (char[])text, (int)index, (int)count, (int)bidiFlags, (Rect)bounds);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nGetCharArrayBounds(long nativePaint, long typefacePtr, char[] text, int index, int count, int bidiFlags, Rect bounds) {
        PaintNatives.nGetCharArrayBounds((long)nativePaint, (long)typefacePtr, (char[])text, (int)index, (int)count, (int)bidiFlags, (Rect)bounds);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static boolean nHasGlyph(long paintPtr, int bidiFlags, String string) {
        return PaintNatives.nHasGlyph((long)paintPtr, (int)bidiFlags, (String)string);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static boolean nHasGlyph(long paintPtr, long typefacePtr, int bidiFlags, String string) {
        return PaintNatives.nHasGlyph((long)paintPtr, (long)typefacePtr, (int)bidiFlags, (String)string);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static float nGetRunAdvance(long paintPtr, char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        return PaintNatives.nGetRunAdvance((long)paintPtr, (char[])text, (int)start, (int)end, (int)contextStart, (int)contextEnd, (boolean)isRtl, (int)offset);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static float nGetRunAdvance(long paintPtr, long typefacePtr, char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        return PaintNatives.nGetRunAdvance((long)paintPtr, (char[])text, (int)start, (int)end, (int)contextStart, (int)contextEnd, (boolean)isRtl, (int)offset);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static int nGetOffsetForAdvance(long paintPtr, long typefacePtr, char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float advance) {
        return PaintNatives.nGetOffsetForAdvance((long)paintPtr, (long)typefacePtr, (char[])text, (int)start, (int)end, (int)contextStart, (int)contextEnd, (boolean)isRtl, (float)advance);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static int nGetOffsetForAdvance(long paintPtr, char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float advance) {
        return PaintNatives.nGetOffsetForAdvance((long)paintPtr, (char[])text, (int)start, (int)end, (int)contextStart, (int)contextEnd, (boolean)isRtl, (float)advance);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static int nSetTextLocales(long paintPtr, String locales) {
        return PaintNatives.nSetTextLocales((long)paintPtr, (String)locales);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetFontFeatureSettings(long paintPtr, String settings) {
        PaintNatives.nSetFontFeatureSettings((long)paintPtr, (String)settings);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static float nGetFontMetrics(long paintPtr, Paint.FontMetrics metrics) {
        return PaintNatives.nGetFontMetrics((long)paintPtr, (Paint.FontMetrics)metrics);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static float nGetFontMetrics(long paintPtr, long typefacePtr, Paint.FontMetrics metrics) {
        return PaintNatives.nGetFontMetrics((long)paintPtr, (long)typefacePtr, (Paint.FontMetrics)metrics);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static int nGetFontMetricsInt(long paintPtr, Paint.FontMetricsInt fmi) {
        return PaintNatives.nGetFontMetricsInt((long)paintPtr, (Paint.FontMetricsInt)fmi);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static int nGetFontMetricsInt(long paintPtr, long typefacePtr, Paint.FontMetricsInt fmi) {
        return PaintNatives.nGetFontMetricsInt((long)paintPtr, (long)typefacePtr, (Paint.FontMetricsInt)fmi);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nReset(long paintPtr) {
        PaintNatives.nReset((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSet(long paintPtrDest, long paintPtrSrc) {
        PaintNatives.nSet((long)paintPtrDest, (long)paintPtrSrc);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static int nGetStyle(long paintPtr) {
        return PaintNatives.nGetStyle((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetStyle(long paintPtr, int style) {
        PaintNatives.nSetStyle((long)paintPtr, (int)style);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static int nGetStrokeCap(long paintPtr) {
        return PaintNatives.nGetStrokeCap((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetStrokeCap(long paintPtr, int cap) {
        PaintNatives.nSetStrokeCap((long)paintPtr, (int)cap);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static int nGetStrokeJoin(long paintPtr) {
        return PaintNatives.nGetStrokeJoin((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetStrokeJoin(long paintPtr, int join) {
        PaintNatives.nSetStrokeJoin((long)paintPtr, (int)join);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nGetFillPath(long paintPtr, long src, long dst) {
        return PaintNatives.nGetFillPath((long)paintPtr, (long)src, (long)dst);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static long nSetShader(long paintPtr, long shader) {
        return PaintNatives.nSetShader((long)paintPtr, (long)shader);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static long nSetColorFilter(long paintPtr, long filter) {
        return PaintNatives.nSetColorFilter((long)paintPtr, (long)filter);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetXfermode(long paintPtr, int xfermode) {
        PaintNatives.nSetXfermode((long)paintPtr, (int)xfermode);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static long nSetPathEffect(long paintPtr, long effect) {
        return PaintNatives.nSetPathEffect((long)paintPtr, (long)effect);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static long nSetMaskFilter(long paintPtr, long maskfilter) {
        return PaintNatives.nSetMaskFilter((long)paintPtr, (long)maskfilter);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static void nSetTypeface(long paintPtr, long typeface) {
        PaintNatives.nSetTypeface((long)paintPtr, (long)typeface);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static Object nSetTypeface(Object paintPtr, Object typeface) {
        PaintNatives.nSetTypeface((long)((Long)paintPtr), (long)((Long)typeface));
        return paintPtr;
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static int nGetTextAlign(long paintPtr) {
        return PaintNatives.nGetTextAlign((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetTextAlign(long paintPtr, int align) {
        PaintNatives.nSetTextAlign((long)paintPtr, (int)align);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static void nSetTextLocalesByMinikinLocaleListId(long paintPtr, int mMinikinLocaleListId) {
        PaintNatives.nSetTextLocalesByMinikinLocaleListId((long)paintPtr, (int)mMinikinLocaleListId);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nSetShadowLayer(long paintPtr, float radius, float dx, float dy, long colorSpaceHandle, long shadowColor) {
        PaintNatives.nSetShadowLayer((long)paintPtr, (float)radius, (float)dx, (float)dy, (long)colorSpaceHandle, (long)shadowColor);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static void nSetShadowLayer(long paintPtr, float radius, float dx, float dy, int color) {
        PaintNatives.nSetShadowLayer((long)paintPtr, (float)radius, (float)dx, (float)dy, (int)color);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nHasShadowLayer(long paintPtr) {
        return PaintNatives.nHasShadowLayer((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static float nGetLetterSpacing(long paintPtr) {
        return PaintNatives.nGetLetterSpacing((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetLetterSpacing(long paintPtr, float letterSpacing) {
        PaintNatives.nSetLetterSpacing((long)paintPtr, (float)letterSpacing);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static float nGetWordSpacing(long paintPtr) {
        return PaintNatives.nGetWordSpacing((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetWordSpacing(long paintPtr, float wordSpacing) {
        PaintNatives.nSetWordSpacing((long)paintPtr, (float)wordSpacing);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static int nGetStartHyphenEdit(long paintPtr) {
        return PaintNatives.nGetStartHyphenEdit((long)paintPtr);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static int nGetEndHyphenEdit(long paintPtr) {
        return PaintNatives.nGetEndHyphenEdit((long)paintPtr);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nSetStartHyphenEdit(long paintPtr, int hyphen) {
        PaintNatives.nSetStartHyphenEdit((long)paintPtr, (int)hyphen);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nSetEndHyphenEdit(long paintPtr, int hyphen) {
        PaintNatives.nSetEndHyphenEdit((long)paintPtr, (int)hyphen);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetStrokeMiter(long paintPtr, float miter) {
        PaintNatives.nSetStrokeMiter((long)paintPtr, (float)miter);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static float nGetStrokeMiter(long paintPtr) {
        return PaintNatives.nGetStrokeMiter((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetStrokeWidth(long paintPtr, float width) {
        PaintNatives.nSetStrokeWidth((long)paintPtr, (float)width);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static float nGetStrokeWidth(long paintPtr) {
        return PaintNatives.nGetStrokeWidth((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetAlpha(long paintPtr, int a) {
        PaintNatives.nSetAlpha((long)paintPtr, (int)a);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetDither(long paintPtr, boolean dither) {
        PaintNatives.nSetDither((long)paintPtr, (boolean)dither);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static int nGetFlags(long paintPtr) {
        return PaintNatives.nGetFlags((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetFlags(long paintPtr, int flags) {
        PaintNatives.nSetFlags((long)paintPtr, (int)flags);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static int nGetHinting(long paintPtr) {
        return PaintNatives.nGetHinting((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetHinting(long paintPtr, int mode) {
        PaintNatives.nSetHinting((long)paintPtr, (int)mode);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetAntiAlias(long paintPtr, boolean aa) {
        PaintNatives.nSetAntiAlias((long)paintPtr, (boolean)aa);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetLinearText(long paintPtr, boolean linearText) {
        PaintNatives.nSetLinearText((long)paintPtr, (boolean)linearText);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetSubpixelText(long paintPtr, boolean subpixelText) {
        PaintNatives.nSetSubpixelText((long)paintPtr, (boolean)subpixelText);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetUnderlineText(long paintPtr, boolean underlineText) {
        PaintNatives.nSetUnderlineText((long)paintPtr, (boolean)underlineText);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetFakeBoldText(long paintPtr, boolean fakeBoldText) {
        PaintNatives.nSetFakeBoldText((long)paintPtr, (boolean)fakeBoldText);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetFilterBitmap(long paintPtr, boolean filter) {
        PaintNatives.nSetFilterBitmap((long)paintPtr, (boolean)filter);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nSetColor(long paintPtr, long colorSpaceHandle, long color) {
        PaintNatives.nSetColor((long)paintPtr, (long)colorSpaceHandle, (long)color);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetColor(long paintPtr, int color) {
        PaintNatives.nSetColor((long)paintPtr, (int)color);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetStrikeThruText(long paintPtr, boolean strikeThruText) {
        PaintNatives.nSetStrikeThruText((long)paintPtr, (boolean)strikeThruText);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nIsElegantTextHeight(long paintPtr) {
        return PaintNatives.nIsElegantTextHeight((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetElegantTextHeight(long paintPtr, boolean elegant) {
        PaintNatives.nSetElegantTextHeight((long)paintPtr, (int)(elegant ? 0 : 1));
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static float nGetTextSize(long paintPtr) {
        return PaintNatives.nGetTextSize((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static float nGetTextScaleX(long paintPtr) {
        return PaintNatives.nGetTextScaleX((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetTextScaleX(long paintPtr, float scaleX) {
        PaintNatives.nSetTextScaleX((long)paintPtr, (float)scaleX);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static float nGetTextSkewX(long paintPtr) {
        return PaintNatives.nGetTextSkewX((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetTextSkewX(long paintPtr, float skewX) {
        PaintNatives.nSetTextSkewX((long)paintPtr, (float)skewX);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static float nAscent(long paintPtr) {
        return PaintNatives.nAscent((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static float nAscent(long paintPtr, long typefacePtr) {
        return PaintNatives.nAscent((long)paintPtr, (long)typefacePtr);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static float nDescent(long paintPtr) {
        return PaintNatives.nDescent((long)paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static float nDescent(long paintPtr, long typefacePtr) {
        return PaintNatives.nDescent((long)paintPtr, (long)typefacePtr);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static float nGetUnderlinePosition(long paintPtr) {
        return PaintNatives.nGetUnderlinePosition((long)paintPtr);
    }

    @Implementation(minSdk=27, maxSdk=27)
    protected static float nGetUnderlinePosition(long paintPtr, long typefacePtr) {
        return ShadowNativePaint.nGetUnderlinePosition(paintPtr);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static float nGetUnderlineThickness(long paintPtr) {
        return PaintNatives.nGetUnderlineThickness((long)paintPtr);
    }

    @Implementation(minSdk=27, maxSdk=27)
    protected static float nGetUnderlineThickness(long paintPtr, long typefacePtr) {
        return ShadowNativePaint.nGetUnderlineThickness(paintPtr);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static float nGetStrikeThruPosition(long paintPtr) {
        return PaintNatives.nGetStrikeThruPosition((long)paintPtr);
    }

    @Implementation(minSdk=27, maxSdk=27)
    protected static float nGetStrikeThruPosition(long paintPtr, long typefacePtr) {
        return ShadowNativePaint.nGetStrikeThruPosition(paintPtr);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static float nGetStrikeThruThickness(long paintPtr) {
        return PaintNatives.nGetStrikeThruThickness((long)paintPtr);
    }

    @Implementation(minSdk=27, maxSdk=27)
    protected static float nGetStrikeThruThickness(long paintPtr, long typefacePtr) {
        return ShadowNativePaint.nGetStrikeThruThickness(paintPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nSetTextSize(long paintPtr, float textSize) {
        PaintNatives.nSetTextSize((long)paintPtr, (float)textSize);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static boolean nEqualsForTextMeasurement(long leftPaintPtr, long rightPaintPtr) {
        return PaintNatives.nEqualsForTextMeasurement((long)leftPaintPtr, (long)rightPaintPtr);
    }

    @Implementation(minSdk=33, maxSdk=34)
    protected static void nGetFontMetricsIntForText(long paintPtr, char[] text, int start, int count, int ctxStart, int ctxCount, boolean isRtl, Paint.FontMetricsInt outMetrics) {
        PaintNatives.nGetFontMetricsIntForText((long)paintPtr, (char[])text, (int)start, (int)count, (int)ctxStart, (int)ctxCount, (boolean)isRtl, (Paint.FontMetricsInt)outMetrics);
    }

    @Implementation(minSdk=33, maxSdk=34)
    protected static void nGetFontMetricsIntForText(long paintPtr, String text, int start, int count, int ctxStart, int ctxCount, boolean isRtl, Paint.FontMetricsInt outMetrics) {
        PaintNatives.nGetFontMetricsIntForText((long)paintPtr, (String)text, (int)start, (int)count, (int)ctxStart, (int)ctxCount, (boolean)isRtl, (Paint.FontMetricsInt)outMetrics);
    }

    @Implementation(minSdk=34, maxSdk=34)
    protected static float nGetRunCharacterAdvance(long paintPtr, char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset, float[] advances, int advancesIndex) {
        return PaintNatives.nGetRunCharacterAdvance((long)paintPtr, (char[])text, (int)start, (int)end, (int)contextStart, (int)contextEnd, (boolean)isRtl, (int)offset, (float[])advances, (int)advancesIndex);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nSetTextLocalesByMinikinLangListId(long paintPtr, int mMinikinLangListId) {
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowPaint.class, ShadowNativePaint.class);
        }
    }
}

