/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.HardwareBuffer;
import android.os.Parcel;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.res.android.NativeObjRegistry;

@Implements(value=HardwareBuffer.class)
public class ShadowHardwareBuffer {
    private static final long INVALID_BUFFER_ID = 0L;
    private static final long USAGE_FLAGS_O = 25248563L;
    private static final long USAGE_FLAGS_P = 0x6000000L;
    private static final long VALID_USAGE_FLAGS;
    private static final NativeObjRegistry<BufferState> BUFFER_STATE_REGISTRY;

    @Implementation(minSdk=26)
    protected static long nCreateHardwareBuffer(int width, int height, int format, int layers, long usage) {
        if ((usage & (VALID_USAGE_FLAGS ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return 0L;
        }
        BufferState bufferState = new BufferState();
        bufferState.width = width;
        bufferState.height = height;
        bufferState.format = format;
        bufferState.layers = layers;
        bufferState.usage = usage;
        return BUFFER_STATE_REGISTRY.register((Object)bufferState);
    }

    @Implementation(minSdk=26)
    protected static void nWriteHardwareBufferToParcel(long nativeObject, Parcel dest) {
        BufferState bufferState = (BufferState)BUFFER_STATE_REGISTRY.getNativeObject(nativeObject);
        dest.writeInt(bufferState.width);
        dest.writeInt(bufferState.height);
        dest.writeInt(bufferState.format);
        dest.writeInt(bufferState.layers);
        dest.writeLong(bufferState.usage);
    }

    @Implementation(minSdk=26)
    protected static long nReadHardwareBufferFromParcel(Parcel in) {
        int width = in.readInt();
        int height = in.readInt();
        int format = in.readInt();
        int layers = in.readInt();
        long usage = in.readLong();
        return ShadowHardwareBuffer.nCreateHardwareBuffer(width, height, format, layers, usage);
    }

    @Implementation(minSdk=26)
    protected static int nGetWidth(long nativeObject) {
        return ((BufferState)ShadowHardwareBuffer.BUFFER_STATE_REGISTRY.getNativeObject((long)nativeObject)).width;
    }

    @Implementation(minSdk=26)
    protected static int nGetHeight(long nativeObject) {
        return ((BufferState)ShadowHardwareBuffer.BUFFER_STATE_REGISTRY.getNativeObject((long)nativeObject)).height;
    }

    @Implementation(minSdk=26)
    protected static int nGetFormat(long nativeObject) {
        return ((BufferState)ShadowHardwareBuffer.BUFFER_STATE_REGISTRY.getNativeObject((long)nativeObject)).format;
    }

    @Implementation(minSdk=26)
    protected static int nGetLayers(long nativeObject) {
        return ((BufferState)ShadowHardwareBuffer.BUFFER_STATE_REGISTRY.getNativeObject((long)nativeObject)).layers;
    }

    @Implementation(minSdk=26)
    protected static long nGetUsage(long nativeObject) {
        return ((BufferState)ShadowHardwareBuffer.BUFFER_STATE_REGISTRY.getNativeObject((long)nativeObject)).usage;
    }

    static {
        BUFFER_STATE_REGISTRY = new NativeObjRegistry(BufferState.class);
        long usageFlags = 0L;
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            usageFlags |= 0x1814333L;
        }
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            usageFlags |= 0x6000000L;
        }
        VALID_USAGE_FLAGS = usageFlags;
    }

    private static class BufferState {
        public int width;
        public int height;
        public int layers;
        public int format;
        public long usage;

        private BufferState() {
        }
    }
}

