/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.util;

import com.almworks.sqlite4java.SQLite;
import com.almworks.sqlite4java.SQLiteException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLiteLibraryLoader {
    private static SQLiteLibraryLoader instance;
    private static final String SQLITE4JAVA = "sqlite4java";
    private static final String OS_WIN = "win32";
    private static final String OS_LINUX = "linux";
    private static final String OS_MAC = "osx";
    private static final String OS_ARCH_ARM64 = "aarch64";
    private static final String SYSTEM_PROPERTY_OS_NAME = "os.name";
    private static final String SYSTEM_PROPERTY_OS_ARCH = "os.arch";
    private final LibraryNameMapper libraryNameMapper;
    private boolean loaded;
    private static final LibraryNameMapper DEFAULT_MAPPER;

    public SQLiteLibraryLoader() {
        this(DEFAULT_MAPPER);
    }

    public SQLiteLibraryLoader(LibraryNameMapper mapper) {
        this.libraryNameMapper = mapper;
    }

    public static synchronized void load() {
        if (instance == null) {
            instance = new SQLiteLibraryLoader();
        }
        instance.doLoad();
    }

    public void doLoad() {
        if (this.loaded) {
            return;
        }
        long startTime = System.currentTimeMillis();
        File tempDir = Files.createTempDir();
        tempDir.deleteOnExit();
        File extractedLibraryPath = new File(tempDir, this.getLibName());
        try (FileOutputStream outputStream = new FileOutputStream(extractedLibraryPath);){
            this.getLibraryByteSource().copyTo((OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot extract SQLite library into " + extractedLibraryPath, e);
        }
        this.loadFromDirectory(tempDir);
        this.logWithTime("SQLite natives prepared in", startTime);
    }

    public String getLibClasspathResourceName() {
        return "sqlite4java/" + this.getNativesResourcesPathPart() + "/" + this.getLibName();
    }

    private ByteSource getLibraryByteSource() {
        return Resources.asByteSource((URL)Resources.getResource((String)this.getLibClasspathResourceName()));
    }

    private void logWithTime(String message, long startTime) {
        this.log(message + " " + (System.currentTimeMillis() - startTime));
    }

    private void log(String message) {
        org.robolectric.util.Logger.debug((String)message, (Object[])new Object[0]);
    }

    @VisibleForTesting
    public boolean isLoaded() {
        return this.loaded;
    }

    public static boolean isOsSupported() {
        String prefix = SQLiteLibraryLoader.getOsPrefix();
        String arch = SQLiteLibraryLoader.getArchitecture();
        return !OS_MAC.equals(prefix) || !OS_ARCH_ARM64.equals(arch);
    }

    private void loadFromDirectory(File libPath) {
        Logger.getLogger("com.almworks.sqlite4java").setLevel(Level.WARNING);
        SQLite.setLibraryPath((String)libPath.getAbsolutePath());
        try {
            this.log("SQLite version: library " + SQLite.getLibraryVersion() + " / core " + SQLite.getSQLiteVersion());
        }
        catch (SQLiteException e) {
            throw new RuntimeException(e);
        }
        this.loaded = true;
    }

    private String getLibName() {
        return this.libraryNameMapper.mapLibraryName(SQLITE4JAVA);
    }

    private String getNativesResourcesPathPart() {
        String prefix = SQLiteLibraryLoader.getOsPrefix();
        String suffix = SQLiteLibraryLoader.getArchitectureSuffix(prefix);
        if (suffix != null) {
            return prefix + "-" + suffix;
        }
        return prefix;
    }

    private static String getOsPrefix() {
        String name = System.getProperty(SYSTEM_PROPERTY_OS_NAME).toLowerCase(Locale.US);
        if (name.contains("win")) {
            return OS_WIN;
        }
        if (name.contains(OS_LINUX)) {
            return OS_LINUX;
        }
        if (name.contains("mac")) {
            return OS_MAC;
        }
        throw new UnsupportedOperationException("Platform '" + name + "' is not supported by SQLite library");
    }

    private static String getArchitectureSuffix(String prefix) {
        String arch = SQLiteLibraryLoader.getArchitecture();
        switch (prefix) {
            case "osx": {
                if (OS_ARCH_ARM64.equals(arch)) break;
                return null;
            }
            case "linux": {
                switch (arch) {
                    case "i386": 
                    case "x86": {
                        return "i386";
                    }
                    case "x86_64": 
                    case "amd64": {
                        return "amd64";
                    }
                }
                break;
            }
            case "win32": {
                switch (arch) {
                    case "x86": {
                        return "x86";
                    }
                    case "x86_64": 
                    case "amd64": {
                        return "x64";
                    }
                }
            }
        }
        throw new UnsupportedOperationException("Architecture '" + arch + "' is not supported by SQLite library");
    }

    private static String getArchitecture() {
        return System.getProperty(SYSTEM_PROPERTY_OS_ARCH).toLowerCase(Locale.US).replaceAll("\\W", "");
    }

    static {
        DEFAULT_MAPPER = System::mapLibraryName;
    }

    public static interface LibraryNameMapper {
        public String mapLibraryName(String var1);
    }
}

