/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.audiofx.Visualizer;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Visualizer.class)
public class ShadowVisualizer {
    @RealObject
    private Visualizer realObject;
    private final AtomicReference<VisualizerSource> source = new AtomicReference<1>(new VisualizerSource(){});
    private boolean enabled = false;
    private Visualizer.OnDataCaptureListener captureListener = null;
    private boolean captureWaveform;
    private boolean captureFft;
    private int captureSize;
    private int errorCode;

    public void setSource(VisualizerSource source) {
        this.source.set(source);
    }

    @Implementation
    protected int setDataCaptureListener(Visualizer.OnDataCaptureListener listener, int rate, boolean waveform, boolean fft) {
        if (this.errorCode != 0) {
            return this.errorCode;
        }
        this.captureListener = listener;
        this.captureWaveform = waveform;
        this.captureFft = fft;
        return 0;
    }

    @Implementation
    protected int native_getSamplingRate() {
        return this.source.get().getSamplingRate();
    }

    @Implementation
    protected int native_getWaveForm(byte[] waveform) {
        return this.source.get().getWaveForm(waveform);
    }

    @Implementation
    protected int native_getFft(byte[] fft) {
        return this.source.get().getFft(fft);
    }

    @Implementation
    protected boolean native_getEnabled() {
        return this.enabled;
    }

    @Implementation
    protected int native_setCaptureSize(int size) {
        if (this.errorCode != 0) {
            return this.errorCode;
        }
        this.captureSize = size;
        return 0;
    }

    @Implementation
    protected int native_getCaptureSize() {
        return this.captureSize;
    }

    @Implementation
    protected int native_setEnabled(boolean enabled) {
        if (this.errorCode != 0) {
            return this.errorCode;
        }
        this.enabled = enabled;
        return 0;
    }

    @Implementation
    protected int native_getPeakRms(Visualizer.MeasurementPeakRms measurement) {
        return this.source.get().getPeakRms(measurement);
    }

    @Implementation
    protected void native_release() {
        this.source.get().release();
    }

    public void triggerDataCapture() {
        if (this.captureListener == null) {
            return;
        }
        if (this.captureWaveform) {
            byte[] waveform = new byte[this.captureSize];
            this.realObject.getWaveForm(waveform);
            this.captureListener.onWaveFormDataCapture(this.realObject, waveform, this.realObject.getSamplingRate());
        }
        if (this.captureFft) {
            byte[] fft = new byte[this.captureSize];
            this.realObject.getFft(fft);
            this.captureListener.onFftDataCapture(this.realObject, fft, this.realObject.getSamplingRate());
        }
    }

    public void setState(int newState) {
        ((ReflectorVisualizer)Reflector.reflector(ReflectorVisualizer.class, (Object)this.realObject)).setState(newState);
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public static interface VisualizerSource {
        default public int getSamplingRate() {
            return 0;
        }

        default public int getWaveForm(byte[] waveform) {
            return 0;
        }

        default public int getFft(byte[] fft) {
            return 0;
        }

        default public int getPeakRms(Visualizer.MeasurementPeakRms measurement) {
            return 0;
        }

        default public void release() {
        }
    }

    @ForType(value=Visualizer.class)
    private static interface ReflectorVisualizer {
        @Accessor(value="mState")
        public void setState(int var1);
    }
}

