/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.translation.TranslationCapability;
import android.view.translation.TranslationManager;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=TranslationManager.class, minSdk=31)
public class ShadowTranslationManager {
    private final Table<Integer, Integer, ImmutableSet<TranslationCapability>> onDeviceTranslationCapabilities = HashBasedTable.create();

    @Implementation
    protected Set<TranslationCapability> getOnDeviceTranslationCapabilities(int sourceFormat, int targetFormat) {
        if (!this.onDeviceTranslationCapabilities.contains((Object)sourceFormat, (Object)targetFormat)) {
            return ImmutableSet.of();
        }
        return (Set)this.onDeviceTranslationCapabilities.get((Object)sourceFormat, (Object)targetFormat);
    }

    public void setOnDeviceTranslationCapabilities(int sourceFormat, int targetFormat, Set<TranslationCapability> capabilities) {
        this.onDeviceTranslationCapabilities.put((Object)sourceFormat, (Object)targetFormat, (Object)ImmutableSet.copyOf(capabilities));
    }
}

