/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowView;

@Implements(value=SurfaceView.class)
public class ShadowSurfaceView
extends ShadowView {
    private final FakeSurfaceHolder fakeSurfaceHolder = new FakeSurfaceHolder();

    @Implementation
    protected void onAttachedToWindow() {
    }

    @Implementation
    protected SurfaceHolder getHolder() {
        return this.fakeSurfaceHolder;
    }

    public FakeSurfaceHolder getFakeSurfaceHolder() {
        return this.fakeSurfaceHolder;
    }

    public static class FakeSurfaceHolder
    implements SurfaceHolder {
        private final Set<SurfaceHolder.Callback> callbacks = new HashSet<SurfaceHolder.Callback>();
        private int requestedFormat = 4;

        public void addCallback(SurfaceHolder.Callback callback) {
            this.callbacks.add(callback);
        }

        public Set<SurfaceHolder.Callback> getCallbacks() {
            return this.callbacks;
        }

        public void removeCallback(SurfaceHolder.Callback callback) {
            this.callbacks.remove(callback);
        }

        public boolean isCreating() {
            return false;
        }

        public void setType(int i) {
        }

        public void setFixedSize(int i, int i1) {
        }

        public void setSizeFromLayout() {
        }

        public void setFormat(int format) {
            this.requestedFormat = format == -1 ? 4 : format;
        }

        public void setKeepScreenOn(boolean b) {
        }

        public Canvas lockCanvas() {
            return null;
        }

        public Canvas lockCanvas(Rect rect) {
            return null;
        }

        public void unlockCanvasAndPost(Canvas canvas) {
        }

        public Rect getSurfaceFrame() {
            return null;
        }

        public Surface getSurface() {
            return null;
        }

        public int getRequestedFormat() {
            return this.requestedFormat;
        }
    }
}

