/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityManager;
import android.content.ComponentName;
import org.robolectric.RuntimeEnvironment;

public class RunningTaskInfoBuilder {
    private boolean isVisible;
    private int taskId;
    private ComponentName baseActivity;
    private ComponentName topActivity;

    private RunningTaskInfoBuilder() {
    }

    public static RunningTaskInfoBuilder newBuilder() {
        return new RunningTaskInfoBuilder();
    }

    public RunningTaskInfoBuilder setTaskId(int taskId) {
        this.taskId = taskId;
        return this;
    }

    public RunningTaskInfoBuilder setIsVisible(boolean visible) {
        this.isVisible = visible;
        return this;
    }

    public RunningTaskInfoBuilder setBaseActivity(ComponentName baseActivity) {
        this.baseActivity = baseActivity;
        return this;
    }

    public RunningTaskInfoBuilder setTopActivity(ComponentName topActivity) {
        this.topActivity = topActivity;
        return this;
    }

    public ActivityManager.RunningTaskInfo build() {
        ActivityManager.RunningTaskInfo taskInfo = new ActivityManager.RunningTaskInfo();
        taskInfo.baseActivity = this.baseActivity;
        taskInfo.topActivity = this.topActivity;
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            taskInfo.taskId = this.taskId;
        }
        if (RuntimeEnvironment.getApiLevel() >= 31) {
            taskInfo.isVisible = this.isVisible;
        }
        return taskInfo;
    }
}

