/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Parcel;
import android.telephony.CellIdentityNr;
import android.telephony.CellInfoNr;
import android.telephony.CellSignalStrengthNr;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.shadows.CellIdentityNrBuilder;
import org.robolectric.shadows.CellSignalStrengthNrBuilder;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

public class CellInfoNrBuilder {
    private boolean isRegistered = false;
    private long timeStamp = 0L;
    private int cellConnectionStatus = 0;
    private CellIdentityNr cellIdentity;
    private CellSignalStrengthNr cellSignalStrength;

    private CellInfoNrBuilder() {
    }

    public static CellInfoNrBuilder newBuilder() {
        return new CellInfoNrBuilder();
    }

    public CellInfoNrBuilder setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
        return this;
    }

    public CellInfoNrBuilder setTimeStampNanos(long timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public CellInfoNrBuilder setCellConnectionStatus(int cellConnectionStatus) {
        this.cellConnectionStatus = cellConnectionStatus;
        return this;
    }

    public CellInfoNrBuilder setCellIdentity(CellIdentityNr cellIdentity) {
        this.cellIdentity = cellIdentity;
        return this;
    }

    public CellInfoNrBuilder setCellSignalStrength(CellSignalStrengthNr cellSignalStrength) {
        this.cellSignalStrength = cellSignalStrength;
        return this;
    }

    public CellInfoNr build() {
        if (this.cellIdentity == null) {
            this.cellIdentity = CellIdentityNrBuilder.getDefaultInstance();
        }
        if (this.cellSignalStrength == null) {
            this.cellSignalStrength = CellSignalStrengthNrBuilder.getDefaultInstance();
        }
        if (RuntimeEnvironment.getApiLevel() <= 33) {
            Parcel p = Parcel.obtain();
            p.writeInt(6);
            p.writeInt(this.isRegistered ? 1 : 0);
            p.writeLong(this.timeStamp);
            p.writeInt(this.cellConnectionStatus);
            this.cellIdentity.writeToParcel(p, 0);
            this.cellSignalStrength.writeToParcel(p, 0);
            p.setDataPosition(0);
            CellInfoNr cellInfoNr = (CellInfoNr)CellInfoNr.CREATOR.createFromParcel(p);
            p.recycle();
            return cellInfoNr;
        }
        return ((CellInfoNrReflector)Reflector.reflector(CellInfoNrReflector.class)).newCellInfoNr(this.cellConnectionStatus, this.isRegistered, this.timeStamp, this.cellIdentity, this.cellSignalStrength);
    }

    @ForType(value=CellInfoNr.class)
    private static interface CellInfoNrReflector {
        @Constructor
        public CellInfoNr newCellInfoNr(int var1, boolean var2, long var3, CellIdentityNr var5, CellSignalStrengthNr var6);
    }
}

