/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractFuture;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import org.robolectric.util.Logger;

@Beta
public class PausedExecutorService
extends AbstractExecutorService {
    private final ExecutorService realService;
    private final Queue<Runnable> deferredTasks = new ConcurrentLinkedQueue<Runnable>();
    private Thread executorThread;

    static <T> T getFutureResultWithExceptionPreserved(Future<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new RuntimeException(e);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public PausedExecutorService() {
        this.realService = Executors.newSingleThreadExecutor(r -> {
            this.executorThread = new Thread(r);
            return this.executorThread;
        });
    }

    public int runAll() {
        int numTasksRun = 0;
        if (Thread.currentThread().equals(this.executorThread)) {
            Logger.info((String)"ignoring request to execute task - called from executor's own thread", (Object[])new Object[0]);
            return numTasksRun;
        }
        while (this.hasQueuedTasks()) {
            this.runNext();
            ++numTasksRun;
        }
        return numTasksRun;
    }

    public boolean runNext() {
        if (!this.hasQueuedTasks()) {
            return false;
        }
        if (Thread.currentThread().equals(this.executorThread)) {
            Logger.info((String)"ignoring request to execute task - called from executor's own thread", (Object[])new Object[0]);
            return false;
        }
        Runnable task = this.deferredTasks.poll();
        task.run();
        return true;
    }

    public boolean hasQueuedTasks() {
        return !this.deferredTasks.isEmpty();
    }

    @Override
    public void shutdown() {
        this.realService.shutdown();
        this.deferredTasks.clear();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.realService.shutdownNow();
        ImmutableList copy = ImmutableList.copyOf(this.deferredTasks);
        this.deferredTasks.clear();
        return copy;
    }

    @Override
    public boolean isShutdown() {
        return this.realService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.realService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.realService.awaitTermination(l, timeUnit);
    }

    @Override
    public void execute(Runnable command) {
        if (command instanceof DeferredTask) {
            this.deferredTasks.add(command);
        } else {
            this.deferredTasks.add(new DeferredTask<Object>(Executors.callable(command), this.realService));
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return this.newTaskFor(Executors.callable(runnable, value));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new DeferredTask<T>(callable, this.realService);
    }

    private static class DeferredTask<V>
    extends AbstractFuture<V>
    implements RunnableFuture<V> {
        private final Callable<V> callable;
        private final ExecutorService executor;

        DeferredTask(Callable<V> callable, ExecutorService executor) {
            this.callable = callable;
            this.executor = executor;
        }

        @Override
        public void run() {
            Future<V> future = this.executor.submit(this.callable);
            this.set(PausedExecutorService.getFutureResultWithExceptionPreserved(future));
        }
    }
}

